/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.ruleunits.impl.sessions.RuleUnitStatefulKnowledgeSessionImpl;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.util.PatternConstants;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.MVELProcessHelper;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.ProcessInstanceResolverFactory;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.SubProcessNodeInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.internal.KieInternalServices;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.internal.runtime.CommandBasedStatefulKnowledgeSession;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.kogito.internal.process.event.KogitoProcessEventSupport;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstanceContainer;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.process.workitems.InternalKogitoWorkItem;
import org.kie.kogito.process.workitems.InternalKogitoWorkItemManager;
import org.kie.kogito.process.workitems.impl.KogitoWorkItemImpl;
import org.mvel2.integration.VariableResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicUtils {
    private static final Logger logger = LoggerFactory.getLogger(DynamicUtils.class);

    public static void addDynamicWorkItem(DynamicNodeInstance dynamicContext, KieRuntime ksession, String workItemName, Map<String, Object> parameters) {
        WorkflowProcessInstance processInstance = dynamicContext.getProcessInstance();
        DynamicUtils.internalAddDynamicWorkItem(processInstance, dynamicContext, ksession, workItemName, parameters);
    }

    public static void addDynamicWorkItem(ProcessInstance dynamicProcessInstance, KieRuntime ksession, String workItemName, Map<String, Object> parameters) {
        DynamicUtils.internalAddDynamicWorkItem((WorkflowProcessInstance)dynamicProcessInstance, null, ksession, workItemName, parameters);
    }

    private static void internalAddDynamicWorkItem(final WorkflowProcessInstance processInstance, final DynamicNodeInstance dynamicContext, KieRuntime ksession, String workItemName, Map<String, Object> parameters) {
        final KogitoWorkItemImpl workItem = new KogitoWorkItemImpl();
        workItem.setState(1);
        workItem.setProcessInstanceId(processInstance.getStringId());
        workItem.setDeploymentId((String)ksession.getEnvironment().get("deploymentId"));
        workItem.setName(workItemName);
        workItem.setParameters(parameters);
        for (Map.Entry entry : workItem.getParameters().entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            String s = (String)entry.getValue();
            Object variableValue = null;
            Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(s);
            while (matcher.find()) {
                String paramName = matcher.group(1);
                variableValue = processInstance.getVariable(paramName);
                if (variableValue != null) continue;
                try {
                    variableValue = MVELProcessHelper.evaluator().eval(paramName, (VariableResolverFactory)new ProcessInstanceResolverFactory((org.kie.api.runtime.process.WorkflowProcessInstance)processInstance));
                }
                catch (Exception t) {
                    logger.error("Could not find variable scope for variable {}", (Object)paramName);
                    logger.error("when trying to replace variable in string for Dynamic Work Item {}", (Object)workItemName);
                    logger.error("Continuing without setting parameter.");
                }
            }
            if (variableValue == null) continue;
            workItem.setParameter((String)entry.getKey(), variableValue);
        }
        final WorkItemNodeInstance workItemNodeInstance = new WorkItemNodeInstance();
        workItemNodeInstance.internalSetWorkItem((InternalKogitoWorkItem)workItem);
        workItemNodeInstance.setMetaData("NodeType", workItemName);
        workItem.setNodeInstanceId(workItemNodeInstance.getStringId());
        if (ksession instanceof StatefulKnowledgeSessionImpl) {
            workItemNodeInstance.setProcessInstance(processInstance);
            workItemNodeInstance.setNodeInstanceContainer((KogitoNodeInstanceContainer)(dynamicContext == null ? processInstance : dynamicContext));
            workItemNodeInstance.addEventListeners();
            DynamicUtils.executeWorkItem((StatefulKnowledgeSessionImpl)ksession, workItem, workItemNodeInstance);
        } else if (ksession instanceof CommandBasedStatefulKnowledgeSession) {
            ExecutableRunner runner = ((CommandBasedStatefulKnowledgeSession)ksession).getRunner();
            runner.execute((Command)new ExecutableCommand<Void>(){
                private static final long serialVersionUID = 5L;

                public Void execute(Context context) {
                    StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)((RegistryContext)context).lookup(KieSession.class);
                    KogitoProcessRuntime kruntime = InternalProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)ksession);
                    WorkflowProcessInstance realProcessInstance = (WorkflowProcessInstance)kruntime.getProcessInstance(processInstance.getStringId());
                    workItemNodeInstance.setProcessInstance(realProcessInstance);
                    if (dynamicContext == null) {
                        workItemNodeInstance.setNodeInstanceContainer(realProcessInstance);
                    } else {
                        DynamicNodeInstance realDynamicContext = DynamicUtils.findDynamicContext(realProcessInstance, dynamicContext.getUniqueId());
                        workItemNodeInstance.setNodeInstanceContainer(realDynamicContext);
                    }
                    workItemNodeInstance.addEventListeners();
                    DynamicUtils.executeWorkItem((StatefulKnowledgeSessionImpl)ksession, workItem, workItemNodeInstance);
                    return null;
                }
            });
        } else {
            throw new IllegalArgumentException("Unsupported ksession: " + (ksession == null ? "null" : ksession.getClass().getName()));
        }
    }

    private static void executeWorkItem(StatefulKnowledgeSessionImpl ksession, KogitoWorkItemImpl workItem, WorkItemNodeInstance workItemNodeInstance) {
        KogitoProcessRuntime kruntime = InternalProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)ksession);
        KogitoProcessEventSupport eventSupport = kruntime.getProcessEventSupport();
        eventSupport.fireBeforeNodeTriggered((KogitoNodeInstance)workItemNodeInstance, (KieRuntime)ksession);
        ((InternalKogitoWorkItemManager)kruntime.getKogitoWorkItemManager()).internalExecuteWorkItem((InternalKogitoWorkItem)workItem);
        workItemNodeInstance.internalSetWorkItemId(workItem.getStringId());
        eventSupport.fireAfterNodeTriggered((KogitoNodeInstance)workItemNodeInstance, (KieRuntime)ksession);
    }

    private static DynamicNodeInstance findDynamicContext(WorkflowProcessInstance processInstance, String uniqueId) {
        for (NodeInstance nodeInstance : ((WorkflowProcessInstanceImpl)processInstance).getNodeInstances(true)) {
            if (!uniqueId.equals(((NodeInstanceImpl)nodeInstance).getUniqueId())) continue;
            return (DynamicNodeInstance)nodeInstance;
        }
        throw new IllegalArgumentException("Could not find node instance " + uniqueId);
    }

    public static String addDynamicSubProcess(DynamicNodeInstance dynamicContext, KieRuntime ksession, String processId, Map<String, Object> parameters) {
        WorkflowProcessInstance processInstance = dynamicContext.getProcessInstance();
        return DynamicUtils.internalAddDynamicSubProcess(processInstance, dynamicContext, ksession, processId, parameters);
    }

    public static String addDynamicSubProcess(ProcessInstance processInstance, KieRuntime ksession, String processId, Map<String, Object> parameters) {
        return DynamicUtils.internalAddDynamicSubProcess((WorkflowProcessInstance)processInstance, null, ksession, processId, parameters);
    }

    public static String internalAddDynamicSubProcess(final WorkflowProcessInstance processInstance, final DynamicNodeInstance dynamicContext, KieRuntime ksession, final String processId, final Map<String, Object> parameters) {
        final SubProcessNodeInstance subProcessNodeInstance = new SubProcessNodeInstance();
        subProcessNodeInstance.setNodeInstanceContainer((KogitoNodeInstanceContainer)(dynamicContext == null ? processInstance : dynamicContext));
        subProcessNodeInstance.setProcessInstance(processInstance);
        subProcessNodeInstance.setMetaData("NodeType", "SubProcessNode");
        if (ksession instanceof StatefulKnowledgeSessionImpl) {
            return DynamicUtils.executeSubProcess((StatefulKnowledgeSessionImpl)ksession, processId, parameters, processInstance, subProcessNodeInstance);
        }
        if (ksession instanceof CommandBasedStatefulKnowledgeSession) {
            ExecutableRunner commandService = ((CommandBasedStatefulKnowledgeSession)ksession).getRunner();
            return (String)commandService.execute((Command)new ExecutableCommand<String>(){
                private static final long serialVersionUID = 5L;

                public String execute(Context context) {
                    StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)((RegistryContext)context).lookup(KieSession.class);
                    KogitoProcessRuntime kruntime = InternalProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)ksession);
                    WorkflowProcessInstance realProcessInstance = (WorkflowProcessInstance)kruntime.getProcessInstance(processInstance.getStringId());
                    subProcessNodeInstance.setProcessInstance(realProcessInstance);
                    if (dynamicContext == null) {
                        subProcessNodeInstance.setNodeInstanceContainer(realProcessInstance);
                    } else {
                        DynamicNodeInstance realDynamicContext = DynamicUtils.findDynamicContext(realProcessInstance, dynamicContext.getUniqueId());
                        subProcessNodeInstance.setNodeInstanceContainer(realDynamicContext);
                    }
                    return DynamicUtils.executeSubProcess((StatefulKnowledgeSessionImpl)ksession, processId, parameters, processInstance, subProcessNodeInstance);
                }
            });
        }
        throw new IllegalArgumentException("Unsupported ksession: " + (ksession == null ? "null" : ksession.getClass().getName()));
    }

    private static String executeSubProcess(StatefulKnowledgeSessionImpl ksession, String processId, Map<String, Object> parameters, org.jbpm.process.instance.ProcessInstance processInstance, SubProcessNodeInstance subProcessNodeInstance) {
        Process process = ksession.getKieBase().getProcess(processId);
        if (process == null) {
            logger.error("Could not find process {}", (Object)processId);
            throw new IllegalArgumentException("No process definition found with id: " + processId);
        }
        KogitoProcessEventSupport eventSupport = ((InternalProcessRuntime)ksession.getProcessRuntime()).getProcessEventSupport();
        eventSupport.fireBeforeNodeTriggered((KogitoNodeInstance)subProcessNodeInstance, (KieRuntime)ksession);
        org.jbpm.process.instance.ProcessInstance subProcessInstance = null;
        if (((WorkflowProcessInstanceImpl)processInstance).getCorrelationKey() != null) {
            ArrayList<String> businessKeys = new ArrayList<String>();
            businessKeys.add(((WorkflowProcessInstanceImpl)processInstance).getCorrelationKey());
            businessKeys.add(processId);
            businessKeys.add(String.valueOf(System.currentTimeMillis()));
            CorrelationKeyFactory correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
            CorrelationKey subProcessCorrelationKey = correlationKeyFactory.newCorrelationKey(businessKeys);
            subProcessInstance = (org.jbpm.process.instance.ProcessInstance)ksession.createProcessInstance(processId, subProcessCorrelationKey, parameters);
        } else {
            subProcessInstance = (org.jbpm.process.instance.ProcessInstance)ksession.createProcessInstance(processId, parameters);
        }
        subProcessInstance.setMetaData("ParentProcessInstanceId", processInstance.getStringId());
        subProcessInstance.setParentProcessInstanceId(processInstance.getStringId());
        RuleUnitStatefulKnowledgeSessionImpl kogitoSession = (RuleUnitStatefulKnowledgeSessionImpl)ksession;
        String subProcessInstanceId = subProcessInstance.getStringId();
        subProcessInstance = (org.jbpm.process.instance.ProcessInstance)InternalProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)kogitoSession).startProcessInstance(subProcessInstanceId);
        subProcessNodeInstance.internalSetProcessInstanceId(subProcessInstanceId);
        eventSupport.fireAfterNodeTriggered((KogitoNodeInstance)subProcessNodeInstance, (KieRuntime)ksession);
        if (subProcessInstance.getState() == 2) {
            subProcessNodeInstance.triggerCompleted();
        } else {
            subProcessNodeInstance.addEventListeners();
        }
        return subProcessInstanceId;
    }

    private DynamicUtils() {
    }
}

