/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.util.PatternConstants;
import org.jbpm.workflow.core.impl.NodeIoHelper;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.DummyEventListener;
import org.jbpm.workflow.instance.impl.ExtendedNodeInstanceImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.EventBasedNodeInstanceInterface;
import org.jbpm.workflow.instance.node.EventNodeInstanceInterface;
import org.kie.api.runtime.KieRuntime;
import org.kie.kogito.internal.process.event.KogitoEventListener;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.process.BaseEventDescription;
import org.kie.kogito.process.EventDescription;
import org.kie.kogito.process.NamedDataType;
import org.kie.kogito.timer.TimerInstance;

public class EventNodeInstance
extends ExtendedNodeInstanceImpl
implements KogitoEventListener,
EventNodeInstanceInterface,
EventBasedNodeInstanceInterface {
    private static final long serialVersionUID = 510L;

    @Override
    public void signalEvent(String type, Object event, Function<String, Object> varResolver) {
        if ("timerTriggered".equals(type)) {
            TimerInstance timerInstance = (TimerInstance)event;
            if (timerInstance.getId().equals(this.slaTimerId)) {
                this.handleSLAViolation();
            }
        } else if (("slaViolation:" + this.getStringId()).equals(type)) {
            this.handleSLAViolation();
        } else {
            EventNode eventNode = (EventNode)this.getNode();
            HashMap<String, Object> outputSet = new HashMap<String, Object>();
            outputSet.put(eventNode.getInputVariableName(), event);
            NodeIoHelper.processOutputs(this, key -> outputSet.get(key), varName -> this.getVariable((String)varName));
            this.triggerCompleted();
        }
    }

    public void signalEvent(String type, Object event) {
        this.signalEvent(type, event, varName -> this.getVariable((String)varName));
    }

    @Override
    public void internalTrigger(KogitoNodeInstance from, String type) {
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("An EventNode only accepts default incoming connections!");
        }
        this.triggerTime = new Date();
        this.addEventListeners();
    }

    @Override
    protected void configureSla() {
        TimerInstance timer;
        String slaDueDateExpression = (String)this.getNode().getMetaData().get("customSLADueDate");
        if (slaDueDateExpression != null && (timer = ((WorkflowProcessInstanceImpl)this.getProcessInstance()).configureSLATimer(slaDueDateExpression)) != null) {
            this.slaTimerId = timer.getId();
            this.slaDueDate = new Date(System.currentTimeMillis() + timer.getDelay());
            this.slaCompliance = 1;
            logger.debug("SLA for node instance {} is PENDING with due date {}", (Object)this.getStringId(), (Object)this.slaDueDate);
        }
    }

    protected void handleSLAViolation() {
        if (this.slaCompliance == 1) {
            InternalProcessRuntime processRuntime = (InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime();
            processRuntime.getProcessEventSupport().fireBeforeSLAViolated((KogitoProcessInstance)this.getProcessInstance(), (KogitoNodeInstance)this, (KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
            logger.debug("SLA violated on node instance {}", (Object)this.getStringId());
            this.slaCompliance = 3;
            this.slaTimerId = null;
            processRuntime.getProcessEventSupport().fireAfterSLAViolated((KogitoProcessInstance)this.getProcessInstance(), (KogitoNodeInstance)this, (KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
        }
    }

    private void cancelSlaTimer() {
        if (this.slaTimerId != null && !this.slaTimerId.trim().isEmpty()) {
            JobsService jobService = ((InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getJobsService();
            jobService.cancelJob(this.slaTimerId);
            logger.debug("SLA Timer {} has been canceled", (Object)this.slaTimerId);
        }
    }

    protected void addTimerListener() {
        this.getProcessInstance().addEventListener("timerTriggered", new VariableExternalEventListener("timerTriggered"), false);
        this.getProcessInstance().addEventListener("timer", new VariableExternalEventListener("timer"), true);
        this.getProcessInstance().addEventListener("slaViolation:" + this.getStringId(), new VariableExternalEventListener("slaViolation"), true);
    }

    public void removeTimerListeners() {
        this.getProcessInstance().removeEventListener("timerTriggered", new VariableExternalEventListener("timerTriggered"), false);
        this.getProcessInstance().removeEventListener("timer", new VariableExternalEventListener("timer"), true);
        this.getProcessInstance().removeEventListener("slaViolation:" + this.getStringId(), new VariableExternalEventListener("slaViolation"), true);
    }

    public EventNode getEventNode() {
        return (EventNode)this.getNode();
    }

    public void triggerCompleted() {
        this.getProcessInstance().removeEventListener(this.getEventType(), this.getEventListener(), true);
        this.removeTimerListeners();
        if (this.slaCompliance == 1) {
            this.slaCompliance = System.currentTimeMillis() > this.slaDueDate.getTime() ? 3 : 2;
        }
        this.cancelSlaTimer();
        ((NodeInstanceContainer)this.getNodeInstanceContainer()).setCurrentLevel(this.getLevel());
        this.triggerCompleted("DROOLS_DEFAULT", true);
    }

    @Override
    public void cancel() {
        this.getProcessInstance().removeEventListener(this.getEventType(), this.getEventListener(), true);
        this.removeTimerListeners();
        if (this.slaCompliance == 1) {
            this.slaCompliance = System.currentTimeMillis() > this.slaDueDate.getTime() ? 3 : 4;
        }
        this.removeTimerListeners();
        super.cancel();
    }

    @Override
    public void addEventListeners() {
        String eventType = this.getEventType();
        if (this.isVariableExpression(this.getEventNode().getType())) {
            this.getProcessInstance().addEventListener(eventType, new VariableExternalEventListener(eventType), true);
        } else {
            this.getProcessInstance().addEventListener(eventType, this.getEventListener(), true);
        }
        if (this.slaTimerId != null && !this.slaTimerId.trim().isEmpty()) {
            this.addTimerListener();
        }
    }

    @Override
    public void removeEventListeners() {
    }

    public String getEventType() {
        return this.resolveExpression(this.getEventNode().getType());
    }

    protected KogitoEventListener getEventListener() {
        return DummyEventListener.EMPTY_EVENT_LISTENER;
    }

    private boolean isVariableExpression(String eventType) {
        if (eventType == null) {
            return false;
        }
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(eventType);
        return matcher.find();
    }

    private void callSignal(String type, Object event) {
        this.signalEvent(type, event);
    }

    public String[] getEventTypes() {
        return new String[]{this.getEventType()};
    }

    public Set<EventDescription<?>> getEventDescriptions() {
        NamedDataType dataType = null;
        if (this.getEventNode().getVariableName() != null) {
            VariableScope variableScope = (VariableScope)this.getEventNode().getContext("VariableScope");
            Variable variable = variableScope.findVariable(this.getEventNode().getVariableName());
            dataType = new NamedDataType(variable.getName(), (Object)variable.getType());
        }
        return Collections.singleton(new BaseEventDescription(this.getEventType(), this.getNodeDefinitionId(), this.getNodeName(), "signal", this.getStringId(), this.getProcessInstance().getStringId(), dataType));
    }

    private class VariableExternalEventListener
    implements KogitoEventListener,
    Serializable {
        private static final long serialVersionUID = 5L;
        private String eventType;

        VariableExternalEventListener(String eventType) {
            this.eventType = eventType;
        }

        public String[] getEventTypes() {
            return new String[]{this.eventType};
        }

        public void signalEvent(String type, Object event) {
            EventNodeInstance.this.callSignal(type, event);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.eventType == null ? 0 : this.eventType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VariableExternalEventListener other = (VariableExternalEventListener)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.eventType == null ? other.eventType != null : !this.eventType.equals(other.eventType));
        }

        private EventNodeInstance getOuterType() {
            return EventNodeInstance.this;
        }
    }
}

