/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.kie.kogito.process.validation.ValidationError;

public class ValidationContext {
    private ThreadLocal<Map<String, Collection<ValidationError>>> context = new ThreadLocal();
    private ThreadLocal<Exception> exceptionHolder = new ThreadLocal();
    private static ValidationContext instance;

    private ValidationContext() {
    }

    public static ValidationContext get() {
        return Optional.ofNullable(instance).orElseGet(() -> {
            instance = new ValidationContext();
            return instance;
        });
    }

    public ValidationContext add(String resourceId, ValidationError error) {
        this.getErrors(resourceId).add(error);
        return this;
    }

    public ValidationContext putException(Exception exception) {
        this.exceptionHolder.set(exception);
        return this;
    }

    public Optional<Exception> exception() {
        return Optional.ofNullable(this.exceptionHolder.get());
    }

    public ValidationContext add(String resourceId, Collection<ValidationError> errors) {
        this.getErrors(resourceId).addAll(errors);
        return this;
    }

    private Collection<ValidationError> getErrors(String resourceId) {
        this.getContext().putIfAbsent(resourceId, new ArrayList());
        return this.getContext().get(resourceId);
    }

    public Collection<ValidationError> errors(String resourceId) {
        return Collections.unmodifiableCollection(this.getContext().get(resourceId));
    }

    public boolean hasErrors(String resourceId) {
        return this.getContext().containsKey(resourceId);
    }

    public boolean hasErrors() {
        return !this.getContext().isEmpty();
    }

    public void clear() {
        if (Objects.isNull(this.context.get())) {
            return;
        }
        this.context.get().values().forEach(Collection::clear);
        this.context.get().clear();
        this.context.remove();
        this.exceptionHolder.remove();
    }

    public Set<String> resourcesWithError() {
        return this.getContext().keySet();
    }

    private Map<String, Collection<ValidationError>> getContext() {
        return Optional.ofNullable(this.context.get()).orElseGet(() -> {
            this.context.set(new HashMap());
            return this.context.get();
        });
    }
}

