/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.expr;

import java.util.Optional;
import java.util.ServiceLoader;
import org.kie.kogito.process.expr.Expression;
import org.kie.kogito.process.expr.ExpressionHandler;

public class ExpressionHandlerFactory {
    private static final ServiceLoader<ExpressionHandler> serviceLoader = ServiceLoader.load(ExpressionHandler.class);

    private ExpressionHandlerFactory() {
    }

    public static Expression get(String lang, String expr) {
        return ExpressionHandlerFactory.getExpressionHandler(lang).orElseThrow(() -> new IllegalArgumentException("Unsupported language " + lang)).get(expr);
    }

    public static boolean isSupported(String lang) {
        return serviceLoader.stream().anyMatch(p -> ((ExpressionHandler)p.get()).lang().equals(lang));
    }

    private static Optional<ExpressionHandler> getExpressionHandler(String lang) {
        return serviceLoader.stream().filter(p -> ((ExpressionHandler)p.get()).lang().equals(lang)).findFirst().map(p -> (ExpressionHandler)p.get());
    }
}

