/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.context.exception;

import java.io.IOException;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.jbpm.process.core.context.exception.ExceptionHandlerPolicy;
import org.jbpm.process.core.context.exception.ExceptionHandlerPolicyFactory;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.kie.kogito.process.workitem.WorkItemExecutionException;

class ExceptionHandlerPolicyTest {
    private static Collection<ExceptionHandlerPolicy> policies;

    ExceptionHandlerPolicyTest() {
    }

    @BeforeAll
    static void setup() {
        policies = ExceptionHandlerPolicyFactory.getHandlerPolicies();
    }

    @ParameterizedTest
    @ValueSource(strings={"java.lang.RuntimeException", "Unknown error", "(?i)Status code 400", "(.*)code 4[0-9]{2}", "code 4[0-9]{2}"})
    void testExceptionHandlerPolicyFactory(String errorString) {
        IllegalStateException exception = new IllegalStateException("Unknown error, status code 400");
        Assertions.assertThat((boolean)this.test(errorString, exception)).isTrue();
    }

    @ParameterizedTest
    @ValueSource(strings={"java.lang.RuntimeException", "Unknown error", "(?i)Status code 400", "(.*)code 4[0-9]{2}", "code 4[0-9]{2}"})
    void testExceptionChainPolicyFactory(String errorString) {
        IOException exception = new IOException(new RuntimeException("Unknown error, status code 400"));
        Assertions.assertThat((boolean)this.test(errorString, exception)).isTrue();
    }

    @ParameterizedTest
    @ValueSource(strings={"["})
    void testInvalidRegexExceptionHandlerPolicyFactory(String errorString) {
        IllegalStateException exception = new IllegalStateException("Unknown error, status code 400");
        Assertions.assertThat((boolean)this.test(errorString, exception)).isFalse();
    }

    @ParameterizedTest
    @ValueSource(strings={"HTTP:500", "500"})
    void testWebExceptionHandlerPolicyFactory(String errorString) {
        WorkItemExecutionException exception = new WorkItemExecutionException("500", "Unknown error");
        Assertions.assertThat((boolean)this.test(errorString, (Throwable)exception)).isTrue();
    }

    @ParameterizedTest
    @ValueSource(strings={"HTTP:xyz", "xyz"})
    void testWebExceptionHandlerPolicyFactoryIncorrectFormat(String errorString) {
        WorkItemExecutionException exception = new WorkItemExecutionException("500", "Unknown error");
        Assertions.assertThat((boolean)this.test(errorString, (Throwable)exception)).isFalse();
    }

    private boolean test(String className, Throwable exception) {
        return policies.stream().anyMatch(p -> p.test((Object)className, (Object)exception));
    }
}

