/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype;

import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.jbpm.process.core.datatype.DataTypeResolver;
import org.jbpm.process.core.datatype.impl.type.BooleanDataType;
import org.jbpm.process.core.datatype.impl.type.EnumDataType;
import org.jbpm.process.core.datatype.impl.type.FloatDataType;
import org.jbpm.process.core.datatype.impl.type.IntegerDataType;
import org.jbpm.process.core.datatype.impl.type.ListDataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.process.core.datatype.impl.type.StringDataType;
import org.junit.jupiter.api.Test;

public class DataTypeResolverTest {
    @Test
    public void testDataType() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Assertions.assertThat((Object)DataTypeResolver.fromObject((Object)"pepe")).isInstanceOf(StringDataType.class);
        Assertions.assertThat((Object)DataTypeResolver.fromObject((Object)true)).isInstanceOf(BooleanDataType.class);
        Assertions.assertThat((Object)DataTypeResolver.fromObject((Object)4)).isInstanceOf(IntegerDataType.class);
        Assertions.assertThat((Object)DataTypeResolver.fromObject((Object)Float.valueOf(23.2f))).isInstanceOf(FloatDataType.class);
        Assertions.assertThat((Object)DataTypeResolver.fromObject(Arrays.asList("1", "2", "3"))).isInstanceOf(ListDataType.class);
        Assertions.assertThat((Object)DataTypeResolver.fromObject((Object)new byte[0])).isInstanceOf(ObjectDataType.class);
        Assertions.assertThat((Object)DataTypeResolver.fromObject((Object)((Object)Champions.BETIS))).isInstanceOf(EnumDataType.class);
        Assertions.assertThat((Object)DataTypeResolver.fromType((String)"String", (ClassLoader)cl)).isInstanceOf(StringDataType.class);
        Assertions.assertThat((Object)DataTypeResolver.fromType((String)"Boolean", (ClassLoader)cl)).isInstanceOf(BooleanDataType.class);
        Assertions.assertThat((Object)DataTypeResolver.fromType((String)"Integer", (ClassLoader)cl)).isInstanceOf(IntegerDataType.class);
        Assertions.assertThat((Object)DataTypeResolver.fromType((String)"Float", (ClassLoader)cl)).isInstanceOf(FloatDataType.class);
        Assertions.assertThat((Object)DataTypeResolver.fromType((String)"java.util.List", (ClassLoader)cl)).isInstanceOf(ListDataType.class);
        Assertions.assertThat((Object)DataTypeResolver.fromType((String)"Object", (ClassLoader)cl)).isInstanceOf(ObjectDataType.class);
    }

    private static enum Champions {
        BETIS,
        DEPORTIVO,
        REAL_SOCIEDAD,
        VALENCIA;

    }
}

