/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl.humantask;

import java.time.Duration;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.process.instance.impl.humantask.DeadlineHelper;
import org.jbpm.process.instance.impl.humantask.DeadlineInfo;
import org.jbpm.process.instance.impl.humantask.Reassignment;
import org.jbpm.process.instance.impl.humantask.ScheduleInfo;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.ExpirationTime;

public class DeadlineHelperTest {
    @Test
    public void testRepetition() {
        Collection deadlines = DeadlineHelper.parseDeadlines((Object)"[subject:5secs|body:NotCompleted repeated notification every 5secs]@[R/PT5S]");
        Assertions.assertThat((Collection)deadlines).hasSize(1);
        DeadlineInfo deadlineInfo = (DeadlineInfo)deadlines.iterator().next();
        Assertions.assertThat((Map)((Map)deadlineInfo.getNotification())).containsEntry((Object)"subject", (Object)"5secs");
        Assertions.assertThat((Map)((Map)deadlineInfo.getNotification())).containsEntry((Object)"body", (Object)"NotCompleted repeated notification every 5secs");
        Collection scheduling = deadlineInfo.getScheduleInfo();
        Assertions.assertThat((Collection)scheduling).hasSize(1);
        ScheduleInfo scheduleInfo = (ScheduleInfo)scheduling.iterator().next();
        Assertions.assertThat((Duration)scheduleInfo.getDuration()).isEqualTo((Object)Duration.ofSeconds(5L));
        Assertions.assertThat((int)scheduleInfo.getNumRepetitions()).isEqualTo(-1);
        Assertions.assertThat((ZonedDateTime)scheduleInfo.getEndDate()).isNull();
        Assertions.assertThat((ZonedDateTime)scheduleInfo.getStartDate()).isNull();
        ExpirationTime time = DeadlineHelper.getExpirationTime((ScheduleInfo)scheduleInfo);
        Assertions.assertThat((Long)time.repeatInterval()).isEqualTo(5000L);
        Assertions.assertThat((Integer)time.repeatLimit()).isEqualTo(-1);
        Assertions.assertThat((boolean)ZonedDateTime.now().plus(Duration.ofSeconds(5L)).isAfter(time.get())).isTrue();
    }

    @Test
    public void testRepetitionWithEndDate() {
        ZonedDateTime future = ZonedDateTime.now().plus(Duration.ofMinutes(2L)).plus(Duration.ofSeconds(2L));
        Collection deadlines = DeadlineHelper.parseDeadlines((Object)("[subject:5secs]@[R/PT5S/" + future.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "]"));
        Assertions.assertThat((Collection)deadlines).hasSize(1);
        DeadlineInfo deadlineInfo = (DeadlineInfo)deadlines.iterator().next();
        Assertions.assertThat((Map)((Map)deadlineInfo.getNotification())).containsEntry((Object)"subject", (Object)"5secs");
        Collection scheduling = deadlineInfo.getScheduleInfo();
        Assertions.assertThat((Collection)scheduling).hasSize(1);
        ScheduleInfo scheduleInfo = (ScheduleInfo)scheduling.iterator().next();
        Assertions.assertThat((Duration)scheduleInfo.getDuration()).isEqualTo((Object)Duration.ofSeconds(5L));
        Assertions.assertThat((int)scheduleInfo.getNumRepetitions()).isEqualTo(-1);
        this.assertEqualsDate(future, scheduleInfo.getEndDate());
        Assertions.assertThat((ZonedDateTime)scheduleInfo.getStartDate()).isNull();
        ExpirationTime time = DeadlineHelper.getExpirationTime((ScheduleInfo)scheduleInfo);
        Assertions.assertThat((Long)time.repeatInterval()).isEqualTo(5000L);
        Assertions.assertThat((Integer)time.repeatLimit()).isEqualTo(24);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)ZonedDateTime.now().plus(Duration.ofSeconds(5L)).isAfter(time.get())).as("Date is " + time.get(), new Object[0])).isTrue();
    }

    @Test
    public void testRepetitionWithEndDateCornerCase() {
        ZonedDateTime future = ZonedDateTime.now().plus(Duration.ofSeconds(5L));
        Collection deadlines = DeadlineHelper.parseDeadlines((Object)("[subject:5secs]@[R/PT5S/" + future.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "]"));
        Assertions.assertThat((Collection)deadlines).hasSize(1);
        DeadlineInfo deadlineInfo = (DeadlineInfo)deadlines.iterator().next();
        Assertions.assertThat((Map)((Map)deadlineInfo.getNotification())).containsEntry((Object)"subject", (Object)"5secs");
        Collection scheduling = deadlineInfo.getScheduleInfo();
        Assertions.assertThat((Collection)scheduling).hasSize(1);
        ScheduleInfo scheduleInfo = (ScheduleInfo)scheduling.iterator().next();
        Assertions.assertThat((Duration)scheduleInfo.getDuration()).isEqualTo((Object)Duration.ofSeconds(5L));
        Assertions.assertThat((int)scheduleInfo.getNumRepetitions()).isEqualTo(-1);
        this.assertEqualsDate(future, scheduleInfo.getEndDate());
        Assertions.assertThat((ZonedDateTime)scheduleInfo.getStartDate()).isNull();
        ExpirationTime time = DeadlineHelper.getExpirationTime((ScheduleInfo)scheduleInfo);
        Assertions.assertThat((Long)time.repeatInterval()).isNull();
        Assertions.assertThat((Integer)time.repeatLimit()).isZero();
        Assertions.assertThat((boolean)ZonedDateTime.now().plus(Duration.ofSeconds(5L)).isAfter(time.get())).isTrue();
    }

    @Test
    public void testRepetitionWithEndDateAndLimit() {
        Collection deadlines = DeadlineHelper.parseDeadlines((Object)"[subject:5secs]@[R2/PT5S/2021-03-18T18:55:01+01:00]");
        Assertions.assertThat((Collection)deadlines).hasSize(1);
        DeadlineInfo deadlineInfo = (DeadlineInfo)deadlines.iterator().next();
        Assertions.assertThat((Map)((Map)deadlineInfo.getNotification())).containsEntry((Object)"subject", (Object)"5secs");
        Collection scheduling = deadlineInfo.getScheduleInfo();
        Assertions.assertThat((Collection)scheduling).hasSize(1);
        ScheduleInfo scheduleInfo = (ScheduleInfo)scheduling.iterator().next();
        Assertions.assertThat((Duration)scheduleInfo.getDuration()).isEqualTo((Object)Duration.ofSeconds(5L));
        Assertions.assertThat((int)scheduleInfo.getNumRepetitions()).isEqualTo(2);
        Assertions.assertThat((ZonedDateTime)scheduleInfo.getEndDate()).isEqualTo((Object)ZonedDateTime.parse("2021-03-18T18:55:01+01:00"));
        Assertions.assertThat((ZonedDateTime)scheduleInfo.getStartDate()).isNull();
        ExpirationTime time = DeadlineHelper.getExpirationTime((ScheduleInfo)scheduleInfo);
        Assertions.assertThat((Long)time.repeatInterval()).isEqualTo(5000L);
        Assertions.assertThat((Integer)time.repeatLimit()).isEqualTo(2);
        this.assertEqualsDate(ZonedDateTime.parse("2021-03-18T18:54:51+01:00"), time.get());
    }

    @Test
    public void testRepetitionStartEndDate() {
        Collection deadlines = DeadlineHelper.parseDeadlines((Object)"[subject:5secs]@[R1/2021-03-18T18:55:01+01:00/2021-03-18T18:55:06+01:00]");
        Assertions.assertThat((Collection)deadlines).hasSize(1);
        DeadlineInfo deadlineInfo = (DeadlineInfo)deadlines.iterator().next();
        Assertions.assertThat((Map)((Map)deadlineInfo.getNotification())).containsEntry((Object)"subject", (Object)"5secs");
        Collection scheduling = deadlineInfo.getScheduleInfo();
        Assertions.assertThat((Collection)scheduling).hasSize(1);
        ScheduleInfo scheduleInfo = (ScheduleInfo)scheduling.iterator().next();
        Assertions.assertThat((int)scheduleInfo.getNumRepetitions()).isEqualTo(1);
        Assertions.assertThat((ZonedDateTime)scheduleInfo.getStartDate()).isEqualTo((Object)ZonedDateTime.parse("2021-03-18T18:55:01+01:00"));
        Assertions.assertThat((ZonedDateTime)scheduleInfo.getEndDate()).isEqualTo((Object)ZonedDateTime.parse("2021-03-18T18:55:06+01:00"));
        Assertions.assertThat((Duration)scheduleInfo.getDuration()).isNull();
        ExpirationTime time = DeadlineHelper.getExpirationTime((ScheduleInfo)scheduleInfo);
        Assertions.assertThat((Long)time.repeatInterval()).isEqualTo(5000L);
        Assertions.assertThat((Integer)time.repeatLimit()).isEqualTo(1);
        this.assertEqualsDate(ZonedDateTime.parse("2021-03-18T18:55:01+01:00"), time.get());
    }

    @Test
    public void testRepetitionWithStartDate() {
        Collection deadlines = DeadlineHelper.parseDeadlines((Object)"[subject:5secs]@[R26/2021-03-18T18:55:01+01:00/PT2M]");
        Assertions.assertThat((Collection)deadlines).hasSize(1);
        DeadlineInfo deadlineInfo = (DeadlineInfo)deadlines.iterator().next();
        Assertions.assertThat((Map)((Map)deadlineInfo.getNotification())).containsEntry((Object)"subject", (Object)"5secs");
        Collection scheduling = deadlineInfo.getScheduleInfo();
        Assertions.assertThat((Collection)scheduling).hasSize(1);
        ScheduleInfo scheduleInfo = (ScheduleInfo)scheduling.iterator().next();
        Assertions.assertThat((Duration)scheduleInfo.getDuration()).isEqualTo((Object)Duration.ofMinutes(2L));
        Assertions.assertThat((int)scheduleInfo.getNumRepetitions()).isEqualTo(26);
        Assertions.assertThat((ZonedDateTime)scheduleInfo.getStartDate()).isEqualTo((Object)ZonedDateTime.parse("2021-03-18T18:55:01+01:00"));
        Assertions.assertThat((ZonedDateTime)scheduleInfo.getEndDate()).isNull();
        ExpirationTime time = DeadlineHelper.getExpirationTime((ScheduleInfo)scheduleInfo);
        Assertions.assertThat((Long)time.repeatInterval()).isEqualTo(Duration.ofMinutes(2L).toMillis());
        Assertions.assertThat((Integer)time.repeatLimit()).isEqualTo(26);
        this.assertEqualsDate(ZonedDateTime.parse("2021-03-18T18:55:01+01:00"), time.get());
    }

    @Test
    public void testExactDate() {
        Collection deadlines = DeadlineHelper.parseDeadlines((Object)"[subject:exact date]@[2021-03-18T18:55:01+01:00]");
        Assertions.assertThat((Collection)deadlines).hasSize(1);
        DeadlineInfo deadlineInfo = (DeadlineInfo)deadlines.iterator().next();
        Assertions.assertThat((Map)((Map)deadlineInfo.getNotification())).containsEntry((Object)"subject", (Object)"exact date");
        Collection scheduling = deadlineInfo.getScheduleInfo();
        Assertions.assertThat((Collection)scheduling).hasSize(1);
        ScheduleInfo scheduleInfo = (ScheduleInfo)scheduling.iterator().next();
        Assertions.assertThat((Duration)scheduleInfo.getDuration()).isNull();
        Assertions.assertThat((int)scheduleInfo.getNumRepetitions()).isZero();
        Assertions.assertThat((ZonedDateTime)scheduleInfo.getEndDate()).isEqualTo((Object)ZonedDateTime.parse("2021-03-18T18:55:01+01:00"));
        Assertions.assertThat((ZonedDateTime)scheduleInfo.getStartDate()).isNull();
        ExpirationTime time = DeadlineHelper.getExpirationTime((ScheduleInfo)scheduleInfo);
        Assertions.assertThat((Long)time.repeatInterval()).isNull();
        Assertions.assertThat((Integer)time.repeatLimit()).isZero();
        this.assertEqualsDate(ZonedDateTime.parse("2021-03-18T18:55:01+01:00"), time.get());
    }

    @Test
    public void testLargeRepetition() {
        Collection deadlines = DeadlineHelper.parseDeadlines((Object)"[subject:more than 1 year]@[R/P1Y3WT1H]");
        Assertions.assertThat((Collection)deadlines).hasSize(1);
        DeadlineInfo deadlineInfo = (DeadlineInfo)deadlines.iterator().next();
        Assertions.assertThat((Map)((Map)deadlineInfo.getNotification())).containsEntry((Object)"subject", (Object)"more than 1 year");
        Collection scheduling = deadlineInfo.getScheduleInfo();
        Assertions.assertThat((Collection)scheduling).hasSize(1);
        ScheduleInfo scheduleInfo = (ScheduleInfo)scheduling.iterator().next();
        Assertions.assertThat((Duration)scheduleInfo.getDuration()).isEqualTo((Object)DeadlineHelper.getDuration((Period)Period.ofYears(1).plus(Period.ofWeeks(3)), (Duration)Duration.ofHours(1L)));
        Assertions.assertThat((int)scheduleInfo.getNumRepetitions()).isEqualTo(-1);
        Assertions.assertThat((ZonedDateTime)scheduleInfo.getEndDate()).isNull();
        Assertions.assertThat((ZonedDateTime)scheduleInfo.getStartDate()).isNull();
        ExpirationTime time = DeadlineHelper.getExpirationTime((ScheduleInfo)scheduleInfo);
        Assertions.assertThat((Long)time.repeatInterval()).isEqualTo(DeadlineHelper.getDuration((Period)Period.ofYears(1).plus(Period.ofWeeks(3)), (Duration)Duration.ofHours(1L)).toMillis());
        Assertions.assertThat((Integer)time.repeatLimit()).isEqualTo(-1);
    }

    @Test
    public void testMultipleDuration() {
        Collection deadlines = DeadlineHelper.parseDeadlines((Object)"[subject:1 and 4 hour]@[PT1H,PT4H]");
        Assertions.assertThat((Collection)deadlines).hasSize(1);
        DeadlineInfo deadlineInfo = (DeadlineInfo)deadlines.iterator().next();
        Assertions.assertThat((Map)((Map)deadlineInfo.getNotification())).containsEntry((Object)"subject", (Object)"1 and 4 hour");
        Collection scheduling = deadlineInfo.getScheduleInfo();
        Assertions.assertThat((Collection)scheduling).hasSize(2);
        Assertions.assertThat((long)scheduling.stream().filter(s -> s.getDuration().equals(Duration.ofHours(1L)) || s.getDuration().equals(Duration.ofHours(4L))).count()).isEqualTo(2L);
    }

    @Test
    public void testMultipleNotification() {
        Collection deadlines = DeadlineHelper.parseDeadlines((Object)"[subject:1 hour]@[PT1H]^[subject:4 hour]@[PT4H]");
        Assertions.assertThat((Collection)deadlines).hasSize(2);
        for (DeadlineInfo deadline : deadlines) {
            if ("1 hour".equals(((Map)deadline.getNotification()).get("subject"))) {
                Assertions.assertThat((Duration)((ScheduleInfo)deadline.getScheduleInfo().iterator().next()).getDuration()).isEqualTo((Object)Duration.ofHours(1L));
                continue;
            }
            if ("4 hour".equals(((Map)deadline.getNotification()).get("subject"))) {
                Assertions.assertThat((Duration)((ScheduleInfo)deadline.getScheduleInfo().iterator().next()).getDuration()).isEqualTo((Object)Duration.ofHours(4L));
                continue;
            }
            Assertions.fail((String)"Unexpected subject value");
        }
    }

    @Test
    public void testReassignment() {
        Collection reassigments = DeadlineHelper.parseReassignments((Object)"[users:Pepe,Pepa|groups:Admin,Managers]@[1m]");
        Assertions.assertThat((Collection)reassigments).hasSize(1);
        DeadlineInfo reassignment = (DeadlineInfo)reassigments.iterator().next();
        Assertions.assertThat((Collection)((Reassignment)reassignment.getNotification()).getPotentialUsers()).containsExactlyInAnyOrder((Object[])new String[]{"Pepe", "Pepa"});
        Assertions.assertThat((Collection)((Reassignment)reassignment.getNotification()).getPotentialGroups()).containsExactlyInAnyOrder((Object[])new String[]{"Admin", "Managers"});
        Assertions.assertThat((Duration)((ScheduleInfo)reassignment.getScheduleInfo().iterator().next()).getDuration()).isEqualTo((Object)Duration.ofMinutes(1L));
    }

    private void assertEqualsDate(ZonedDateTime expectedDate, ZonedDateTime calculatedDate) {
        Assertions.assertThat((long)calculatedDate.toInstant().getEpochSecond()).isEqualTo(expectedDate.toInstant().getEpochSecond());
    }
}

