/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.instance;

import org.assertj.core.api.Assertions;
import org.drools.core.runtime.process.ProcessRuntimeFactoryService;
import org.drools.kiesession.session.ProcessRuntimeFactory;
import org.jbpm.process.instance.ProcessRuntimeFactoryServiceImpl;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Process;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.slf4j.LoggerFactory;

public class RuleFlowProcessInstanceTest
extends AbstractBaseTest {
    private static String PROCESS_ID = "process.test";

    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testStartProcessThrowException() throws Exception {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId(PROCESS_ID);
        process.setName("test");
        process.setPackageName("org.mycomp.myprocess");
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime(new Process[]{process});
        Assertions.assertThatThrownBy(() -> kruntime.startProcess(PROCESS_ID)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testStartProcessDynamic() throws Exception {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId(PROCESS_ID);
        process.setName("test");
        process.setPackageName("org.mycomp.myprocess");
        process.setDynamic(true);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime(new Process[]{process});
        KogitoProcessInstance instance = kruntime.startProcess(PROCESS_ID);
        Assertions.assertThat((Object)instance).isNotNull();
    }

    static {
        ProcessRuntimeFactory.setProcessRuntimeFactoryService((ProcessRuntimeFactoryService)new ProcessRuntimeFactoryServiceImpl());
    }
}

