/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.process.WorkItemHandlerConfig;
import org.kie.kogito.process.impl.AbstractProcessConfig;
import org.kie.kogito.process.impl.CachedWorkItemHandlerConfig;
import org.mockito.Mockito;

public class AbstractProcessConfigTest {
    @Test
    void testOneWorkItemHandlerConfig() {
        CachedWorkItemHandlerConfig workItemConfig = new CachedWorkItemHandlerConfig();
        MockProcessConfig config = new MockProcessConfig(List.of(workItemConfig));
        Assertions.assertThat((Object)config.workItemHandlers()).isSameAs((Object)workItemConfig);
    }

    @Test
    void testMultipleWorkItemHandlerConfig() {
        CachedWorkItemHandlerConfig workItemConfig1 = new CachedWorkItemHandlerConfig();
        CachedWorkItemHandlerConfig workItemConfig2 = new CachedWorkItemHandlerConfig();
        String name1 = "Javierito1";
        String name2 = "Javierito2";
        KogitoWorkItemHandler workItem1 = (KogitoWorkItemHandler)Mockito.mock(KogitoWorkItemHandler.class);
        KogitoWorkItemHandler workItem2 = (KogitoWorkItemHandler)Mockito.mock(KogitoWorkItemHandler.class);
        workItemConfig1.register("Javierito1", workItem1);
        workItemConfig2.register("Javierito2", workItem2);
        MockProcessConfig config = new MockProcessConfig(List.of(workItemConfig1, workItemConfig2));
        Assertions.assertThat((Collection)config.workItemHandlers().names()).containsExactlyInAnyOrder((Object[])new String[]{"Javierito1", "Javierito2"});
        Assertions.assertThat((Object)config.workItemHandlers().forName("Javierito1")).isSameAs((Object)workItem1);
        Assertions.assertThat((Object)config.workItemHandlers().forName("Javierito2")).isSameAs((Object)workItem2);
        String name3 = "Javierito3";
        KogitoWorkItemHandler workItem3 = (KogitoWorkItemHandler)Mockito.mock(KogitoWorkItemHandler.class);
        workItemConfig2.register("Javierito3", workItem3);
        Assertions.assertThat((Collection)config.workItemHandlers().names()).containsExactlyInAnyOrder((Object[])new String[]{"Javierito1", "Javierito2", "Javierito3"});
        Assertions.assertThat((Object)config.workItemHandlers().forName("Javierito3")).isSameAs((Object)workItem3);
    }

    private static class MockProcessConfig
    extends AbstractProcessConfig {
        protected MockProcessConfig(Iterable<WorkItemHandlerConfig> workItemHandlerConfig) {
            super(workItemHandlerConfig, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, Collections.emptyList(), Collections.emptyList());
        }
    }
}

