/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.validation;

import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.process.validation.ValidationContext;
import org.kie.kogito.process.validation.ValidationError;

class ValidationContextTest {
    public static final String RESOURCE_ID = UUID.randomUUID().toString();
    private ValidationContext tested;
    private ValidationError error;
    private ValidationError error2;
    private RuntimeException exception;

    ValidationContextTest() {
    }

    @BeforeEach
    void init() {
        this.tested = ValidationContext.get();
        this.error = this.createError();
        this.error2 = this.createError();
        this.exception = new RuntimeException("Exception");
    }

    @Test
    void testValidationContext() {
        this.tested.add(RESOURCE_ID, this.error);
        this.tested.add(RESOURCE_ID, this.error2);
        this.tested.putException((Exception)this.exception);
        Assertions.assertThat((boolean)this.tested.hasErrors(RESOURCE_ID)).isTrue();
        Assertions.assertThat((Collection)this.tested.errors(RESOURCE_ID)).contains((Object[])new ValidationError[]{this.error, this.error2});
        Assertions.assertThat((Collection)this.tested.resourcesWithError()).containsOnly((Object[])new String[]{RESOURCE_ID});
        Assertions.assertThat((Collection)this.tested.resourcesWithError()).containsOnly((Object[])new String[]{RESOURCE_ID});
        Assertions.assertThat((Optional)this.tested.exception()).isPresent();
        Assertions.assertThat((Optional)this.tested.exception()).contains((Object)this.exception);
        this.tested.clear();
        Assertions.assertThat((boolean)this.tested.hasErrors(RESOURCE_ID)).isFalse();
        Assertions.assertThat((Collection)this.tested.resourcesWithError()).isEmpty();
        Assertions.assertThat((Optional)this.tested.exception()).isNotPresent();
    }

    @Test
    void testValidationContextConcurrency() throws ExecutionException, InterruptedException {
        CompletableFuture.allOf(this.testAddErrorAsync(UUID.randomUUID().toString()), this.testAddErrorAsync(UUID.randomUUID().toString()), this.testAddErrorAsync(UUID.randomUUID().toString())).get();
    }

    private ValidationError createError() {
        return new ValidationError(){
            private String message = UUID.randomUUID().toString();

            public String getMessage() {
                return this.message;
            }

            public int hashCode() {
                return this.getMessage().hashCode();
            }

            public boolean equals(Object obj) {
                return this.getMessage().equals(((ValidationError)obj).getMessage());
            }
        };
    }

    private CompletableFuture<Void> testAddErrorAsync(String id) {
        return CompletableFuture.runAsync(() -> {
            ValidationError localError = this.createError();
            this.tested.add(id, localError);
            IllegalStateException localException = new IllegalStateException("Local Exception");
            this.tested.putException((Exception)localException);
            Assertions.assertThat((boolean)this.tested.hasErrors()).isTrue();
            Assertions.assertThat((boolean)this.tested.hasErrors(id)).isTrue();
            Assertions.assertThat((boolean)this.tested.hasErrors(RESOURCE_ID)).isFalse();
            Assertions.assertThat((Collection)this.tested.errors(id)).containsOnly((Object[])new ValidationError[]{localError});
            Assertions.assertThat((Collection)this.tested.errors(id)).doesNotContain((Object[])new ValidationError[]{this.error});
            Assertions.assertThat((Optional)this.tested.exception()).isPresent();
            Assertions.assertThat((Optional)this.tested.exception()).contains((Object)localException);
            this.tested.clear();
            Assertions.assertThat((boolean)this.tested.hasErrors()).isFalse();
            Assertions.assertThat((Optional)this.tested.exception()).isNotPresent();
        });
    }
}

