/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.util;

import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.jbpm.process.instance.impl.util.LoggingPrintStream;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.slf4j.Logger;

public abstract class AbstractBaseTest {
    protected Logger logger;

    @BeforeEach
    public void before(TestInfo testInfo) {
        this.addLogger();
        this.logger.debug("> " + testInfo.getDisplayName());
    }

    public abstract void addLogger();

    public KogitoProcessRuntime createKogitoProcessRuntime(Process ... process) {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        for (Process processToAdd : process) {
            ((KnowledgeBaseImpl)kbase).addProcess(processToAdd);
        }
        return KogitoProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)kbase.newKieSession());
    }

    @BeforeAll
    public static void configure() {
        LoggingPrintStream.interceptSysOutSysErr();
    }

    @AfterAll
    public static void reset() {
        LoggingPrintStream.resetInterceptSysOutSysErr();
    }
}

