/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.jbpm.process.core.Work;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.IntegerDataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.process.core.datatype.impl.type.StringDataType;
import org.jbpm.process.core.impl.ParameterDefinitionImpl;
import org.jbpm.process.core.impl.WorkImpl;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.process.instance.impl.demo.MockDataWorkItemHandler;
import org.jbpm.process.test.Person;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Process;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.process.workitems.KogitoWorkItemHandlerNotFoundException;
import org.slf4j.LoggerFactory;

public class WorkItemTest
extends AbstractBaseTest {
    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testReachNonRegisteredWorkItemHandler() {
        String processId = "org.drools.actions";
        String workName = "Unnexistent Task";
        RuleFlowProcess process = this.getWorkItemProcess(processId, workName);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime(new Process[]{process});
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("UserName", "John Doe");
        parameters.put("Person", new Person("John Doe"));
        KogitoProcessInstance processInstance = null;
        try {
            processInstance = kruntime.startProcess("org.drools.actions", parameters);
            Assertions.fail((String)("should fail if WorkItemHandler for" + workName + "is not registered"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assertions.assertEquals((int)5, (int)processInstance.getState());
    }

    @Test
    public void testCancelNonRegisteredWorkItemHandler() {
        String processId = "org.drools.actions";
        String workName = "Unnexistent Task";
        RuleFlowProcess process = this.getWorkItemProcess(processId, workName);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime(new Process[]{process});
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler(workName, (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("UserName", "John Doe");
        parameters.put("Person", new Person("John Doe"));
        KogitoProcessInstance processInstance = kruntime.startProcess("org.drools.actions", parameters);
        String processInstanceId = processInstance.getStringId();
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler(workName, null);
        try {
            kruntime.abortProcessInstance(processInstanceId);
            Assertions.fail((String)("should fail if WorkItemHandler for" + workName + "is not registered"));
        }
        catch (KogitoWorkItemHandlerNotFoundException kogitoWorkItemHandlerNotFoundException) {
            // empty catch block
        }
        Assertions.assertEquals((int)3, (int)processInstance.getState());
    }

    @Test
    public void testMockDataWorkItemHandler() {
        String processId = "org.drools.actions";
        String workName = "Unnexistent Task";
        RuleFlowProcess process = this.getWorkItemProcess(processId, workName);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime(new Process[]{process});
        HashMap<String, String> output = new HashMap<String, String>();
        output.put("Result", "test");
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler(workName, (KogitoWorkItemHandler)new MockDataWorkItemHandler(output));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("UserName", "John Doe");
        parameters.put("Person", new Person("John Doe"));
        KogitoProcessInstance processInstance = kruntime.startProcess("org.drools.actions", parameters);
        Object numberVariable = ((WorkflowProcessInstance)processInstance).getVariable("MyObject");
        Assertions.assertNotNull((Object)numberVariable);
        Assertions.assertEquals((Object)"test", (Object)numberVariable);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
    }

    @Test
    public void testMockDataWorkItemHandlerCustomFunction() {
        String processId = "org.drools.actions";
        String workName = "Unnexistent Task";
        RuleFlowProcess process = this.getWorkItemProcess(processId, workName);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime(new Process[]{process});
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler(workName, (KogitoWorkItemHandler)new MockDataWorkItemHandler(input -> {
            HashMap<String, String> output = new HashMap<String, String>();
            if ("John Doe".equals(input.get("Comment"))) {
                output.put("Result", "one");
            } else {
                output.put("Result", "two");
            }
            return output;
        }));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("UserName", "John Doe");
        parameters.put("Person", new Person("John Doe"));
        KogitoProcessInstance processInstance = kruntime.startProcess("org.drools.actions", parameters);
        Object numberVariable = ((WorkflowProcessInstance)processInstance).getVariable("MyObject");
        Assertions.assertNotNull((Object)numberVariable);
        Assertions.assertEquals((Object)"one", (Object)numberVariable);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        parameters = new HashMap();
        parameters.put("UserName", "John Doe");
        parameters.put("Person", new Person("John Deen"));
        processInstance = kruntime.startProcess("org.drools.actions", parameters);
        numberVariable = ((WorkflowProcessInstance)processInstance).getVariable("MyObject");
        Assertions.assertNotNull((Object)numberVariable);
        Assertions.assertEquals((Object)"two", (Object)numberVariable);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
    }

    private RuleFlowProcess getWorkItemProcess(String processId, String workName) {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId(processId);
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable variable = new Variable();
        variable.setName("UserName");
        variable.setType((DataType)new StringDataType());
        variables.add(variable);
        variable = new Variable();
        variable.setName("Person");
        variable.setType((DataType)new ObjectDataType(Person.class.getName()));
        variables.add(variable);
        variable = new Variable();
        variable.setName("MyObject");
        variable.setType((DataType)new ObjectDataType());
        variables.add(variable);
        variable = new Variable();
        variable.setName("Number");
        variable.setType((DataType)new IntegerDataType());
        variables.add(variable);
        process.getVariableScope().setVariables(variables);
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setName("workItemNode");
        workItemNode.setId(2L);
        workItemNode.addInMapping("Comment", "Person.name");
        workItemNode.addInMapping("Attachment", "MyObject");
        workItemNode.addOutMapping("Result", "MyObject");
        workItemNode.addOutMapping("Result.length()", "Number");
        WorkImpl work = new WorkImpl();
        work.setName(workName);
        HashSet<ParameterDefinitionImpl> parameterDefinitions = new HashSet<ParameterDefinitionImpl>();
        ParameterDefinitionImpl parameterDefinition = new ParameterDefinitionImpl("ActorId", (DataType)new StringDataType());
        parameterDefinitions.add(parameterDefinition);
        parameterDefinition = new ParameterDefinitionImpl("Content", (DataType)new StringDataType());
        parameterDefinitions.add(parameterDefinition);
        parameterDefinition = new ParameterDefinitionImpl("Comment", (DataType)new StringDataType());
        parameterDefinitions.add(parameterDefinition);
        work.setParameterDefinitions(parameterDefinitions);
        work.setParameter("ActorId", (Object)"#{UserName}");
        work.setParameter("Content", (Object)"#{Person.name}");
        workItemNode.setWork((Work)work);
        EndNode endNode = new EndNode();
        endNode.setName("End");
        endNode.setId(3L);
        this.connect((Node)startNode, (Node)workItemNode);
        this.connect((Node)workItemNode, (Node)endNode);
        process.addNode((org.kie.api.definition.process.Node)startNode);
        process.addNode((org.kie.api.definition.process.Node)workItemNode);
        process.addNode((org.kie.api.definition.process.Node)endNode);
        return process;
    }

    private void connect(Node sourceNode, Node targetNode) {
        new ConnectionImpl((org.kie.api.definition.process.Node)sourceNode, "DROOLS_DEFAULT", (org.kie.api.definition.process.Node)targetNode, "DROOLS_DEFAULT");
    }
}

