/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl.humantask;

import java.time.Duration;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jbpm.process.instance.impl.humantask.DeadlineHelper;
import org.jbpm.process.instance.impl.humantask.DeadlineInfo;
import org.jbpm.process.instance.impl.humantask.Reassignment;
import org.jbpm.process.instance.impl.humantask.ScheduleInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.ExpirationTime;

public class DeadlineHelperTest {
    @Test
    public void testRepetition() {
        Collection deadlines = DeadlineHelper.parseDeadlines((Object)"[subject:5secs|body:NotCompleted repeated notification every 5secs]@[R/PT5S]");
        Assertions.assertEquals((int)1, (int)deadlines.size());
        DeadlineInfo deadlineInfo = (DeadlineInfo)deadlines.iterator().next();
        Assertions.assertEquals((Object)"5secs", ((Map)deadlineInfo.getNotification()).get("subject"));
        Assertions.assertEquals((Object)"NotCompleted repeated notification every 5secs", ((Map)deadlineInfo.getNotification()).get("body"));
        Collection scheduling = deadlineInfo.getScheduleInfo();
        Assertions.assertEquals((int)1, (int)scheduling.size());
        ScheduleInfo scheduleInfo = (ScheduleInfo)scheduling.iterator().next();
        Assertions.assertEquals((Object)Duration.ofSeconds(5L), (Object)scheduleInfo.getDuration());
        Assertions.assertEquals((int)-1, (int)scheduleInfo.getNumRepetitions());
        Assertions.assertNull((Object)scheduleInfo.getEndDate());
        Assertions.assertNull((Object)scheduleInfo.getStartDate());
        ExpirationTime time = DeadlineHelper.getExpirationTime((ScheduleInfo)scheduleInfo);
        Assertions.assertEquals((long)5000L, (Long)time.repeatInterval());
        Assertions.assertEquals((int)-1, (Integer)time.repeatLimit());
        Assertions.assertTrue((boolean)ZonedDateTime.now().plus(Duration.ofSeconds(5L)).isAfter(time.get()));
    }

    @Test
    public void testRepetitionWithEndDate() {
        ZonedDateTime future = ZonedDateTime.now().plus(Duration.ofMinutes(2L)).plus(Duration.ofSeconds(2L));
        Collection deadlines = DeadlineHelper.parseDeadlines((Object)("[subject:5secs]@[R/PT5S/" + future.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "]"));
        Assertions.assertEquals((int)1, (int)deadlines.size());
        DeadlineInfo deadlineInfo = (DeadlineInfo)deadlines.iterator().next();
        Assertions.assertEquals((Object)"5secs", ((Map)deadlineInfo.getNotification()).get("subject"));
        Collection scheduling = deadlineInfo.getScheduleInfo();
        Assertions.assertEquals((int)1, (int)scheduling.size());
        ScheduleInfo scheduleInfo = (ScheduleInfo)scheduling.iterator().next();
        Assertions.assertEquals((Object)Duration.ofSeconds(5L), (Object)scheduleInfo.getDuration());
        Assertions.assertEquals((int)-1, (int)scheduleInfo.getNumRepetitions());
        this.assertEqualsDate(future, scheduleInfo.getEndDate());
        Assertions.assertNull((Object)scheduleInfo.getStartDate());
        ExpirationTime time = DeadlineHelper.getExpirationTime((ScheduleInfo)scheduleInfo);
        Assertions.assertEquals((long)5000L, (Long)time.repeatInterval());
        Assertions.assertEquals((int)24, (Integer)time.repeatLimit());
        Assertions.assertTrue((boolean)ZonedDateTime.now().plus(Duration.ofSeconds(5L)).isAfter(time.get()), (String)("Date is " + time.get()));
    }

    @Test
    public void testRepetitionWithEndDateCornerCase() {
        ZonedDateTime future = ZonedDateTime.now().plus(Duration.ofSeconds(5L));
        Collection deadlines = DeadlineHelper.parseDeadlines((Object)("[subject:5secs]@[R/PT5S/" + future.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "]"));
        Assertions.assertEquals((int)1, (int)deadlines.size());
        DeadlineInfo deadlineInfo = (DeadlineInfo)deadlines.iterator().next();
        Assertions.assertEquals((Object)"5secs", ((Map)deadlineInfo.getNotification()).get("subject"));
        Collection scheduling = deadlineInfo.getScheduleInfo();
        Assertions.assertEquals((int)1, (int)scheduling.size());
        ScheduleInfo scheduleInfo = (ScheduleInfo)scheduling.iterator().next();
        Assertions.assertEquals((Object)Duration.ofSeconds(5L), (Object)scheduleInfo.getDuration());
        Assertions.assertEquals((int)-1, (int)scheduleInfo.getNumRepetitions());
        this.assertEqualsDate(future, scheduleInfo.getEndDate());
        Assertions.assertNull((Object)scheduleInfo.getStartDate());
        ExpirationTime time = DeadlineHelper.getExpirationTime((ScheduleInfo)scheduleInfo);
        Assertions.assertNull((Object)time.repeatInterval());
        Assertions.assertEquals((int)0, (Integer)time.repeatLimit());
        Assertions.assertTrue((boolean)ZonedDateTime.now().plus(Duration.ofSeconds(5L)).isAfter(time.get()));
    }

    @Test
    public void testRepetitionWithEndDateAndLimit() {
        Collection deadlines = DeadlineHelper.parseDeadlines((Object)"[subject:5secs]@[R2/PT5S/2021-03-18T18:55:01+01:00]");
        Assertions.assertEquals((int)1, (int)deadlines.size());
        DeadlineInfo deadlineInfo = (DeadlineInfo)deadlines.iterator().next();
        Assertions.assertEquals((Object)"5secs", ((Map)deadlineInfo.getNotification()).get("subject"));
        Collection scheduling = deadlineInfo.getScheduleInfo();
        Assertions.assertEquals((int)1, (int)scheduling.size());
        ScheduleInfo scheduleInfo = (ScheduleInfo)scheduling.iterator().next();
        Assertions.assertEquals((Object)Duration.ofSeconds(5L), (Object)scheduleInfo.getDuration());
        Assertions.assertEquals((int)2, (int)scheduleInfo.getNumRepetitions());
        Assertions.assertEquals((Object)ZonedDateTime.parse("2021-03-18T18:55:01+01:00"), (Object)scheduleInfo.getEndDate());
        Assertions.assertNull((Object)scheduleInfo.getStartDate());
        ExpirationTime time = DeadlineHelper.getExpirationTime((ScheduleInfo)scheduleInfo);
        Assertions.assertEquals((long)5000L, (Long)time.repeatInterval());
        Assertions.assertEquals((int)2, (Integer)time.repeatLimit());
        this.assertEqualsDate(ZonedDateTime.parse("2021-03-18T18:54:51+01:00"), time.get());
    }

    @Test
    public void testRepetitionStartEndDate() {
        Collection deadlines = DeadlineHelper.parseDeadlines((Object)"[subject:5secs]@[R1/2021-03-18T18:55:01+01:00/2021-03-18T18:55:06+01:00]");
        Assertions.assertEquals((int)1, (int)deadlines.size());
        DeadlineInfo deadlineInfo = (DeadlineInfo)deadlines.iterator().next();
        Assertions.assertEquals((Object)"5secs", ((Map)deadlineInfo.getNotification()).get("subject"));
        Collection scheduling = deadlineInfo.getScheduleInfo();
        Assertions.assertEquals((int)1, (int)scheduling.size());
        ScheduleInfo scheduleInfo = (ScheduleInfo)scheduling.iterator().next();
        Assertions.assertEquals((int)1, (int)scheduleInfo.getNumRepetitions());
        Assertions.assertEquals((Object)ZonedDateTime.parse("2021-03-18T18:55:01+01:00"), (Object)scheduleInfo.getStartDate());
        Assertions.assertEquals((Object)ZonedDateTime.parse("2021-03-18T18:55:06+01:00"), (Object)scheduleInfo.getEndDate());
        Assertions.assertNull((Object)scheduleInfo.getDuration());
        ExpirationTime time = DeadlineHelper.getExpirationTime((ScheduleInfo)scheduleInfo);
        Assertions.assertEquals((long)5000L, (Long)time.repeatInterval());
        Assertions.assertEquals((int)1, (Integer)time.repeatLimit());
        this.assertEqualsDate(ZonedDateTime.parse("2021-03-18T18:55:01+01:00"), time.get());
    }

    @Test
    public void testRepetitionWithStartDate() {
        Collection deadlines = DeadlineHelper.parseDeadlines((Object)"[subject:5secs]@[R26/2021-03-18T18:55:01+01:00/PT2M]");
        Assertions.assertEquals((int)1, (int)deadlines.size());
        DeadlineInfo deadlineInfo = (DeadlineInfo)deadlines.iterator().next();
        Assertions.assertEquals((Object)"5secs", ((Map)deadlineInfo.getNotification()).get("subject"));
        Collection scheduling = deadlineInfo.getScheduleInfo();
        Assertions.assertEquals((int)1, (int)scheduling.size());
        ScheduleInfo scheduleInfo = (ScheduleInfo)scheduling.iterator().next();
        Assertions.assertEquals((Object)Duration.ofMinutes(2L), (Object)scheduleInfo.getDuration());
        Assertions.assertEquals((int)26, (int)scheduleInfo.getNumRepetitions());
        Assertions.assertEquals((Object)ZonedDateTime.parse("2021-03-18T18:55:01+01:00"), (Object)scheduleInfo.getStartDate());
        Assertions.assertNull((Object)scheduleInfo.getEndDate());
        ExpirationTime time = DeadlineHelper.getExpirationTime((ScheduleInfo)scheduleInfo);
        Assertions.assertEquals((long)Duration.ofMinutes(2L).toMillis(), (Long)time.repeatInterval());
        Assertions.assertEquals((int)26, (Integer)time.repeatLimit());
        this.assertEqualsDate(ZonedDateTime.parse("2021-03-18T18:55:01+01:00"), time.get());
    }

    @Test
    public void testExactDate() {
        Collection deadlines = DeadlineHelper.parseDeadlines((Object)"[subject:exact date]@[2021-03-18T18:55:01+01:00]");
        Assertions.assertEquals((int)1, (int)deadlines.size());
        DeadlineInfo deadlineInfo = (DeadlineInfo)deadlines.iterator().next();
        Assertions.assertEquals((Object)"exact date", ((Map)deadlineInfo.getNotification()).get("subject"));
        Collection scheduling = deadlineInfo.getScheduleInfo();
        Assertions.assertEquals((int)1, (int)scheduling.size());
        ScheduleInfo scheduleInfo = (ScheduleInfo)scheduling.iterator().next();
        Assertions.assertNull((Object)scheduleInfo.getDuration());
        Assertions.assertEquals((int)0, (int)scheduleInfo.getNumRepetitions());
        Assertions.assertEquals((Object)ZonedDateTime.parse("2021-03-18T18:55:01+01:00"), (Object)scheduleInfo.getEndDate());
        Assertions.assertNull((Object)scheduleInfo.getStartDate());
        ExpirationTime time = DeadlineHelper.getExpirationTime((ScheduleInfo)scheduleInfo);
        Assertions.assertNull((Object)time.repeatInterval());
        Assertions.assertEquals((int)0, (Integer)time.repeatLimit());
        this.assertEqualsDate(ZonedDateTime.parse("2021-03-18T18:55:01+01:00"), time.get());
    }

    @Test
    public void testLargeRepetition() {
        Collection deadlines = DeadlineHelper.parseDeadlines((Object)"[subject:more than 1 year]@[R/P1Y3WT1H]");
        Assertions.assertEquals((int)1, (int)deadlines.size());
        DeadlineInfo deadlineInfo = (DeadlineInfo)deadlines.iterator().next();
        Assertions.assertEquals((Object)"more than 1 year", ((Map)deadlineInfo.getNotification()).get("subject"));
        Collection scheduling = deadlineInfo.getScheduleInfo();
        Assertions.assertEquals((int)1, (int)scheduling.size());
        ScheduleInfo scheduleInfo = (ScheduleInfo)scheduling.iterator().next();
        Assertions.assertEquals((Object)DeadlineHelper.getDuration((Period)Period.ofYears(1).plus(Period.ofWeeks(3)), (Duration)Duration.ofHours(1L)), (Object)scheduleInfo.getDuration());
        Assertions.assertEquals((int)-1, (int)scheduleInfo.getNumRepetitions());
        Assertions.assertNull((Object)scheduleInfo.getEndDate());
        Assertions.assertNull((Object)scheduleInfo.getStartDate());
        ExpirationTime time = DeadlineHelper.getExpirationTime((ScheduleInfo)scheduleInfo);
        Assertions.assertEquals((long)DeadlineHelper.getDuration((Period)Period.ofYears(1).plus(Period.ofWeeks(3)), (Duration)Duration.ofHours(1L)).toMillis(), (Long)time.repeatInterval());
        Assertions.assertEquals((int)-1, (Integer)time.repeatLimit());
    }

    @Test
    public void testMultipleDuration() {
        Collection deadlines = DeadlineHelper.parseDeadlines((Object)"[subject:1 and 4 hour]@[PT1H,PT4H]");
        Assertions.assertEquals((int)1, (int)deadlines.size());
        DeadlineInfo deadlineInfo = (DeadlineInfo)deadlines.iterator().next();
        Assertions.assertEquals((Object)"1 and 4 hour", ((Map)deadlineInfo.getNotification()).get("subject"));
        Collection scheduling = deadlineInfo.getScheduleInfo();
        Assertions.assertEquals((int)2, (int)scheduling.size());
        Assertions.assertEquals((long)2L, (long)scheduling.stream().filter(s -> s.getDuration().equals(Duration.ofHours(1L)) || s.getDuration().equals(Duration.ofHours(4L))).count());
    }

    @Test
    public void testMultipleNotification() {
        Collection deadlines = DeadlineHelper.parseDeadlines((Object)"[subject:1 hour]@[PT1H]^[subject:4 hour]@[PT4H]");
        Assertions.assertEquals((int)2, (int)deadlines.size());
        for (DeadlineInfo deadline : deadlines) {
            if ("1 hour".equals(((Map)deadline.getNotification()).get("subject"))) {
                Assertions.assertEquals((Object)Duration.ofHours(1L), (Object)((ScheduleInfo)deadline.getScheduleInfo().iterator().next()).getDuration());
                continue;
            }
            if ("4 hour".equals(((Map)deadline.getNotification()).get("subject"))) {
                Assertions.assertEquals((Object)Duration.ofHours(4L), (Object)((ScheduleInfo)deadline.getScheduleInfo().iterator().next()).getDuration());
                continue;
            }
            Assertions.fail((String)"Unexpected subject value");
        }
    }

    @Test
    public void testReassignment() {
        Collection reassigments = DeadlineHelper.parseReassignments((Object)"[users:Pepe,Pepa|groups:Admin,Managers]@[1m]");
        Assertions.assertEquals((int)1, (int)reassigments.size());
        DeadlineInfo reassignment = (DeadlineInfo)reassigments.iterator().next();
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("Pepe", "Pepa")), (Object)((Reassignment)reassignment.getNotification()).getPotentialUsers());
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("Admin", "Managers")), (Object)((Reassignment)reassignment.getNotification()).getPotentialGroups());
        Assertions.assertEquals((Object)Duration.ofMinutes(1L), (Object)((ScheduleInfo)reassignment.getScheduleInfo().iterator().next()).getDuration());
    }

    private void assertEqualsDate(ZonedDateTime expectedDate, ZonedDateTime calculatedDate) {
        Assertions.assertEquals((long)expectedDate.toInstant().getEpochSecond(), (long)calculatedDate.toInstant().getEpochSecond());
    }
}

