/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.event.EventMarshaller;
import org.kie.kogito.event.impl.DefaultEventConsumerFactory;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.Signal;
import org.kie.kogito.services.event.AbstractProcessDataEvent;
import org.kie.kogito.services.event.EventConsumer;
import org.kie.kogito.services.event.EventConsumerFactory;
import org.kie.kogito.services.event.impl.DefaultEventMarshaller;
import org.kie.kogito.services.uow.CollectingUnitOfWorkFactory;
import org.kie.kogito.services.uow.DefaultUnitOfWorkManager;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class EventImplTest {
    private static EventConsumerFactory factory;
    private static EventMarshaller marshaller;
    private Process<DummyModel> process;
    private ProcessInstance<DummyModel> processInstance;
    private ProcessInstances<DummyModel> processInstances;
    private Application application;

    @BeforeAll
    static void init() {
        factory = new DefaultEventConsumerFactory();
        marshaller = new DefaultEventMarshaller();
    }

    @BeforeEach
    void setup() {
        this.application = (Application)Mockito.mock(Application.class);
        Mockito.when((Object)this.application.unitOfWorkManager()).thenReturn((Object)new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory()));
        this.process = (Process)Mockito.mock(Process.class);
        this.processInstances = (ProcessInstances)Mockito.mock(ProcessInstances.class);
        this.processInstance = (ProcessInstance)Mockito.mock(ProcessInstance.class);
        Mockito.when((Object)this.process.instances()).thenReturn(this.processInstances);
        Mockito.when((Object)this.processInstances.findById(ArgumentMatchers.anyString())).thenReturn(Optional.of(this.processInstance));
        Mockito.when((Object)this.process.createInstance((Object)((DummyModel)Mockito.any(DummyModel.class)))).thenReturn(this.processInstance);
    }

    @Test
    void testSigCloudEvent() {
        EventConsumer consumer = factory.get(DummyModel::new, true);
        String trigger = "dummyTopic";
        consumer.consume(this.application, this.process, (Object)new DummyCloudEvent(new DummyEvent("pepe"), "1"), "dummyTopic");
        ArgumentCaptor signal = ArgumentCaptor.forClass(Signal.class);
        ((ProcessInstance)Mockito.verify(this.processInstance, (VerificationMode)Mockito.times((int)1))).send((Signal)signal.capture());
        Assertions.assertEquals((Object)"1", (Object)((Signal)signal.getValue()).referenceId());
        Assertions.assertTrue((boolean)(((Signal)signal.getValue()).payload() instanceof DummyEvent));
        Assertions.assertEquals((Object)"pepe", (Object)((DummyEvent)((Signal)signal.getValue()).payload()).getDummyField());
    }

    @Test
    void testCloudEvent() {
        EventConsumer consumer = factory.get(DummyModel::new, true);
        String trigger = "dummyTopic";
        consumer.consume(this.application, this.process, (Object)new DummyCloudEvent(new DummyEvent("pepe")), "dummyTopic");
        ((ProcessInstance)Mockito.verify(this.processInstance, (VerificationMode)Mockito.times((int)1))).start("dummyTopic", "1");
    }

    @Test
    void testDataEvent() {
        EventConsumer consumer = factory.get(DummyModel::new, false);
        String trigger = "dummyTopic";
        consumer.consume(this.application, this.process, (Object)new DummyEvent("pepe"), "dummyTopic");
        ((ProcessInstance)Mockito.verify(this.processInstance, (VerificationMode)Mockito.times((int)1))).start("dummyTopic", null);
    }

    @Test
    void testDataMarshaller() {
        DummyEvent dataEvent = new DummyEvent("pepe");
        Assertions.assertEquals((Object)"{\"dummyField\":\"pepe\"}", (Object)marshaller.marshall((Object)dataEvent));
    }

    @Test
    void testEventMarshaller() {
        DummyEvent dataEvent = new DummyEvent("pepe");
        String jsonString = marshaller.marshall((Object)dataEvent);
        Assertions.assertTrue((boolean)jsonString.contains("\"dummyField\":\"pepe\""));
    }

    @Test
    void testEventPayloadException() {
        EventConsumer consumer = factory.get(DummyModel::new, true);
        String trigger = "dummyTopic";
        String payload = "{ a = b }";
        Assertions.assertThrows(ClassCastException.class, () -> consumer.consume(this.application, this.process, (Object)"{ a = b }", "dummyTopic"));
    }

    private static class DummyCloudEvent
    extends AbstractProcessDataEvent<DummyEvent> {
        public DummyCloudEvent() {
        }

        public DummyCloudEvent(DummyEvent dummyEvent) {
            this(dummyEvent, null);
        }

        public DummyCloudEvent(DummyEvent dummyEvent, String referenceId) {
            super("dummyTopic", (Object)dummyEvent, "1", "1", "1", "1", "1", "1", null);
            this.kogitoReferenceId = referenceId;
        }
    }

    private static class DummyModel
    implements Model {
        private DummyEvent dummyEvent;

        public DummyModel fromMap(Map<String, Object> params) {
            this.dummyEvent = (DummyEvent)params.get("dummyEvent");
            return this;
        }

        public Map<String, Object> toMap() {
            return Collections.singletonMap("dummyEvent", this.dummyEvent);
        }

        public DummyModel(DummyEvent dummyEvent) {
            this.dummyEvent = dummyEvent;
        }

        public void update(Map<String, Object> params) {
            this.fromMap(params);
        }
    }

    private static class DummyEvent {
        private String dummyField;

        public DummyEvent() {
        }

        public DummyEvent(String dummyField) {
            this.dummyField = dummyField;
        }

        public String getDummyField() {
            return this.dummyField;
        }
    }
}

