/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.DataTypeUtils;
import org.jbpm.process.core.datatype.impl.type.BooleanDataType;
import org.jbpm.process.core.datatype.impl.type.EnumDataType;
import org.jbpm.process.core.datatype.impl.type.FloatDataType;
import org.jbpm.process.core.datatype.impl.type.IntegerDataType;
import org.jbpm.process.core.datatype.impl.type.ListDataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.process.core.datatype.impl.type.StringDataType;

public class DataTypeResolver {
    public static final DataType defaultDataType = new ObjectDataType("java.lang.Object");
    private static final Map<Class<?>, DataType> dataTypes = new HashMap();
    private static final Map<String, Class<?>> string2Class = new HashMap();

    private DataTypeResolver() {
    }

    public static DataType fromType(String type, ClassLoader cl) {
        return type == null ? defaultDataType : DataTypeResolver.from(type, cl);
    }

    public static DataType fromClass(Class<?> clazz) {
        return DataTypeResolver.from(clazz).orElse(DataTypeResolver.newType(clazz));
    }

    private static DataType newType(Class<?> clazz) {
        return Enum.class.isAssignableFrom(clazz) ? new EnumDataType(clazz.asSubclass(Enum.class)) : new ObjectDataType(clazz);
    }

    public static DataType fromObject(Object value) {
        return DataTypeResolver.fromObject(value, false);
    }

    public static DataType fromObject(Object value, boolean isExpr) {
        return value == null || isExpr ? defaultDataType : DataTypeResolver.fromClass(value.getClass());
    }

    private static DataType from(String type, ClassLoader cl) {
        Class<?> clazz = string2Class.get(type = DataTypeUtils.ensureLangPrefix(type));
        if (clazz == null) {
            try {
                clazz = cl.loadClass(type);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazz != null ? DataTypeResolver.fromClass(clazz) : new ObjectDataType(type);
    }

    private static Optional<DataType> from(Class<?> type) {
        for (Map.Entry<Class<?>, DataType> entry : dataTypes.entrySet()) {
            if (!entry.getKey().isAssignableFrom(type)) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    static {
        dataTypes.put(Boolean.class, new BooleanDataType());
        dataTypes.put(String.class, new StringDataType());
        dataTypes.put(Integer.class, new IntegerDataType());
        dataTypes.put(Float.class, new FloatDataType());
        dataTypes.put(Collection.class, new ListDataType());
        string2Class.put("java.lang.String", String.class);
        string2Class.put("java.lang.Boolean", Boolean.class);
        string2Class.put("java.lang.Integer", Integer.class);
        string2Class.put("java.lang.Float", Float.class);
    }
}

