/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype.impl.coverter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.UnaryOperator;
import org.jbpm.process.core.datatype.impl.coverter.CloneHelperRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloneHelper {
    private static final Logger logger = LoggerFactory.getLogger(CloneHelper.class);
    private static final CloneHelper instance = new CloneHelper(CloneHelperRegister.get().getCloners());
    private Map<Class<?>, UnaryOperator<?>> cloners;
    private final Map<Class<?>, UnaryOperator<?>> registeredCloners;

    public static synchronized CloneHelper get() {
        return instance;
    }

    private CloneHelper(Map<Class<?>, UnaryOperator<?>> registeredCloners) {
        this.registeredCloners = registeredCloners;
        this.cloners = new ConcurrentHashMap(registeredCloners);
    }

    public <T> T clone(T value) {
        return (T)(value == null ? value : this.getCloner(value.getClass()).apply(value));
    }

    public <T> UnaryOperator<T> getCloner(Class<T> type) {
        return this.cloners.computeIfAbsent(type, this::searchCloner);
    }

    private UnaryOperator<?> searchCloner(Class<?> type) {
        return this.searchRegistered(type).or(() -> this.searchCopyConstructor(type)).or(() -> this.searchCloneable(type)).orElse(o -> o);
    }

    private Optional<UnaryOperator<?>> searchRegistered(Class<?> type) {
        return this.registeredCloners.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(type)).map(Map.Entry::getValue).findFirst();
    }

    private Optional<UnaryOperator<?>> searchCloneable(Class<?> type) {
        return this.findCloneMethod(type).map(m -> this.handleException(x$0 -> m.invoke(x$0, new Object[0]), type, "clone method"));
    }

    private Optional<UnaryOperator<?>> searchCopyConstructor(Class<?> type) {
        return this.findCopyConstructor(type).map(c -> this.handleException(xva$0 -> c.newInstance(xva$0), type, "copy constructor"));
    }

    private UnaryOperator<?> handleException(CloneOperation cloneOperation, Class<?> type, String message) {
        return o -> {
            try {
                return cloneOperation.apply(o);
            }
            catch (InvocationTargetException ex) {
                Throwable targetException = ex.getTargetException();
                if (targetException instanceof RuntimeException) {
                    throw (RuntimeException)targetException;
                }
                throw new IllegalStateException("Invocation to " + message + " failed for " + type, targetException);
            }
            catch (ReflectiveOperationException e) {
                logger.warn("Unexpected issue accessing existing {} for type {}, returning same instance. {}", new Object[]{message, type, e.getMessage()});
                return o;
            }
        };
    }

    private Optional<Method> findCloneMethod(Class<?> type) {
        if (Cloneable.class.isAssignableFrom(type)) {
            try {
                return Optional.of(type.getMethod("clone", new Class[0]));
            }
            catch (NoSuchMethodException ex) {
                logger.warn("{} implements cloneable but clone method cannot be found", type);
            }
        }
        return Optional.empty();
    }

    private Optional<Constructor<?>> findCopyConstructor(Class<?> type) {
        try {
            return Optional.of(type.getConstructor(type));
        }
        catch (ReflectiveOperationException ex) {
            for (Constructor<?> constructor : type.getConstructors()) {
                if (constructor.getParameterCount() != 1 || !constructor.getParameterTypes()[0].isAssignableFrom(type)) continue;
                return Optional.of(constructor);
            }
            logger.debug("Cannot find copy constructor for type {}", type);
            return Optional.empty();
        }
    }

    @FunctionalInterface
    private static interface CloneOperation {
        public Object apply(Object var1) throws ReflectiveOperationException;
    }
}

