/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.timer;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jbpm.process.core.timer.BusinessCalendarImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarBean {
    static final List<Integer> DEFAULT_WEEKEND_DAYS = Arrays.asList(7, 1);
    static final String DEFAULT_WEEKENDS = DEFAULT_WEEKEND_DAYS.stream().map(String::valueOf).collect(Collectors.joining(","));
    static final String DEFAULT_HOLIDAY_DATE_FORMAT = "yyyy-MM-dd";
    static final String DEFAULT_TIMEZONE = TimeZone.getDefault().getID();
    private static final Logger logger = LoggerFactory.getLogger(CalendarBean.class);
    private static final Collection<String> REQUIRED_PROPERTIES = Arrays.asList("business.start.hour", "business.end.hour");
    private static final Map<String, BiConsumer<StringBuilder, Properties>> FORMAT_VALIDATOR_MAP = new HashMap<String, BiConsumer<StringBuilder, Properties>>();
    private static final List<BiConsumer<StringBuilder, Properties>> BUSINESS_VALIDATOR_LIST;
    private static final int LOWER_HOUR_BOUND = 0;
    private static final int UPPER_HOUR_BOUND = 24;
    private static final String OUTSIDE_BOUNDARY_ERROR_MESSAGE = "%s %s outside expected boundaries %s";
    private static final String INVALID_FORMAT_ERROR_MESSAGE = "%s is not valid: %s";
    private static final String REPEATED_VALUES_ERROR_MESSAGE = "There are repeated values in the given %s %s";
    private static final String OTHER_VALUES_ERR_MSG = "%s and other values provided in the given %s %s";
    private static final String VALUES_SAME_ERR_MSG = "%s %s and %s %s must be different";
    private static final String PROPERTY_REQUIRED_ERR_MSG = "Property %s is required";
    private final Properties calendarConfiguration;

    public CalendarBean(Properties calendarConfiguration) {
        this.calendarConfiguration = calendarConfiguration;
        this.setup();
    }

    static void formalValidation(StringBuilder errorMessage, Properties calendarConfiguration) {
        CalendarBean.requiredPropertyValidation(errorMessage, calendarConfiguration);
        CalendarBean.propertyFormatValidation(errorMessage, calendarConfiguration);
    }

    static void requiredPropertyValidation(StringBuilder errorMessage, Properties calendarConfiguration) {
        REQUIRED_PROPERTIES.forEach(property -> CalendarBean.validateRequiredProperty(property, errorMessage, calendarConfiguration));
    }

    static void propertyFormatValidation(StringBuilder errorMessage, Properties calendarConfiguration) {
        FORMAT_VALIDATOR_MAP.values().forEach(stringBuilderPropertiesBiConsumer -> stringBuilderPropertiesBiConsumer.accept(errorMessage, calendarConfiguration));
    }

    static void businessValidation(StringBuilder errorMessage, Properties calendarConfiguration) {
        BUSINESS_VALIDATOR_LIST.forEach(stringBuilderPropertiesBiConsumer -> stringBuilderPropertiesBiConsumer.accept(errorMessage, calendarConfiguration));
    }

    static void missingDataPopulation(Properties calendarConfiguration) {
        if (!calendarConfiguration.containsKey("business.weekend.days")) {
            calendarConfiguration.put("business.weekend.days", DEFAULT_WEEKENDS);
        }
        if (!calendarConfiguration.containsKey("business.holiday.date.format")) {
            calendarConfiguration.put("business.holiday.date.format", DEFAULT_HOLIDAY_DATE_FORMAT);
        }
        if (!calendarConfiguration.containsKey("business.cal.timezone")) {
            calendarConfiguration.put("business.cal.timezone", DEFAULT_TIMEZONE);
        }
    }

    static int getPropertyAsInt(String propertyName, Properties calendarConfiguration) {
        String value = calendarConfiguration.getProperty(propertyName);
        return CalendarBean.getStringAsInt(value);
    }

    static int getStringAsInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            logger.error("Number format exception while parsing {} {}", (Object)value, (Object)nfe.getMessage());
            throw nfe;
        }
    }

    static Date getFormattedDate(String date, Properties businessCalendar) throws ParseException {
        SimpleDateFormat sdf = businessCalendar.containsKey("business.holiday.date.format") ? CalendarBean.getSimpleDateFormat(businessCalendar.getProperty("business.holiday.date.format")) : CalendarBean.getSimpleDateFormat(DEFAULT_HOLIDAY_DATE_FORMAT);
        int currentYear = Calendar.getInstance().get(1);
        if (date.startsWith("*")) {
            date = date.replaceFirst("\\*", "" + currentYear);
        }
        return sdf.parse(date);
    }

    static SimpleDateFormat getSimpleDateFormat(String format) throws IllegalArgumentException {
        return new SimpleDateFormat(format);
    }

    static void validateRequiredProperty(String property, StringBuilder errorMessage, Properties calendarConfiguration) {
        String value = calendarConfiguration.getProperty(property);
        if (Objects.isNull(value)) {
            CalendarBean.addMessageToStringBuilder(errorMessage, String.format(PROPERTY_REQUIRED_ERR_MSG, property));
        }
    }

    static boolean isInsideValidRange(int value, int lowerBound, int upperBound) {
        return value >= lowerBound && value <= upperBound;
    }

    private static void addMessageToStringBuilder(StringBuilder stringBuilder, String message) {
        stringBuilder.append(message);
        stringBuilder.append("\n");
    }

    public List<BusinessCalendarImpl.TimePeriod> getHolidays() {
        String[] hPeriods;
        if (!this.calendarConfiguration.containsKey("business.holidays")) {
            return Collections.emptyList();
        }
        String timezone = this.calendarConfiguration.getProperty("business.cal.timezone");
        String holidaysString = this.calendarConfiguration.getProperty("business.holidays");
        ArrayList<BusinessCalendarImpl.TimePeriod> holidays = new ArrayList<BusinessCalendarImpl.TimePeriod>();
        int currentYear = Calendar.getInstance().get(1);
        for (String hPeriod : hPeriods = holidaysString.split(",")) {
            boolean addNextYearHolidays = false;
            String[] fromTo = hPeriod.split(":");
            if (fromTo[0].startsWith("*")) {
                addNextYearHolidays = true;
                fromTo[0] = fromTo[0].replaceFirst("\\*", "" + currentYear);
            }
            try {
                Date from;
                if (fromTo.length == 2) {
                    GregorianCalendar tmpFrom = new GregorianCalendar();
                    if (timezone != null) {
                        ((Calendar)tmpFrom).setTimeZone(TimeZone.getTimeZone(timezone));
                    }
                    tmpFrom.setTime(CalendarBean.getFormattedDate(fromTo[0], this.calendarConfiguration));
                    if (fromTo[1].startsWith("*")) {
                        fromTo[1] = fromTo[1].replaceFirst("\\*", "" + currentYear);
                    }
                    GregorianCalendar tmpTo = new GregorianCalendar();
                    if (timezone != null) {
                        ((Calendar)tmpTo).setTimeZone(TimeZone.getTimeZone(timezone));
                    }
                    tmpTo.setTime(CalendarBean.getFormattedDate(fromTo[1], this.calendarConfiguration));
                    from = tmpFrom.getTime();
                    ((Calendar)tmpTo).add(6, 1);
                    if (tmpFrom.get(2) > tmpTo.get(2) && tmpFrom.get(1) == tmpTo.get(1)) {
                        ((Calendar)tmpTo).add(1, 1);
                    }
                    Date to = tmpTo.getTime();
                    holidays.add(new BusinessCalendarImpl.TimePeriod(from, to));
                    if (!addNextYearHolidays) continue;
                    tmpFrom = new GregorianCalendar();
                    if (timezone != null) {
                        ((Calendar)tmpFrom).setTimeZone(TimeZone.getTimeZone(timezone));
                    }
                    tmpFrom.setTime(CalendarBean.getFormattedDate(fromTo[0], this.calendarConfiguration));
                    ((Calendar)tmpFrom).add(1, 1);
                    from = tmpFrom.getTime();
                    tmpTo = new GregorianCalendar();
                    if (timezone != null) {
                        ((Calendar)tmpTo).setTimeZone(TimeZone.getTimeZone(timezone));
                    }
                    tmpTo.setTime(CalendarBean.getFormattedDate(fromTo[1], this.calendarConfiguration));
                    ((Calendar)tmpTo).add(1, 1);
                    ((Calendar)tmpTo).add(6, 1);
                    if (tmpFrom.get(2) > tmpTo.get(2) && tmpFrom.get(1) == tmpTo.get(1)) {
                        ((Calendar)tmpTo).add(1, 1);
                    }
                    to = tmpTo.getTime();
                    holidays.add(new BusinessCalendarImpl.TimePeriod(from, to));
                    continue;
                }
                GregorianCalendar c = new GregorianCalendar();
                c.setTime(CalendarBean.getFormattedDate(fromTo[0], this.calendarConfiguration));
                ((Calendar)c).add(6, 1);
                holidays.add(new BusinessCalendarImpl.TimePeriod(CalendarBean.getFormattedDate(fromTo[0], this.calendarConfiguration), c.getTime()));
                if (!addNextYearHolidays) continue;
                Calendar tmp = Calendar.getInstance();
                tmp.setTime(CalendarBean.getFormattedDate(fromTo[0], this.calendarConfiguration));
                tmp.add(1, 1);
                from = tmp.getTime();
                ((Calendar)c).add(1, 1);
                holidays.add(new BusinessCalendarImpl.TimePeriod(from, c.getTime()));
            }
            catch (Exception e) {
                logger.error("Error while parsing holiday in business calendar", (Throwable)e);
            }
        }
        return holidays;
    }

    public List<Integer> getWeekendDays() {
        return this.parseWeekendDays(this.calendarConfiguration);
    }

    public int getDaysPerWeek() {
        return 7 - this.parseWeekendDays(this.calendarConfiguration).size();
    }

    public String getTimezone() {
        return this.calendarConfiguration.getProperty("business.cal.timezone");
    }

    public int getStartHour() {
        return this.getPropertyAsInt("business.start.hour");
    }

    public int getEndHour() {
        return this.getPropertyAsInt("business.end.hour");
    }

    public int getHoursInDay() {
        int endHour;
        int startHour = this.getStartHour();
        return startHour < (endHour = this.getEndHour()) ? endHour - startHour : 24 - startHour + endHour;
    }

    protected void setup() {
        StringBuilder errorMessage = new StringBuilder();
        CalendarBean.formalValidation(errorMessage, this.calendarConfiguration);
        CalendarBean.missingDataPopulation(this.calendarConfiguration);
        CalendarBean.businessValidation(errorMessage, this.calendarConfiguration);
        if (!errorMessage.isEmpty()) {
            throw new IllegalArgumentException(errorMessage.toString());
        }
    }

    protected List<Integer> parseWeekendDays(Properties calendarConfiguration) {
        String weekendDays = calendarConfiguration.getProperty("business.weekend.days");
        String[] days = weekendDays.split(",");
        return Arrays.stream(days).map(day -> Integer.parseInt(day.trim())).filter(intDay -> intDay != 0).collect(Collectors.toList());
    }

    protected int getPropertyAsInt(String propertyName) {
        return CalendarBean.getPropertyAsInt(propertyName, this.calendarConfiguration);
    }

    static {
        FORMAT_VALIDATOR_MAP.put("business.start.hour", (stringBuilder, properties) -> {
            if (properties.containsKey("business.start.hour")) {
                try {
                    int hour = CalendarBean.getPropertyAsInt("business.start.hour", properties);
                    if (!CalendarBean.isInsideValidRange(hour, 0, 24)) {
                        CalendarBean.addMessageToStringBuilder(stringBuilder, String.format(OUTSIDE_BOUNDARY_ERROR_MESSAGE, "business.start.hour", hour, "(0-24)"));
                    }
                }
                catch (NumberFormatException e) {
                    CalendarBean.addMessageToStringBuilder(stringBuilder, String.format(INVALID_FORMAT_ERROR_MESSAGE, "business.start.hour", e.getMessage()));
                }
            }
        });
        FORMAT_VALIDATOR_MAP.put("business.end.hour", (stringBuilder, properties) -> {
            if (properties.containsKey("business.end.hour")) {
                try {
                    int hour = CalendarBean.getPropertyAsInt("business.end.hour", properties);
                    if (!CalendarBean.isInsideValidRange(hour, 0, 24)) {
                        CalendarBean.addMessageToStringBuilder(stringBuilder, String.format(OUTSIDE_BOUNDARY_ERROR_MESSAGE, "business.end.hour", hour, "(0-24)"));
                    }
                }
                catch (NumberFormatException e) {
                    CalendarBean.addMessageToStringBuilder(stringBuilder, String.format(INVALID_FORMAT_ERROR_MESSAGE, "business.end.hour", e.getMessage()));
                }
            }
        });
        FORMAT_VALIDATOR_MAP.put("business.holidays", (stringBuilder, properties) -> {
            if (properties.containsKey("business.holidays")) {
                String[] allHolidays;
                String originalData = properties.getProperty("business.holidays");
                for (String holiday : allHolidays = originalData.split(",")) {
                    String[] ranges;
                    for (String range : ranges = holiday.split(":")) {
                        try {
                            CalendarBean.getFormattedDate(range, properties);
                        }
                        catch (ParseException e) {
                            CalendarBean.addMessageToStringBuilder(stringBuilder, String.format(INVALID_FORMAT_ERROR_MESSAGE, "business.holidays", e.getMessage()));
                        }
                    }
                }
            }
        });
        FORMAT_VALIDATOR_MAP.put("business.holiday.date.format", (stringBuilder, properties) -> {
            if (properties.containsKey("business.holiday.date.format")) {
                try {
                    CalendarBean.getSimpleDateFormat((String)properties.get("business.holiday.date.format"));
                }
                catch (IllegalArgumentException e) {
                    CalendarBean.addMessageToStringBuilder(stringBuilder, e.getMessage());
                }
            }
        });
        FORMAT_VALIDATOR_MAP.put("business.weekend.days", (stringBuilder, properties) -> {
            if (properties.containsKey("business.weekend.days")) {
                String originalData = properties.getProperty("business.weekend.days");
                String[] weekendDays = originalData.split(",\\s?");
                Set<String> differentValues = Arrays.stream(weekendDays).collect(Collectors.toSet());
                if (differentValues.size() < weekendDays.length) {
                    CalendarBean.addMessageToStringBuilder(stringBuilder, String.format(REPEATED_VALUES_ERROR_MESSAGE, "business.weekend.days", originalData));
                }
                if (differentValues.contains("0") && differentValues.size() > 1) {
                    CalendarBean.addMessageToStringBuilder(stringBuilder, String.format(OTHER_VALUES_ERR_MSG, "0 (= no weekends)", "business.weekend.days", originalData));
                }
                ArrayList intValues = new ArrayList();
                differentValues.forEach(s -> {
                    try {
                        intValues.add(CalendarBean.getStringAsInt(s));
                    }
                    catch (NumberFormatException e) {
                        CalendarBean.addMessageToStringBuilder(stringBuilder, e.getMessage());
                    }
                });
                if (intValues.stream().anyMatch(value -> value < 0 || value > 7)) {
                    CalendarBean.addMessageToStringBuilder(stringBuilder, String.format(OUTSIDE_BOUNDARY_ERROR_MESSAGE, "business.weekend.days", intValues.stream().filter(value -> value < 0 || value > 7).toList(), "(0-7)"));
                }
            }
        });
        FORMAT_VALIDATOR_MAP.put("business.cal.timezone", (stringBuilder, properties) -> {
            if (properties.containsKey("business.cal.timezone")) {
                String originalData = properties.getProperty("business.cal.timezone");
                if (!Arrays.asList(TimeZone.getAvailableIDs()).contains(originalData)) {
                    CalendarBean.addMessageToStringBuilder(stringBuilder, String.format(INVALID_FORMAT_ERROR_MESSAGE, "business.cal.timezone", originalData));
                }
            }
        });
        BUSINESS_VALIDATOR_LIST = new ArrayList<BiConsumer<StringBuilder, Properties>>();
        BUSINESS_VALIDATOR_LIST.add((stringBuilder, properties) -> {
            if (properties.containsKey("business.start.hour") && properties.containsKey("business.end.hour")) {
                try {
                    int startHour = CalendarBean.getPropertyAsInt("business.start.hour", properties);
                    int endHour = CalendarBean.getPropertyAsInt("business.end.hour", properties);
                    if (startHour == endHour) {
                        CalendarBean.addMessageToStringBuilder(stringBuilder, String.format(VALUES_SAME_ERR_MSG, "business.start.hour", startHour, "business.end.hour", endHour));
                    }
                }
                catch (NumberFormatException nfe) {
                    logger.error("Number format exception while checking equality of start time and end time: {}", (Object)nfe.getMessage());
                }
            }
        });
    }
}

