/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.drools.base.time.TimeUtils;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.KogitoProcessRuntimeImpl;
import org.jbpm.process.instance.event.KogitoProcessEventListenerAdapter;
import org.jbpm.process.instance.event.KogitoProcessEventSupportImpl;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.node.StartNode;
import org.kie.api.definition.process.Process;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.kogito.Application;
import org.kie.kogito.calendar.BusinessCalendar;
import org.kie.kogito.internal.process.event.KogitoProcessEventListener;
import org.kie.kogito.internal.process.event.KogitoProcessEventSupport;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.jobs.DurationExpirationTime;
import org.kie.kogito.jobs.ExactExpirationTime;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.JobDescription;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.descriptors.ProcessJobDescription;
import org.kie.kogito.signal.SignalManager;

public abstract class AbstractProcessRuntime
implements InternalProcessRuntime {
    protected KogitoProcessEventSupport processEventSupport;
    protected KogitoProcessRuntimeImpl kogitoProcessRuntime = new KogitoProcessRuntimeImpl(this);
    protected SignalManager signalManager;
    protected JobsService jobService;
    private final Application application;
    private final Map<ProcessEventListener, KogitoProcessEventListener> listenersMap = new IdentityHashMap<ProcessEventListener, KogitoProcessEventListener>();

    protected AbstractProcessRuntime(Application application) {
        this.application = application;
    }

    public KogitoProcessRuntime getKogitoProcessRuntime() {
        return this.kogitoProcessRuntime;
    }

    @Override
    public KogitoProcessEventSupport getProcessEventSupport() {
        return this.processEventSupport;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    public void addEventListener(ProcessEventListener listener) {
        ((KogitoProcessEventSupportImpl)this.processEventSupport).addEventListener(this.asKogitoProcessEventListener(listener));
    }

    public void removeEventListener(ProcessEventListener listener) {
        ((KogitoProcessEventSupportImpl)this.processEventSupport).removeEventListener(this.removeKogitoProcessEventListener(listener));
    }

    public List<ProcessEventListener> getProcessEventListeners() {
        return ((KogitoProcessEventSupportImpl)this.processEventSupport).getEventListeners();
    }

    protected void initStartTimers(Collection<Process> processes, InternalKnowledgeRuntime kruntime) {
        for (Process process : processes) {
            RuleFlowProcess p = (RuleFlowProcess)process;
            List<StartNode> startNodes = p.getTimerStart();
            if (startNodes == null || startNodes.isEmpty()) continue;
            for (StartNode startNode : startNodes) {
                if (startNode == null || startNode.getTimer() == null) continue;
                this.jobService.scheduleJob((JobDescription)ProcessJobDescription.of((ExpirationTime)this.createTimerInstance(startNode.getTimer(), kruntime), (String)p.getId()));
            }
        }
    }

    private KogitoProcessEventListener asKogitoProcessEventListener(ProcessEventListener processEventListener) {
        if (processEventListener instanceof KogitoProcessEventListener) {
            return (KogitoProcessEventListener)processEventListener;
        }
        return this.listenersMap.computeIfAbsent(processEventListener, KogitoProcessEventListenerAdapter::new);
    }

    private KogitoProcessEventListener removeKogitoProcessEventListener(ProcessEventListener processEventListener) {
        if (processEventListener instanceof KogitoProcessEventListener) {
            return (KogitoProcessEventListener)processEventListener;
        }
        return this.listenersMap.remove(processEventListener);
    }

    protected ExpirationTime createTimerInstance(Timer timer, InternalKnowledgeRuntime kruntime) {
        if (kruntime != null && kruntime.getEnvironment().get("jbpm.business.calendar") != null) {
            BusinessCalendar businessCalendar = (BusinessCalendar)kruntime.getEnvironment().get("jbpm.business.calendar");
            long delay = businessCalendar.calculateBusinessTimeAsDuration(timer.getDelay());
            if (timer.getPeriod() == null) {
                return DurationExpirationTime.repeat((long)delay);
            }
            long period = businessCalendar.calculateBusinessTimeAsDuration(timer.getPeriod());
            return DurationExpirationTime.repeat((long)delay, (Long)period);
        }
        return this.configureTimerInstance(timer);
    }

    private ExpirationTime configureTimerInstance(Timer timer) {
        long duration = -1L;
        switch (timer.getTimeType()) {
            case 2: {
                long[] repeatValues = DateTimeUtils.parseRepeatableDateTime(timer.getDelay());
                if (repeatValues.length == 3) {
                    return DurationExpirationTime.repeat((long)repeatValues[1], (Long)repeatValues[2]);
                }
                long delay = repeatValues[0];
                long period = -1L;
                try {
                    period = TimeUtils.parseTimeString((String)timer.getPeriod());
                }
                catch (RuntimeException e) {
                    period = repeatValues[0];
                }
                return DurationExpirationTime.repeat((long)delay, (Long)period);
            }
            case 1: {
                duration = DateTimeUtils.parseDuration(timer.getDelay());
                return DurationExpirationTime.repeat((long)duration);
            }
            case 3: {
                return ExactExpirationTime.of((String)timer.getDate());
            }
        }
        throw new UnsupportedOperationException("Not supported timer definition");
    }
}

