/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance;

import java.util.Optional;
import org.jbpm.process.instance.LightWorkItemManager;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.process.instance.ProcessRuntimeServiceProvider;
import org.jbpm.process.instance.event.KogitoProcessEventSupportImpl;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManager;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.internal.process.event.KogitoProcessEventListener;
import org.kie.kogito.internal.process.event.KogitoProcessEventSupport;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemManager;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.process.ProcessEventListenerConfig;
import org.kie.kogito.process.WorkItemHandlerConfig;
import org.kie.kogito.services.signal.LightSignalManager;
import org.kie.kogito.signal.SignalManager;
import org.kie.kogito.signal.SignalManagerHub;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kie.kogito.uow.events.UnitOfWorkProcessEventListener;

public class AbstractProcessRuntimeServiceProvider
implements ProcessRuntimeServiceProvider {
    private final JobsService jobsService;
    private final ProcessInstanceManager processInstanceManager;
    private final SignalManager signalManager;
    private final KogitoWorkItemManager workItemManager;
    private final KogitoProcessEventSupport eventSupport;
    private final UnitOfWorkManager unitOfWorkManager;

    public AbstractProcessRuntimeServiceProvider(JobsService jobsService, WorkItemHandlerConfig workItemHandlerProvider, ProcessEventListenerConfig processEventListenerProvider, SignalManagerHub compositeSignalManager, UnitOfWorkManager unitOfWorkManager, IdentityProvider identityProvider) {
        this.unitOfWorkManager = unitOfWorkManager;
        this.processInstanceManager = new DefaultProcessInstanceManager();
        this.signalManager = new LightSignalManager(id -> Optional.ofNullable(this.processInstanceManager.getProcessInstance(id)), compositeSignalManager);
        this.eventSupport = new KogitoProcessEventSupportImpl(identityProvider);
        this.jobsService = jobsService;
        this.workItemManager = new LightWorkItemManager(this.processInstanceManager, this.signalManager, this.eventSupport);
        for (String workItem : workItemHandlerProvider.names()) {
            this.workItemManager.registerWorkItemHandler(workItem, workItemHandlerProvider.forName(workItem));
        }
        this.eventSupport.addEventListener((KogitoProcessEventListener)new UnitOfWorkProcessEventListener(unitOfWorkManager));
        for (ProcessEventListener listener : processEventListenerProvider.listeners()) {
            this.eventSupport.addEventListener((KogitoProcessEventListener)listener);
        }
    }

    @Override
    public JobsService getJobsService() {
        return this.jobsService;
    }

    @Override
    public ProcessInstanceManager getProcessInstanceManager() {
        return this.processInstanceManager;
    }

    @Override
    public SignalManager getSignalManager() {
        return this.signalManager;
    }

    @Override
    public KogitoWorkItemManager getKogitoWorkItemManager() {
        return this.workItemManager;
    }

    @Override
    public KogitoProcessEventSupport getEventSupport() {
        return this.eventSupport;
    }

    @Override
    public UnitOfWorkManager getUnitOfWorkManager() {
        return this.unitOfWorkManager;
    }
}

