/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.drools.core.process.WorkItem;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.kie.kogito.internal.process.event.KogitoProcessEventSupport;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.workitem.KogitoWorkItem;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemHandlerNotFoundException;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemManager;
import org.kie.kogito.internal.process.workitem.Policy;
import org.kie.kogito.internal.process.workitem.WorkItemNotFoundException;
import org.kie.kogito.internal.process.workitem.WorkItemTerminationType;
import org.kie.kogito.internal.process.workitem.WorkItemTransition;
import org.kie.kogito.process.workitems.InternalKogitoWorkItem;
import org.kie.kogito.process.workitems.InternalKogitoWorkItemManager;
import org.kie.kogito.signal.SignalManager;

public class LightWorkItemManager
implements InternalKogitoWorkItemManager {
    private Map<String, InternalKogitoWorkItem> workItems = new ConcurrentHashMap<String, InternalKogitoWorkItem>();
    private Map<String, KogitoWorkItemHandler> workItemHandlers = new HashMap<String, KogitoWorkItemHandler>();
    private final ProcessInstanceManager processInstanceManager;
    private final SignalManager signalManager;
    private final KogitoProcessEventSupport eventSupport;

    public LightWorkItemManager(ProcessInstanceManager processInstanceManager, SignalManager signalManager, KogitoProcessEventSupport eventSupport) {
        this.processInstanceManager = processInstanceManager;
        this.signalManager = signalManager;
        this.eventSupport = eventSupport;
    }

    public KogitoWorkItemHandler getKogitoWorkItemHandler(String name) {
        return this.workItemHandlers.get(name);
    }

    public void registerWorkItemHandler(String workItemName, KogitoWorkItemHandler handler) {
        this.workItemHandlers.put(workItemName, handler);
    }

    public void internalAddWorkItem(InternalKogitoWorkItem workItem) {
        this.workItems.put(workItem.getStringId(), workItem);
    }

    public InternalKogitoWorkItem getWorkItem(String workItemId) {
        InternalKogitoWorkItem workItem = this.workItems.get(workItemId);
        if (workItem == null) {
            throw new WorkItemNotFoundException("Work Item (" + workItemId + ") does not exist", workItemId);
        }
        return workItem;
    }

    public void internalRemoveWorkItem(String id) {
        this.workItems.remove(id);
    }

    public void internalExecuteWorkItem(InternalKogitoWorkItem workItem) {
        this.internalAddWorkItem(workItem);
        KogitoWorkItemHandler handler = this.getWorkItemHandler(workItem);
        WorkItemTransition transition = handler.startingTransition(Collections.emptyMap(), new Policy[0]);
        this.transitionWorkItem(workItem, transition, true);
    }

    public KogitoWorkItemHandler getWorkItemHandler(String workItemId) throws KogitoWorkItemHandlerNotFoundException {
        InternalKogitoWorkItem workItem = this.workItems.get(workItemId);
        if (workItem == null) {
            throw new WorkItemNotFoundException(workItemId);
        }
        return this.getWorkItemHandler(workItem);
    }

    public KogitoWorkItemHandler getWorkItemHandler(InternalKogitoWorkItem workItem) throws KogitoWorkItemHandlerNotFoundException {
        KogitoWorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
        if (handler == null) {
            throw new KogitoWorkItemHandlerNotFoundException(workItem.getName());
        }
        return handler;
    }

    public void internalAbortWorkItem(String workItemId) {
        InternalKogitoWorkItem workItem = this.getWorkItem(workItemId);
        KogitoWorkItemHandler handler = this.getWorkItemHandler(workItem);
        this.transitionWorkItem(workItem, handler.abortTransition(workItem.getPhaseStatus(), new Policy[0]), false);
    }

    public void retryWorkItem(String workItemId, Map<String, Object> params) {
        InternalKogitoWorkItem workItem = this.workItems.get(workItemId);
        if (workItem == null) {
            throw new WorkItemNotFoundException(workItemId);
        }
        workItem.setPhaseId(null);
        workItem.setPhaseStatus(null);
        if (params != null && !params.isEmpty()) {
            workItem.setParameters(params);
        }
        KogitoWorkItemHandler handler = this.getWorkItemHandler(workItem);
        WorkItemTransition transition = handler.startingTransition(Collections.emptyMap(), new Policy[0]);
        this.transitionWorkItem(workItem, transition, true);
    }

    public void completeWorkItem(String workItemId, Map<String, Object> data, Policy ... policies) {
        InternalKogitoWorkItem workItem = this.getWorkItem(workItemId);
        KogitoWorkItemHandler handler = this.getWorkItemHandler(workItem);
        this.transitionWorkItem(workItem, handler.completeTransition(workItem.getPhaseStatus(), data, policies), false);
        KogitoProcessInstance processInstance = this.processInstanceManager.getProcessInstance(workItem.getProcessInstanceStringId());
        workItem.setState(2);
        processInstance.signalEvent("workItemCompleted", (Object)workItem);
    }

    public void abortWorkItem(String workItemId, Policy ... policies) {
        InternalKogitoWorkItem workItem = this.getWorkItem(workItemId);
        KogitoWorkItemHandler handler = this.getWorkItemHandler(workItemId);
        this.transitionWorkItem(workItem, handler.abortTransition(workItem.getPhaseStatus(), policies), false);
        KogitoProcessInstance processInstance = this.processInstanceManager.getProcessInstance(workItem.getProcessInstanceStringId());
        workItem.setState(3);
        processInstance.signalEvent("workItemAborted", (Object)workItem);
    }

    public <T> T updateWorkItem(String workItemId, Function<KogitoWorkItem, T> updater, Policy ... policies) {
        InternalKogitoWorkItem workItem = this.getWorkItem(workItemId);
        Stream.of(policies).forEach(p -> p.enforce((KogitoWorkItem)workItem));
        T results = updater.apply((KogitoWorkItem)workItem);
        return results;
    }

    public void internalCompleteWorkItem(InternalKogitoWorkItem workItem) {
        KogitoWorkItemHandler handler = this.getWorkItemHandler(workItem);
        this.transitionWorkItem(workItem.getStringId(), handler.completeTransition(workItem.getPhaseStatus(), Collections.emptyMap(), new Policy[0]));
    }

    public void transitionWorkItem(String workItemId, WorkItemTransition transition) {
        InternalKogitoWorkItem workItem = this.getWorkItem(workItemId);
        this.transitionWorkItem(workItem, transition, true);
    }

    public Collection<String> getHandlerIds() {
        return this.workItemHandlers.keySet();
    }

    private void transitionWorkItem(InternalKogitoWorkItem workItem, WorkItemTransition transition, boolean signal) {
        KogitoWorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
        if (handler == null) {
            throw new KogitoWorkItemHandlerNotFoundException(workItem.getName());
        }
        KogitoProcessInstance processInstance = this.processInstanceManager.getProcessInstance(workItem.getProcessInstanceStringId());
        WorkItemTransition lastTransition = null;
        Optional nextTransition = Optional.of(transition);
        while (nextTransition.isPresent()) {
            lastTransition = nextTransition.get();
            this.eventSupport.fireBeforeWorkItemTransition(workItem.getProcessInstance(), (KogitoWorkItem)workItem, lastTransition, null);
            nextTransition = handler.transitionToPhase((KogitoWorkItemManager)this, (KogitoWorkItem)workItem, nextTransition.get());
            processInstance.signalEvent("workItemTransition", (Object)transition);
            this.eventSupport.fireAfterWorkItemTransition(workItem.getProcessInstance(), (KogitoWorkItem)workItem, lastTransition, null);
        }
        if (lastTransition.termination().isPresent() && signal) {
            switch ((WorkItemTerminationType)lastTransition.termination().get()) {
                case COMPLETE: {
                    workItem.setState(2);
                    processInstance.signalEvent("workItemCompleted", (Object)workItem);
                    break;
                }
                case ABORT: {
                    workItem.setState(3);
                    processInstance.signalEvent("workItemAborted", (Object)workItem);
                }
            }
        }
    }

    public void clear() {
        this.workItems.clear();
    }

    public void signalEvent(String type, Object event) {
        this.signalManager.signalEvent(type, event);
    }

    public void signalEvent(String type, Object event, String processInstanceId) {
        this.signalManager.signalEvent(processInstanceId, type, event);
    }

    public void dispose() {
        throw new UnsupportedOperationException();
    }

    public Set<WorkItem> getWorkItems() {
        throw new UnsupportedOperationException();
    }

    public void completeWorkItem(long l, Map<String, Object> map) {
        throw new UnsupportedOperationException();
    }

    public void abortWorkItem(long l) {
        throw new UnsupportedOperationException();
    }
}

