/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.context.exception;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import org.jbpm.process.core.context.exception.CompensationHandler;
import org.jbpm.process.core.context.exception.CompensationScope;
import org.jbpm.process.core.context.exception.ExceptionHandler;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.context.exception.ExceptionScopeInstance;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.jbpm.workflow.instance.node.EventSubProcessNodeInstance;
import org.kie.api.definition.process.Node;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompensationScopeInstance
extends ExceptionScopeInstance {
    private static Logger LOG = LoggerFactory.getLogger(CompensationScopeInstance.class);
    private static final long serialVersionUID = 510L;
    private Stack<NodeInstance> compensationInstances = new Stack();

    @Override
    public String getContextType() {
        return "CompensationScope";
    }

    public void addCompensationInstances(Collection<NodeInstance> generatedInstances) {
        this.compensationInstances.addAll(generatedInstances);
    }

    @Override
    public void handleException(String activityRef, KogitoProcessContext dunno) {
        LOG.debug("Compensating exception {}", (Object)activityRef);
        assert (activityRef != null) : "It should not be possible for the compensation activity reference to be null here.";
        CompensationScope compensationScope = (CompensationScope)this.getExceptionScope();
        if (activityRef.startsWith("implicit:")) {
            activityRef = activityRef.substring("implicit:".length());
            assert (activityRef.equals(compensationScope.getContextContainerId())) : "Compensation activity ref [" + activityRef + "] does not match Compensation Scope container id [" + compensationScope.getContextContainerId() + "]";
            Map<String, ExceptionHandler> handlers = compensationScope.getExceptionHandlers();
            List<String> completedNodeIds = ((WorkflowProcessInstanceImpl)this.getProcessInstance()).getCompletedNodeIds();
            ListIterator<String> iter = completedNodeIds.listIterator(completedNodeIds.size());
            while (iter.hasPrevious()) {
                String completedId = iter.previous();
                ExceptionHandler handler = handlers.get(completedId);
                if (handler == null) continue;
                this.handleException(handler, completedId, null);
            }
        } else {
            ExceptionHandler handler = compensationScope.getExceptionHandler(activityRef);
            if (handler == null) {
                throw new IllegalArgumentException("Could not find CompensationHandler for " + activityRef);
            }
            this.handleException(handler, activityRef, null);
        }
        while (!this.compensationInstances.isEmpty()) {
            NodeInstance generatedInstance = this.compensationInstances.pop();
            ((NodeInstanceContainer)generatedInstance.getNodeInstanceContainer()).removeNodeInstance(generatedInstance);
        }
    }

    @Override
    public void handleException(ExceptionHandler handler, String compensationActivityRef, KogitoProcessContext dunno) {
        LOG.info("Compensating 2 exception {}", (Object)compensationActivityRef);
        WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)this.getProcessInstance();
        NodeInstanceContainer nodeInstanceContainer = (NodeInstanceContainer)((Object)this.getContextInstanceContainer());
        if (handler instanceof CompensationHandler) {
            CompensationHandler compensationHandler = (CompensationHandler)handler;
            try {
                List<String> completedIds;
                Node handlerNode = compensationHandler.getnode();
                if (handlerNode instanceof BoundaryEventNode) {
                    NodeInstance compensationHandlerNodeInstance = nodeInstanceContainer.getNodeInstance(handlerNode);
                    this.compensationInstances.add(compensationHandlerNodeInstance);
                    EventNodeInstance eventNodeInstance = (EventNodeInstance)compensationHandlerNodeInstance;
                    eventNodeInstance.signalEvent("Compensation", compensationActivityRef);
                } else if (handlerNode instanceof EventSubProcessNode && (completedIds = processInstance.getCompletedNodeIds()).contains(((NodeImpl)((org.jbpm.workflow.core.Node)handlerNode).getParentContainer()).getUniqueId())) {
                    NodeInstance subProcessNodeInstance = nodeInstanceContainer.getNodeInstance((Node)((org.jbpm.workflow.core.Node)handlerNode).getParentContainer());
                    this.compensationInstances.add(subProcessNodeInstance);
                    NodeInstance compensationHandlerNodeInstance = ((NodeInstanceContainer)((Object)subProcessNodeInstance)).getNodeInstance(handlerNode);
                    this.compensationInstances.add(compensationHandlerNodeInstance);
                    EventSubProcessNodeInstance eventNodeInstance = (EventSubProcessNodeInstance)compensationHandlerNodeInstance;
                    eventNodeInstance.signalEvent("Compensation", compensationActivityRef);
                }
                assert (handlerNode instanceof BoundaryEventNode || handlerNode instanceof EventSubProcessNode) : "Unexpected compensation handler node type : " + handlerNode.getClass().getSimpleName();
            }
            catch (Exception e) {
                this.throwWorkflowRuntimeException(nodeInstanceContainer, processInstance, "Unable to execute compensation.", e);
            }
        } else {
            IllegalArgumentException e = new IllegalArgumentException("Unsupported compensation handler: " + handler);
            this.throwWorkflowRuntimeException(nodeInstanceContainer, processInstance, e.getMessage(), e);
        }
    }

    private void throwWorkflowRuntimeException(NodeInstanceContainer nodeInstanceContainer, ProcessInstance processInstance, String msg, Exception e) {
        if (nodeInstanceContainer instanceof NodeInstance) {
            throw new WorkflowRuntimeException((KogitoNodeInstance)nodeInstanceContainer, processInstance, msg, e);
        }
        throw new WorkflowRuntimeException(null, processInstance, msg, e);
    }
}

