/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.event;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.jbpm.process.instance.event.ErrorEventImpl;
import org.jbpm.process.instance.event.KogitoProcessNodeLeftEventImpl;
import org.jbpm.process.instance.event.KogitoProcessNodeTriggeredEventImpl;
import org.jbpm.process.instance.event.KogitoProcessVariableChangedEventImpl;
import org.jbpm.process.instance.event.KogitoProcessWorkItemTransitionEventImpl;
import org.jbpm.process.instance.event.MessageEventImpl;
import org.jbpm.process.instance.event.ProcessCompletedEventImpl;
import org.jbpm.process.instance.event.ProcessMigrationEventImpl;
import org.jbpm.process.instance.event.ProcessRetriggeredEventImpl;
import org.jbpm.process.instance.event.ProcessStartedEventImpl;
import org.jbpm.process.instance.event.SLAViolatedEventImpl;
import org.jbpm.process.instance.event.SignalEventImpl;
import org.kie.api.event.process.ErrorEvent;
import org.kie.api.event.process.ProcessMigrationEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.Closeable;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.internal.process.event.KogitoProcessEventListener;
import org.kie.kogito.internal.process.event.KogitoProcessEventSupport;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.workitem.KogitoWorkItem;
import org.kie.kogito.internal.process.workitem.WorkItemTransition;

public class KogitoProcessEventSupportImpl
implements KogitoProcessEventSupport {
    private final List<KogitoProcessEventListener> listeners = new CopyOnWriteArrayList<KogitoProcessEventListener>();
    private final IdentityProvider identityProvider;

    public KogitoProcessEventSupportImpl(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    private void notifyAllListeners(Consumer<KogitoProcessEventListener> consumer) {
        this.listeners.forEach(l -> consumer.accept((KogitoProcessEventListener)l));
    }

    public final synchronized void addEventListener(KogitoProcessEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public final void removeEventListener(KogitoProcessEventListener listener) {
        this.listeners.remove(listener);
    }

    public List<KogitoProcessEventListener> getEventListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    private void clear() {
        this.listeners.forEach(l -> {
            if (l instanceof Closeable) {
                ((Closeable)l).close();
            }
        });
        this.listeners.clear();
    }

    public void fireBeforeProcessStarted(KogitoProcessInstance instance, KieRuntime kruntime) {
        ProcessStartedEventImpl event = new ProcessStartedEventImpl((ProcessInstance)instance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.beforeProcessStarted(event));
    }

    public void fireAfterProcessStarted(KogitoProcessInstance instance, KieRuntime kruntime) {
        ProcessStartedEventImpl event = new ProcessStartedEventImpl((ProcessInstance)instance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.afterProcessStarted(event));
    }

    public void fireBeforeProcessCompleted(KogitoProcessInstance instance, KieRuntime kruntime) {
        ProcessCompletedEventImpl event = new ProcessCompletedEventImpl((ProcessInstance)instance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.beforeProcessCompleted(event));
    }

    public void fireAfterProcessCompleted(KogitoProcessInstance instance, KieRuntime kruntime) {
        ProcessCompletedEventImpl event = new ProcessCompletedEventImpl((ProcessInstance)instance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.afterProcessCompleted(event));
    }

    public void fireBeforeNodeTriggered(KogitoNodeInstance nodeInstance, KieRuntime kruntime) {
        KogitoProcessNodeTriggeredEventImpl event = new KogitoProcessNodeTriggeredEventImpl(nodeInstance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.beforeNodeTriggered(event));
    }

    public void fireAfterNodeTriggered(KogitoNodeInstance nodeInstance, KieRuntime kruntime) {
        KogitoProcessNodeTriggeredEventImpl event = new KogitoProcessNodeTriggeredEventImpl(nodeInstance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.afterNodeTriggered(event));
    }

    public void fireBeforeNodeLeft(KogitoNodeInstance nodeInstance, KieRuntime kruntime) {
        KogitoProcessNodeLeftEventImpl event = new KogitoProcessNodeLeftEventImpl((NodeInstance)nodeInstance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.beforeNodeLeft(event));
    }

    public void fireAfterNodeLeft(KogitoNodeInstance nodeInstance, KieRuntime kruntime) {
        KogitoProcessNodeLeftEventImpl event = new KogitoProcessNodeLeftEventImpl((NodeInstance)nodeInstance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.afterNodeLeft(event));
    }

    public void fireBeforeVariableChanged(String id, String instanceId, Object oldValue, Object newValue, List<String> tags, KogitoProcessInstance processInstance, KogitoNodeInstance nodeInstance, KieRuntime kruntime) {
        KogitoProcessVariableChangedEventImpl event = new KogitoProcessVariableChangedEventImpl(id, instanceId, oldValue, newValue, tags, (ProcessInstance)processInstance, nodeInstance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(arg_0 -> KogitoProcessEventSupportImpl.lambda$fireBeforeVariableChanged$10((ProcessVariableChangedEvent)event, arg_0));
    }

    public void fireAfterVariableChanged(String name, String id, Object oldValue, Object newValue, List<String> tags, KogitoProcessInstance processInstance, KogitoNodeInstance nodeInstance, KieRuntime kruntime) {
        KogitoProcessVariableChangedEventImpl event = new KogitoProcessVariableChangedEventImpl(name, id, oldValue, newValue, tags, (ProcessInstance)processInstance, nodeInstance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(arg_0 -> KogitoProcessEventSupportImpl.lambda$fireAfterVariableChanged$11((ProcessVariableChangedEvent)event, arg_0));
    }

    public void fireBeforeSLAViolated(KogitoProcessInstance instance, KieRuntime kruntime) {
        SLAViolatedEventImpl event = new SLAViolatedEventImpl((ProcessInstance)instance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.beforeSLAViolated(event));
    }

    public void fireAfterSLAViolated(KogitoProcessInstance instance, KieRuntime kruntime) {
        SLAViolatedEventImpl event = new SLAViolatedEventImpl((ProcessInstance)instance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.afterSLAViolated(event));
    }

    public void fireBeforeSLAViolated(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, KieRuntime kruntime) {
        SLAViolatedEventImpl event = new SLAViolatedEventImpl((ProcessInstance)instance, (NodeInstance)nodeInstance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.beforeSLAViolated(event));
    }

    public void fireAfterSLAViolated(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, KieRuntime kruntime) {
        SLAViolatedEventImpl event = new SLAViolatedEventImpl((ProcessInstance)instance, (NodeInstance)nodeInstance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.afterSLAViolated(event));
    }

    public void fireBeforeWorkItemTransition(KogitoProcessInstance instance, KogitoWorkItem workitem, WorkItemTransition transition, KieRuntime kruntime) {
        KogitoProcessWorkItemTransitionEventImpl event = new KogitoProcessWorkItemTransitionEventImpl((ProcessInstance)instance, workitem, transition, kruntime, false, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.beforeWorkItemTransition(event));
    }

    public void fireAfterWorkItemTransition(KogitoProcessInstance instance, KogitoWorkItem workitem, WorkItemTransition transition, KieRuntime kruntime) {
        KogitoProcessWorkItemTransitionEventImpl event = new KogitoProcessWorkItemTransitionEventImpl((ProcessInstance)instance, workitem, transition, kruntime, true, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.afterWorkItemTransition(event));
    }

    public void fireOnSignal(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, KieRuntime kruntime, String signalName, Object signalObject) {
        SignalEventImpl event = new SignalEventImpl((ProcessInstance)instance, kruntime, (NodeInstance)nodeInstance, signalName, signalObject, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.onSignal(event));
    }

    public void fireOnMessage(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, KieRuntime kruntime, String messageName, Object messageObject) {
        MessageEventImpl event = new MessageEventImpl((ProcessInstance)instance, kruntime, (NodeInstance)nodeInstance, messageName, messageObject, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.onMessage(event));
    }

    public void fireOnMigration(KogitoProcessInstance processInstance, KieRuntime kruntime) {
        ProcessMigrationEventImpl event = new ProcessMigrationEventImpl((ProcessInstance)processInstance, kruntime, "System");
        this.notifyAllListeners(l -> l.onMigration((ProcessMigrationEvent)event));
    }

    public void reset() {
        this.clear();
    }

    public void fireOnError(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, KieRuntime kruntime, Exception exception) {
        ErrorEventImpl event = new ErrorEventImpl((ProcessInstance)instance, kruntime, (NodeInstance)nodeInstance, exception);
        this.notifyAllListeners(l -> l.onError((ErrorEvent)event));
    }

    public void fireProcessRetriggered(KogitoProcessInstance instance, KieRuntime kruntime) {
        ProcessRetriggeredEventImpl event = new ProcessRetriggeredEventImpl((ProcessInstance)instance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.onProcessRetriggered(event));
    }

    private static /* synthetic */ void lambda$fireAfterVariableChanged$11(ProcessVariableChangedEvent event, KogitoProcessEventListener l) {
        l.afterVariableChanged(event);
    }

    private static /* synthetic */ void lambda$fireBeforeVariableChanged$10(ProcessVariableChangedEvent event, KogitoProcessEventListener l) {
        l.beforeVariableChanged(event);
    }
}

