/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.workitem.Policy;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstanceNotFoundException;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.WorkItem;

public class JsonSchemaUtil {
    private static ObjectMapper mapper = new ObjectMapper();
    private static String jsonDir = "META-INF/jsonSchema/";

    private JsonSchemaUtil() {
    }

    public static String getJsonSchemaName(String id) {
        return id.replace('.', '#').replaceAll("\\s", "_");
    }

    public static String getJsonSchemaName(String processId, String taskName) {
        return JsonSchemaUtil.getJsonSchemaName(processId + "_" + taskName);
    }

    public static Path getJsonDir() {
        return Path.of(jsonDir, new String[0]);
    }

    public static String getFileName(String key) {
        return key + ".json";
    }

    public static Map<String, Object> load(ClassLoader cl, String processId) {
        return JsonSchemaUtil.loadSchema(cl, processId);
    }

    public static Map<String, Object> load(ClassLoader cl, String processId, String taskName) {
        return JsonSchemaUtil.loadSchema(cl, JsonSchemaUtil.getJsonSchemaName(processId, taskName));
    }

    private static Map<String, Object> loadSchema(ClassLoader cl, String schemaId) {
        Map<String, Object> map;
        block9: {
            String jsonFile = JsonSchemaUtil.pathFor(schemaId);
            InputStream in = cl.getResourceAsStream(jsonFile);
            try {
                if (in == null) {
                    throw new IllegalArgumentException("Cannot find file " + jsonFile + " in classpath");
                }
                map = JsonSchemaUtil.load(in);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException io) {
                    throw new IllegalStateException("Error loading schema " + jsonFile, io);
                }
            }
            in.close();
        }
        return map;
    }

    public static Map<String, Object> load(InputStream in) throws IOException {
        return (Map)mapper.readValue(in, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public static <T> Map<String, Object> addPhases(Process<T> process, KogitoWorkItemHandler workItemHandler, String processInstanceId, String workItemId, Policy[] policies, Map<String, Object> jsonSchema) {
        return process.instances().findById(processInstanceId, ProcessInstanceReadMode.READ_ONLY).map(pi -> {
            WorkItem workItem = pi.workItem(workItemId, policies);
            Set transitions = workItemHandler.allowedTransitions(workItem.getPhaseStatus());
            jsonSchema.put("phases", transitions);
            return jsonSchema;
        }).orElseThrow(() -> new ProcessInstanceNotFoundException(processInstanceId));
    }

    public static String pathFor(String key) {
        return jsonDir + JsonSchemaUtil.getFileName(key);
    }
}

