/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.node.EventNodeInterface;
import org.jbpm.workflow.instance.WorkflowProcessParameters;
import org.kie.api.definition.process.Connection;

public class EventNode
extends ExtendedNodeImpl
implements EventNodeInterface {
    private static final long serialVersionUID = 510L;
    private List<EventFilter> filters = new ArrayList<EventFilter>();
    private String inputVariableName;
    private String variableName;
    private String scope;

    @Override
    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getInputVariableName() {
        return this.inputVariableName;
    }

    public void setInputVariableName(String inputVariableName) {
        this.inputVariableName = inputVariableName;
    }

    public void addEventFilter(EventFilter eventFilter) {
        this.filters.add(eventFilter);
    }

    public void removeEventFilter(EventFilter eventFilter) {
        this.filters.remove(eventFilter);
    }

    public List<EventFilter> getEventFilters() {
        return this.filters;
    }

    public void setEventFilters(List<EventFilter> filters) {
        this.filters = filters;
    }

    public String getType() {
        for (EventFilter filter : this.filters) {
            if (!(filter instanceof EventTypeFilter)) continue;
            return ((EventTypeFilter)filter).getType();
        }
        return null;
    }

    @Override
    public boolean acceptsEvent(String type, Object event, Function<String, Object> resolver) {
        for (EventFilter filter : this.filters) {
            if (filter.acceptsEvent(type, event, resolver)) continue;
            return false;
        }
        return true;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public void validateAddIncomingConnection(String type, Connection connection) {
        super.validateAddIncomingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node [" + connection.getTo().getUniqueId() + ", " + connection.getTo().getName() + "] only accepts default incoming connection type!");
        }
        if (this.getFrom() != null && !WorkflowProcessParameters.WORKFLOW_PARAM_MULTIPLE_CONNECTIONS.get(this.getProcess()).booleanValue()) {
            throw new IllegalArgumentException("This type of node [" + connection.getTo().getUniqueId() + ", " + connection.getTo().getName() + "] cannot have more than one incoming connection!");
        }
    }

    @Override
    public void validateAddOutgoingConnection(String type, Connection connection) {
        super.validateAddOutgoingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node [" + connection.getFrom().getUniqueId() + ", " + connection.getFrom().getName() + "] only accepts default outgoing connection type!");
        }
        if (this.getTo() != null && !WorkflowProcessParameters.WORKFLOW_PARAM_MULTIPLE_CONNECTIONS.get(this.getProcess()).booleanValue()) {
            throw new IllegalArgumentException("This type of node [" + connection.getFrom().getUniqueId() + ", " + connection.getFrom().getName() + "] cannot have more than one outgoing connection!");
        }
    }
}

