/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.node.Trigger;
import org.jbpm.workflow.instance.WorkflowProcessParameters;
import org.kie.api.definition.process.Connection;

public class StartNode
extends ExtendedNodeImpl {
    private static final String[] EVENT_TYPES = new String[]{"onExit"};
    private static final long serialVersionUID = 510L;
    private List<Trigger> triggers;
    private boolean isInterrupting;
    private Timer timer;

    public StartNode() {
        this.setMetaData("EventType", "none");
    }

    public void addTrigger(Trigger trigger) {
        if (this.triggers == null) {
            this.triggers = new ArrayList<Trigger>();
        }
        this.triggers.add(trigger);
    }

    public void removeTrigger(Trigger trigger) {
        if (this.triggers != null) {
            this.triggers.remove(trigger);
        }
    }

    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(List<Trigger> triggers) {
        this.triggers = triggers;
    }

    @Override
    public String[] getActionTypes() {
        return EVENT_TYPES;
    }

    @Override
    public void validateAddIncomingConnection(String type, Connection connection) {
        throw new UnsupportedOperationException("A start node [" + this.getUniqueId() + ", " + this.getName() + "] may not have an incoming connection!");
    }

    @Override
    public void validateRemoveIncomingConnection(String type, Connection connection) {
        throw new UnsupportedOperationException("A start node [" + this.getUniqueId() + ", " + this.getName() + "] may not have an incoming connection!");
    }

    @Override
    public void validateAddOutgoingConnection(String type, Connection connection) {
        super.validateAddOutgoingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A start node [" + this.getUniqueId() + ", " + this.getName() + "] only accepts default outgoing connection type!");
        }
        if (this.getTo() != null && !WorkflowProcessParameters.WORKFLOW_PARAM_MULTIPLE_CONNECTIONS.get(this.getProcess()).booleanValue()) {
            throw new IllegalArgumentException("A start node [" + this.getUniqueId() + ", " + this.getName() + "] cannot have more than one outgoing connection!");
        }
    }

    public boolean isInterrupting() {
        return this.isInterrupting;
    }

    public void setInterrupting(boolean isInterrupting) {
        this.isInterrupting = isInterrupting;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }
}

