/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance;

import java.util.function.Function;
import org.kie.api.definition.process.Process;

public class WorkflowProcessParameters {
    public static final WorkflowProcessParameter<Boolean> WORKFLOW_PARAM_MULTIPLE_CONNECTIONS = WorkflowProcessParameters.newBooleanParameter("jbpm.enable.multi.con");
    public static final WorkflowProcessParameter<Boolean> WORKFLOW_PARAM_TRANSACTIONS = WorkflowProcessParameters.newBooleanParameter("jbpm.transactions.enable");

    public static WorkflowProcessParameter<String> newStringParameter(String name) {
        return new WorkflowProcessParameter<String>(name, Function.identity());
    }

    public static WorkflowProcessParameter<Boolean> newBooleanParameter(String name) {
        return new WorkflowProcessParameter<Boolean>(name, Boolean::parseBoolean);
    }

    public static class WorkflowProcessParameter<T> {
        private String name;
        private Function<String, T> converter;

        WorkflowProcessParameter(String name, Function<String, T> converter) {
            this.name = name;
            this.converter = converter;
        }

        public String getName() {
            return this.name;
        }

        public T get(Process workflowProcess) {
            return this.converter.apply((String)workflowProcess.getMetaData().get(this.name));
        }
    }
}

