/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.kie.api.definition.process.WorkflowElementIdentifier;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;

public class WorkflowRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 8210449548783940188L;
    private String processInstanceId;
    private String processId;
    private String nodeInstanceId;
    private WorkflowElementIdentifier nodeId;
    private String nodeName;
    private String deploymentId;
    private Map<String, Object> variables;

    public WorkflowRuntimeException(KogitoNodeInstance nodeInstance, KogitoProcessInstance processInstance, String message) {
        super(message);
        this.initialize(nodeInstance, processInstance);
    }

    public WorkflowRuntimeException(KogitoNodeInstance nodeInstance, KogitoProcessInstance processInstance, String message, Throwable e) {
        super(message, e);
        this.initialize(nodeInstance, processInstance);
    }

    public WorkflowRuntimeException(KogitoNodeInstance nodeInstance, KogitoProcessInstance processInstance, Exception e) {
        super(e);
        this.initialize(nodeInstance, processInstance);
    }

    private void initialize(KogitoNodeInstance nodeInstance, KogitoProcessInstance processInstance) {
        VariableScopeInstance variableScope;
        this.processInstanceId = processInstance.getStringId();
        this.processId = processInstance.getProcessId();
        this.setDeploymentId(((ProcessInstanceImpl)processInstance).getDeploymentId());
        if (nodeInstance != null) {
            this.nodeInstanceId = nodeInstance.getStringId();
            this.nodeId = nodeInstance.getNodeId();
            if (((ProcessInstanceImpl)processInstance).getKnowledgeRuntime() != null) {
                this.nodeName = nodeInstance.getNodeName();
            }
        }
        this.variables = (variableScope = (VariableScopeInstance)((ProcessInstance)processInstance).getContextInstance("VariableScope")) != null ? variableScope.getVariables() : new HashMap<String, Object>(0);
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getNodeInstanceId() {
        return this.nodeInstanceId;
    }

    public void setNodeInstanceId(String nodeInstanceId) {
        this.nodeInstanceId = nodeInstanceId;
    }

    public WorkflowElementIdentifier getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(WorkflowElementIdentifier nodeId) {
        this.nodeId = nodeId;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @Override
    public String getMessage() {
        return MessageFormat.format("[{0}:{4} - {1}:{2}] -- {3}", this.getProcessId(), this.getNodeName() == null ? "?" : this.getNodeName(), this.getNodeId(), this.getCause() == null ? "WorkflowRuntimeException" : this.getCause().getMessage(), this.getProcessInstanceId());
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }
}

