/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.ContextableInstance;
import org.jbpm.process.instance.KogitoProcessContextImpl;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.instance.impl.ReturnValueEvaluator;
import org.jbpm.util.ContextFactory;
import org.jbpm.workflow.core.node.AsyncEventNodeInstance;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.WorkflowProcessParameters;
import org.jbpm.workflow.instance.impl.MVELProcessHelper;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;
import org.jbpm.workflow.instance.node.LambdaSubProcessNodeInstance;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.Node;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.SimpleValueResolver;

public class ForEachNodeInstance
extends CompositeContextNodeInstance {
    private static final long serialVersionUID = 510L;
    private static final Set<Class<? extends org.kie.api.runtime.process.NodeInstance>> NOT_SERIALIZABLE_CLASSES = Set.of(ForEachJoinNodeInstance.class);
    public static final String TEMP_OUTPUT_VAR = "foreach_output";
    private int totalInstances;
    private int executedInstances;
    boolean hasAsyncInstances;

    public ForEachNode getForEachNode() {
        return (ForEachNode)this.getNode();
    }

    public int getExecutedInstances() {
        return this.executedInstances;
    }

    public void setExecutedInstances(int executedInstances) {
        this.executedInstances = executedInstances;
    }

    public int getTotalInstances() {
        return this.totalInstances;
    }

    public void setTotalInstances(int totalInstances) {
        this.totalInstances = totalInstances;
    }

    public boolean getHasAsyncInstances() {
        return this.hasAsyncInstances;
    }

    public void setHasAsyncInstances(boolean hasAsyncInstances) {
        this.hasAsyncInstances = hasAsyncInstances;
    }

    @Override
    public NodeInstance getNodeInstance(Node currentNode) {
        Node node = this.resolveAsync(currentNode);
        if (node instanceof ForEachNode.ForEachSplitNode) {
            ForEachSplitNodeInstance nodeInstance = new ForEachSplitNodeInstance();
            nodeInstance.setNodeId(node.getId());
            nodeInstance.setNodeInstanceContainer(this);
            nodeInstance.setProcessInstance(this.getProcessInstance());
            int level = this.getLevelForNode(node.getUniqueId());
            nodeInstance.setLevel(level);
            return nodeInstance;
        }
        if (node instanceof ForEachNode.ForEachJoinNode || currentNode instanceof ForEachNode.ForEachJoinNode) {
            Optional<NodeInstance> existingNodeInstance = Optional.ofNullable(this.getFirstNodeInstance(node.getId()));
            if (existingNodeInstance.isPresent()) {
                return existingNodeInstance.get();
            }
            if (node instanceof ForEachNode.ForEachJoinNode) {
                ForEachJoinNodeInstance nodeInstance = new ForEachJoinNodeInstance();
                nodeInstance.setNodeId(node.getId());
                nodeInstance.setNodeInstanceContainer(this);
                nodeInstance.setProcessInstance(this.getProcessInstance());
                Object uniqueID = node.getUniqueId();
                if (uniqueID == null) {
                    uniqueID = "" + node.getId();
                }
                int level = this.getLevelForNode((String)uniqueID);
                nodeInstance.setLevel(level);
                return nodeInstance;
            }
        }
        return super.getNodeInstance(currentNode);
    }

    @Override
    public ContextContainer getContextContainer() {
        return this.getForEachNode().getCompositeNode();
    }

    private boolean isSequential() {
        return this.getForEachNode().isSequential() || this.hasAsyncInstances;
    }

    private boolean checkAsyncInstance(NodeInstance nodeInstance) {
        return ((CompositeContextNodeInstance)nodeInstance).getNodeInstances().stream().anyMatch(i -> i instanceof AsyncEventNodeInstance || i instanceof LambdaSubProcessNodeInstance && ((LambdaSubProcessNodeInstance)i).isAsyncWaitingNodeInstance());
    }

    @Override
    public ContextInstance getContextInstance(String contextId) {
        ContextInstance contextInstance = super.getContextInstance(contextId);
        if (contextInstance == null) {
            contextInstance = this.resolveContextInstance(contextId, TEMP_OUTPUT_VAR);
            this.setContextInstance(contextId, contextInstance);
        }
        return contextInstance;
    }

    @Override
    public int getLevelForNode(String uniqueID) {
        return 1;
    }

    public Collection<org.kie.api.runtime.process.NodeInstance> getSerializableNodeInstances() {
        return this.getNodeInstances().stream().filter(ForEachNodeInstance::isSerializable).collect(Collectors.toUnmodifiableList());
    }

    static boolean isSerializable(org.kie.api.runtime.process.NodeInstance toCheck) {
        return !NOT_SERIALIZABLE_CLASSES.contains(toCheck.getClass());
    }

    public class ForEachSplitNodeInstance
    extends NodeInstanceImpl
    implements ContextableInstance {
        private static final long serialVersionUID = 510L;

        public ForEachNode.ForEachSplitNode getForEachSplitNode() {
            return (ForEachNode.ForEachSplitNode)this.getNode();
        }

        @Override
        public void internalTrigger(KogitoNodeInstance from, String type) {
            this.triggerTime = new Date();
            Collection<?> collection = this.evaluateCollectionExpression();
            ForEachNodeInstance.this.setTotalInstances(collection.size());
            ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
            if (collection.isEmpty()) {
                ForEachNodeInstance.this.triggerCompleted("DROOLS_DEFAULT", true);
            } else {
                ArrayList<NodeInstance> nodeInstances = new ArrayList<NodeInstance>();
                for (Object o : collection) {
                    String variableName = ForEachNodeInstance.this.getForEachNode().getVariableName();
                    NodeInstance nodeInstance = ((NodeInstanceContainer)this.getNodeInstanceContainer()).getNodeInstance(this.getForEachSplitNode().getTo().getTo());
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)nodeInstance.resolveContextInstance("VariableScope", variableName);
                    variableScopeInstance.setVariable(nodeInstance, variableName, o);
                    nodeInstances.add(nodeInstance);
                }
                for (NodeInstance nodeInstance : nodeInstances) {
                    logger.debug("Triggering [{}] in multi-instance loop.", (Object)nodeInstance.getNodeId());
                    nodeInstance.trigger(this, this.getForEachSplitNode().getTo().getToType());
                    ForEachNodeInstance.this.hasAsyncInstances = ForEachNodeInstance.this.checkAsyncInstance(nodeInstance);
                    if (!ForEachNodeInstance.this.isSequential()) continue;
                    break;
                }
                if (!ForEachNodeInstance.this.getForEachNode().isWaitForCompletion()) {
                    ForEachNodeInstance.this.triggerCompleted("DROOLS_DEFAULT", false);
                }
            }
        }

        private Collection<?> evaluateCollectionExpression() {
            Object collection;
            String collectionExpression = ForEachNodeInstance.this.getForEachNode().getCollectionExpression();
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", collectionExpression);
            if (variableScopeInstance != null) {
                collection = variableScopeInstance.getVariable(collectionExpression);
            } else if (ForEachNodeInstance.this.getForEachNode().getEvaluateExpression() != null) {
                collection = ForEachNodeInstance.this.getForEachNode().getEvaluateExpression().eval(this.getVariable((String)ForEachNodeInstance.this.getForEachNode().getMetaData("Variable")), Collection.class, ContextFactory.fromNode(this));
            } else {
                try {
                    collection = MVELProcessHelper.evaluator().eval(collectionExpression, (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                }
                catch (Exception t) {
                    throw new IllegalArgumentException("Could not find collection " + collectionExpression);
                }
            }
            if (collection == null) {
                return Collections.emptyList();
            }
            if (collection instanceof Collection) {
                return (Collection)collection;
            }
            if (collection.getClass().isArray()) {
                ArrayList list = new ArrayList();
                Collections.addAll(list, (Object[])collection);
                return list;
            }
            throw new IllegalArgumentException("Unexpected collection type: " + collection.getClass());
        }

        @Override
        public ContextInstance getContextInstance(String contextId) {
            return ForEachNodeInstance.this.getContextInstance(contextId);
        }
    }

    public class ForEachJoinNodeInstance
    extends NodeInstanceImpl
    implements ContextableInstance {
        private static final long serialVersionUID = 510L;

        public ForEachNode.ForEachJoinNode getForEachJoinNode() {
            return (ForEachNode.ForEachJoinNode)this.getNode();
        }

        @Override
        public void internalTrigger(KogitoNodeInstance from, String type) {
            boolean isCompletionConditionMet;
            ArrayList<Object> outputCollection;
            this.triggerTime = new Date();
            ForEachNodeInstance.this.setExecutedInstances(ForEachNodeInstance.this.getExecutedInstances() + 1);
            HashMap<String, Object> tempVariables = new HashMap<String, Object>();
            if (ForEachNodeInstance.this.getForEachNode().getOutputVariableName() != null) {
                Object outputVariable = from.getVariable(ForEachNodeInstance.this.getForEachNode().getOutputVariableName());
                outputCollection = (ArrayList<Object>)this.getVariable(ForEachNodeInstance.TEMP_OUTPUT_VAR);
                if (outputCollection == null) {
                    outputCollection = new ArrayList<Object>();
                }
                outputCollection.add(outputVariable);
                this.setVariable(ForEachNodeInstance.TEMP_OUTPUT_VAR, outputCollection);
                tempVariables.put(ForEachNodeInstance.this.getForEachNode().getOutputVariableName(), outputVariable);
                String outputCollectionName = ForEachNodeInstance.this.getForEachNode().getOutputCollectionExpression();
                if (outputCollectionName != null) {
                    tempVariables.put(outputCollectionName, outputCollection);
                }
            }
            boolean bl = isCompletionConditionMet = ForEachNodeInstance.this.getForEachNode().hasCompletionCondition() && this.evaluateCompletionCondition(ForEachNodeInstance.this.getForEachNode().getCompletionConditionExpression(), tempVariables);
            if (ForEachNodeInstance.this.isSequential() && !isCompletionConditionMet && !this.areNodeInstancesCompleted()) {
                this.getFirstCompositeNodeInstance().ifPresent(nodeInstance -> {
                    logger.debug("Triggering [{}] in multi-instance loop.", (Object)nodeInstance.getNodeId());
                    nodeInstance.trigger(null, ForEachNodeInstance.this.getForEachNode().getForEachSplitNode().getTo().getToType());
                });
            }
            if (this.areNodeInstancesCompleted() || isCompletionConditionMet) {
                outputCollection = ForEachNodeInstance.this.getForEachNode().getOutputCollectionExpression();
                Action outputAction = ForEachNodeInstance.this.getForEachNode().getCompletionAction();
                if (outputCollection != null) {
                    Collection outputVariable = (Collection)this.getVariable((String)((Object)outputCollection));
                    Collection collectedValues = (Collection)this.getVariable(ForEachNodeInstance.TEMP_OUTPUT_VAR);
                    if (outputVariable != null) {
                        outputVariable.addAll(collectedValues);
                    } else {
                        outputVariable = collectedValues;
                    }
                    this.setVariable((String)((Object)outputCollection), outputVariable);
                } else if (outputAction != null) {
                    try {
                        outputAction.execute(ContextFactory.fromNode(this));
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
                ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
                if (ForEachNodeInstance.this.getForEachNode().isWaitForCompletion()) {
                    if (!WorkflowProcessParameters.WORKFLOW_PARAM_MULTIPLE_CONNECTIONS.get(this.getProcessInstance().getProcess()).booleanValue()) {
                        this.triggerConnection(this.getForEachJoinNode().getTo());
                    } else {
                        List<Connection> connections = this.getForEachJoinNode().getOutgoingConnections("DROOLS_DEFAULT");
                        for (Connection connection : connections) {
                            this.triggerConnection(connection);
                        }
                    }
                }
            }
        }

        private Optional<NodeInstance> getFirstCompositeNodeInstance() {
            return ((CompositeNodeInstance)this.getNodeInstanceContainer()).getNodeInstances(false).stream().filter(CompositeContextNodeInstance.class::isInstance).filter(NodeInstance.class::isInstance).map(NodeInstance.class::cast).findFirst();
        }

        private boolean areNodeInstancesCompleted() {
            return this.getNodeInstanceContainer().getNodeInstances().size() == 1;
        }

        private boolean evaluateCompletionCondition(ReturnValueEvaluator completeConditionEvaluator, Map<String, Object> tempVariables) {
            try {
                KogitoProcessContextImpl context = ContextFactory.fromNode(this);
                context.setContextData(tempVariables);
                return (Boolean)completeConditionEvaluator.evaluate(context);
            }
            catch (Exception t) {
                throw new IllegalArgumentException("Could not evaluate completion condition  " + completeConditionEvaluator, t);
            }
        }

        @Override
        public ContextInstance getContextInstance(String contextId) {
            return ForEachNodeInstance.this.getContextInstance(contextId);
        }
    }

    private class ForEachNodeInstanceResolverFactory
    extends NodeInstanceResolverFactory {
        private static final long serialVersionUID = -8856846610671009685L;
        private Map<String, Object> tempVariables;

        public ForEachNodeInstanceResolverFactory(NodeInstance nodeInstance, Map<String, Object> tempVariables) {
            super(nodeInstance);
            this.tempVariables = tempVariables;
        }

        @Override
        public boolean isResolveable(String name) {
            boolean result = this.tempVariables.containsKey(name);
            if (result) {
                return result;
            }
            return super.isResolveable(name);
        }

        @Override
        public VariableResolver getVariableResolver(String name) {
            if (this.tempVariables.containsKey(name)) {
                return new SimpleValueResolver(this.tempVariables.get(name));
            }
            return super.getVariableResolver(name);
        }
    }
}

