/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jbpm.process.core.ProcessSupplier;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.LightProcessRuntime;
import org.jbpm.process.instance.LightProcessRuntimeServiceProvider;
import org.jbpm.process.instance.ProcessRuntimeServiceProvider;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.impl.WorkflowProcessImpl;
import org.jbpm.workflow.core.node.StartNode;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.correlation.CorrelationService;
import org.kie.kogito.event.correlation.DefaultCorrelationService;
import org.kie.kogito.internal.process.runtime.KogitoNode;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemHandlerFactory;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemManager;
import org.kie.kogito.internal.process.workitem.Policy;
import org.kie.kogito.internal.process.workitem.WorkItemTransition;
import org.kie.kogito.internal.utils.ConversionUtils;
import org.kie.kogito.jobs.DurationExpirationTime;
import org.kie.kogito.jobs.ExactExpirationTime;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.JobDescription;
import org.kie.kogito.jobs.descriptors.ProcessJobDescription;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.ProcessVersionResolver;
import org.kie.kogito.process.Signal;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.impl.ConfiguredProcessServices;
import org.kie.kogito.process.impl.MapProcessInstances;
import org.kie.kogito.process.impl.Sig;

public abstract class AbstractProcess<T extends Model>
implements Process<T>,
ProcessSupplier {
    protected final ProcessRuntimeServiceProvider services;
    protected ProcessInstancesFactory processInstancesFactory;
    protected MutableProcessInstances<T> instances;
    protected CompletionEventListener completionEventListener = new CompletionEventListener();
    protected Application app;
    protected boolean activated;
    protected List<String> startTimerInstances = new ArrayList<String>();
    protected KogitoProcessRuntime processRuntime;
    private org.kie.api.definition.process.Process process;
    private Lock processInitLock = new ReentrantLock();
    private CorrelationService correlations;
    private ProcessVersionResolver versionResolver;

    protected AbstractProcess() {
        this(null, new LightProcessRuntimeServiceProvider());
    }

    protected AbstractProcess(ProcessConfig config, Application application) {
        this(application, new ConfiguredProcessServices(config));
    }

    protected AbstractProcess(Application application, ProcessRuntimeServiceProvider services) {
        this(application, services, Collections.emptyList(), null, null, null);
    }

    protected AbstractProcess(Application app, Collection<KogitoWorkItemHandler> handlers, CorrelationService correlations) {
        this(app, handlers, correlations, null);
    }

    protected AbstractProcess(Application app, Collection<KogitoWorkItemHandler> handlers, CorrelationService correlations, ProcessInstancesFactory factory) {
        this(app, new ConfiguredProcessServices((ProcessConfig)app.config().get(ProcessConfig.class)), handlers, correlations, factory, ((ProcessConfig)app.config().get(ProcessConfig.class)).versionResolver());
    }

    protected AbstractProcess(Application app, ProcessRuntimeServiceProvider services, Collection<KogitoWorkItemHandler> handlers, CorrelationService correlations, ProcessInstancesFactory factory, ProcessVersionResolver versionResolver) {
        this.app = app;
        this.services = services;
        this.instances = new MapProcessInstances();
        this.processInstancesFactory = factory;
        this.correlations = Optional.ofNullable(correlations).orElseGet(() -> new DefaultCorrelationService());
        this.versionResolver = Optional.ofNullable(versionResolver).orElse(p -> this.get().getVersion());
        KogitoWorkItemManager workItemManager = services.getKogitoWorkItemManager();
        Collection handlerIds = workItemManager.getHandlerIds();
        KogitoWorkItemHandlerFactory.findAllKogitoWorkItemHandlersRegistered().stream().filter(e -> !handlerIds.contains(e.getName())).forEach(workItemHandler -> {
            workItemHandler.setApplication(app);
            workItemManager.registerWorkItemHandler(workItemHandler.getName(), workItemHandler);
        });
        for (KogitoWorkItemHandler workItemHandler2 : handlers) {
            workItemHandler2.setApplication(app);
            workItemManager.registerWorkItemHandler(workItemHandler2.getName(), workItemHandler2);
        }
    }

    public String id() {
        return this.get().getId();
    }

    public String name() {
        return this.get().getName();
    }

    public WorkItemTransition newTransition(WorkItem workItem, String transitionId, Map<String, Object> map, Policy ... policy) {
        KogitoWorkItemHandler handler = this.getKogitoWorkItemHandler(workItem.getWorkItemHandlerName());
        return handler.newTransition(transitionId, workItem.getPhaseStatus(), map, policy);
    }

    public KogitoWorkItemHandler getKogitoWorkItemHandler(String workItemHandlerName) {
        return this.services.getKogitoWorkItemManager().getKogitoWorkItemHandler(workItemHandlerName);
    }

    public String version() {
        return (String)this.versionResolver.apply((Object)this);
    }

    public String type() {
        return this.get().getType();
    }

    public T createModel() {
        return null;
    }

    public ProcessInstance<T> createInstance(String businessKey, Model m) {
        return this.createInstance(businessKey, m);
    }

    public abstract ProcessInstance<T> createInstance(WorkflowProcessInstance var1);

    public abstract ProcessInstance<T> createReadOnlyInstance(WorkflowProcessInstance var1);

    public Collection<KogitoNode> findNodes(Predicate<KogitoNode> filter) {
        RuleFlowProcess p = (RuleFlowProcess)this.process;
        return p.getNodesRecursively().stream().map(n -> (KogitoNode)n).filter(filter).collect(Collectors.toList());
    }

    public ProcessInstances<T> instances() {
        return this.instances;
    }

    public CorrelationService correlations() {
        return this.correlations;
    }

    public <S> void send(Signal<S> signal) {
        this.getProcessRuntime().signalEvent(signal.channel(), signal.payload());
    }

    public Process<T> configure() {
        this.registerListeners();
        if (this.isProcessFactorySet()) {
            this.instances = this.processInstancesFactory.createProcessInstances((Process)this);
        }
        return this;
    }

    protected void registerListeners() {
    }

    public KogitoProcessRuntime getProcessRuntime() {
        return this.processRuntime;
    }

    public void activate() {
        if (this.activated) {
            return;
        }
        this.processRuntime = this.createProcessRuntime().getKogitoProcessRuntime();
        WorkflowProcessImpl p = (WorkflowProcessImpl)this.get();
        this.configure();
        List<StartNode> startNodes = p.getTimerStart();
        if (startNodes != null && !startNodes.isEmpty()) {
            for (StartNode startNode : startNodes) {
                if (startNode == null || startNode.getTimer() == null) continue;
                String timerId = this.processRuntime.getJobsService().scheduleJob((JobDescription)ProcessJobDescription.of((ExpirationTime)this.configureTimerInstance(startNode.getTimer()), (Process)this));
                this.startTimerInstances.add(timerId);
            }
        }
        this.activated = true;
    }

    public void deactivate() {
        for (String startTimerId : this.startTimerInstances) {
            this.processRuntime.getJobsService().cancelJob(startTimerId);
        }
        this.activated = false;
    }

    protected ExpirationTime configureTimerInstance(Timer timer) {
        switch (timer.getTimeType()) {
            case 2: {
                long[] repeatValues = DateTimeUtils.parseRepeatableDateTime(timer.getDelay());
                if (repeatValues.length == 3) {
                    int parsedReapedCount = (int)repeatValues[0];
                    if (parsedReapedCount <= -1) {
                        parsedReapedCount = Integer.MAX_VALUE;
                    }
                    return DurationExpirationTime.repeat((long)repeatValues[1], (Long)repeatValues[2], (Integer)parsedReapedCount);
                }
                if (repeatValues.length == 2) {
                    return DurationExpirationTime.repeat((long)repeatValues[0], (Long)repeatValues[1], (Integer)Integer.MAX_VALUE);
                }
                return DurationExpirationTime.repeat((long)repeatValues[0], (Long)repeatValues[0], (Integer)Integer.MAX_VALUE);
            }
            case 1: {
                long duration = DateTimeUtils.parseDuration(timer.getDelay());
                return DurationExpirationTime.repeat((long)duration);
            }
            case 3: {
                return ExactExpirationTime.of((String)timer.getDate());
            }
        }
        throw new UnsupportedOperationException("Not supported timer definition");
    }

    @Override
    public org.kie.api.definition.process.Process get() {
        this.processInitLock.lock();
        try {
            if (this.process == null) {
                this.process = this.process();
            }
        }
        finally {
            this.processInitLock.unlock();
        }
        return this.process;
    }

    protected abstract org.kie.api.definition.process.Process process();

    protected InternalProcessRuntime createProcessRuntime() {
        return LightProcessRuntime.of(this.app, Collections.singletonList(this.get()), this.services);
    }

    protected boolean isProcessFactorySet() {
        return this.processInstancesFactory != null;
    }

    public void setProcessInstancesFactory(ProcessInstancesFactory processInstancesFactory) {
        this.processInstancesFactory = processInstancesFactory;
    }

    public EventListener eventListener() {
        return this.completionEventListener;
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractProcess other = (AbstractProcess)obj;
        return Objects.equals(this.id(), other.id());
    }

    protected class CompletionEventListener
    implements EventListener {
        public void signalEvent(String type, Object event) {
            if (type.startsWith("processInstanceCompleted:")) {
                KogitoProcessInstance pi = (KogitoProcessInstance)event;
                String parentProcessInstanceId = pi.getParentProcessInstanceId();
                if (!AbstractProcess.this.id().equals(pi.getProcessId()) && ConversionUtils.isNotEmpty((String)parentProcessInstanceId)) {
                    KogitoProcessInstance parentKogitoProcessInstance = AbstractProcess.this.services.getProcessInstanceManager().getProcessInstance(parentProcessInstanceId);
                    if (parentKogitoProcessInstance != null) {
                        parentKogitoProcessInstance.signalEvent(type, event);
                    } else {
                        AbstractProcess.this.instances().findById(pi.getParentProcessInstanceId()).ifPresent(p -> p.send(Sig.of(type, event)));
                    }
                }
            }
        }

        public String[] getEventTypes() {
            return new String[0];
        }
    }
}

