/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jbpm.util.JsonSchemaUtil;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.kogito.Application;
import org.kie.kogito.MapOutput;
import org.kie.kogito.MappableToModel;
import org.kie.kogito.Model;
import org.kie.kogito.config.ConfigBean;
import org.kie.kogito.correlation.CompositeCorrelation;
import org.kie.kogito.internal.process.runtime.KogitoNode;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.workitem.Policy;
import org.kie.kogito.internal.process.workitem.WorkItemNotFoundException;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceNotFoundException;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.ProcessService;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.impl.Sig;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;

public class ProcessServiceImpl
implements ProcessService {
    private final Application application;
    private final short processInstanceLimit;

    public ProcessServiceImpl(Application application) {
        this.application = application;
        this.processInstanceLimit = ((ConfigBean)application.config().get(ConfigBean.class)).processInstanceLimit();
    }

    public <T extends Model> ProcessInstance<T> createProcessInstance(Process<T> process, String businessKey, T model, Map<String, List<String>> headers, String startFromNodeId) {
        return (ProcessInstance)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = process.createInstance(businessKey, (Object)model);
            if (startFromNodeId != null) {
                pi.startFrom(startFromNodeId, headers);
            } else {
                pi.start(headers);
            }
            return pi;
        });
    }

    public <T extends Model> ProcessInstance<T> createProcessInstance(Process<T> process, String businessKey, T model, Map<String, List<String>> headers, String startFromNodeId, String trigger, String kogitoReferenceId, CompositeCorrelation correlation) {
        return (ProcessInstance)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = process.createInstance(businessKey, correlation, (Object)model);
            if (startFromNodeId != null) {
                pi.startFrom(startFromNodeId, kogitoReferenceId, headers);
            } else {
                pi.start(trigger, kogitoReferenceId, headers);
            }
            return pi;
        });
    }

    public <T extends MappableToModel<R>, R> List<R> getProcessInstanceOutput(Process<T> process) {
        try (Stream<ProcessInstance> stream = process.instances().stream().limit(this.processInstanceLimit);){
            List list = stream.map(ProcessInstance::variables).map(MappableToModel::toModel).collect(Collectors.toList());
            return list;
        }
    }

    public <T extends MappableToModel<R>, R> Optional<R> findById(Process<T> process, String id) {
        Optional instance = process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY);
        Optional<MappableToModel> mappable = instance.map(ProcessInstance::variables);
        return mappable.map(MappableToModel::toModel);
    }

    public <T> void migrateProcessInstances(Process<T> process, String targetProcessId, String targetProcessVersion, String ... processIds) throws UnsupportedOperationException {
        process.instances().migrateProcessInstances(targetProcessId, targetProcessVersion, processIds);
    }

    public <T> long migrateAll(Process<T> process, String targetProcessId, String targetProcessVersion) throws UnsupportedOperationException {
        return process.instances().migrateAll(targetProcessId, targetProcessVersion);
    }

    public <T extends MappableToModel<R>, R> Optional<R> delete(Process<T> process, String id) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.abort();
            return pi;
        }).map(ProcessInstance::checkError).map(ProcessInstance::variables).map(MappableToModel::toModel));
    }

    public <T extends MappableToModel<R>, R> Optional<R> update(Process<T> process, String id, T resource) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> (MappableToModel)pi.updateVariables((Object)resource)).map(MappableToModel::toModel));
    }

    public <T extends MappableToModel<R>, R> Optional<R> updatePartial(Process<T> process, String id, T resource) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> (MappableToModel)pi.updateVariablesPartially((Object)resource)).map(MappableToModel::toModel));
    }

    public <T extends MappableToModel<R>, R> Optional<R> signalProcessInstance(Process<T> process, String id, Object data, String signalName) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.send(Sig.of(signalName, data));
            return ((MappableToModel)pi.checkError().variables()).toModel();
        }));
    }

    public <T extends Model> Optional<List<WorkItem>> getWorkItems(Process<T> process, String id, Policy ... policy) {
        return process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> pi.workItems(WorkItemNodeInstance.class::isInstance, policy));
    }

    public <T extends Model> Optional<WorkItem> signalWorkItem(Process<T> process, String id, String taskNodeName, Policy ... policy) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            Optional piFound = process.instances().findById(id);
            if (piFound.isEmpty()) {
                return Optional.empty();
            }
            ProcessInstance pi = (ProcessInstance)piFound.get();
            return this.findWorkItem(pi, taskNodeName, policy);
        });
    }

    private <T extends Model> Optional<WorkItem> findWorkItem(ProcessInstance<T> pi, String taskName, Policy ... policy) {
        KogitoNode node = (KogitoNode)pi.process().findNodes(this.worktItemNodeNamed(taskName)).iterator().next();
        String taskNodeName = node.getName();
        pi.send(Sig.of(taskNodeName, Collections.emptyMap()));
        return this.getWorkItemByTaskName(pi, taskName, policy);
    }

    private Predicate<KogitoNode> worktItemNodeNamed(String taskName) {
        return node -> {
            WorkItemNode workItemNode;
            return node instanceof WorkItemNode && taskName.equals((workItemNode = (WorkItemNode)node).getWork().getParameter("TaskName"));
        };
    }

    private <T extends Model> Optional<WorkItem> getWorkItemByTaskName(ProcessInstance<T> pi, String taskName, Policy ... policies) {
        return pi.workItems(policies).stream().filter(wi -> wi.getName().equals(taskName)).findFirst();
    }

    public <T extends MappableToModel<R>, R> Optional<R> transitionWorkItem(Process<T> process, String processInstanceId, String workItemId, String phaseId, Policy policy, MapOutput model) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> process.instances().findById(processInstanceId).map(pi -> {
            WorkItem workItem = pi.workItem(workItemId, new Policy[]{policy});
            pi.transitionWorkItem(workItemId, process.newTransition(workItem, phaseId, model.toMap(), new Policy[]{policy}));
            return ((MappableToModel)pi.variables()).toModel();
        }));
    }

    public <T extends MappableToModel<?>, R> Optional<R> getWorkItem(Process<T> process, String id, String taskId, Policy policy, Function<WorkItem, R> mapper) {
        return process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> pi.workItem(taskId, new Policy[]{policy})).map(mapper);
    }

    public <T extends Model, R extends MapOutput> Optional<R> setWorkItemOutput(Process<T> process, String id, String taskId, Policy policy, MapOutput model, Function<Map<String, Object>, R> mapper) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> (Map)pi.updateWorkItem(taskId, wi -> {
            wi.setOutputs(model.toMap());
            return model.toMap();
        }, new Policy[]{policy})).map(mapper));
    }

    public <T extends Model> Map<String, Object> getWorkItemSchemaAndPhases(Process<T> process, String processInstanceId, String workItemId, String workItemTaskName, Policy policy) {
        ProcessInstance pi = (ProcessInstance)process.instances().findById(processInstanceId).orElseThrow(() -> new ProcessInstanceNotFoundException(processInstanceId));
        WorkItem workItem = pi.workItems(new Policy[]{policy}).stream().filter(wi -> wi.getId().equals(workItemId)).findFirst().orElseThrow(() -> new WorkItemNotFoundException(workItemId));
        KogitoWorkItemHandler handler = process.getKogitoWorkItemHandler(workItem.getWorkItemHandlerName());
        return JsonSchemaUtil.addPhases(process, handler, processInstanceId, workItemId, new Policy[]{policy}, JsonSchemaUtil.load(Thread.currentThread().getContextClassLoader(), process.id(), workItemTaskName));
    }
}

