/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.usertask.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.kie.kogito.usertask.UserTask;
import org.kie.kogito.usertask.UserTaskInstance;
import org.kie.kogito.usertask.impl.DefaultUserTaskInstance;
import org.kie.kogito.usertask.impl.model.DeadlineHelper;
import org.kie.kogito.usertask.model.DeadlineInfo;
import org.kie.kogito.usertask.model.Notification;
import org.kie.kogito.usertask.model.Reassignment;

public abstract class AbstractUserTask
implements UserTask {
    private String separator = System.getProperty("org.jbpm.ht.user.separator", ",");
    private String id;
    private String name;
    private String taskName;
    private String taskDescription;
    private String referenceName;
    private String taskPriority;
    private Boolean skippable;
    private Set<String> potentialUsers;
    private Set<String> potentialGroups;
    private Set<String> adminUsers;
    private Set<String> adminGroups;
    private Set<String> excludedUsers;
    private Collection<DeadlineInfo<Notification>> startDeadlines;
    private Collection<DeadlineInfo<Notification>> endDeadlines;
    private Collection<DeadlineInfo<Reassignment>> startReassignments;
    private Collection<DeadlineInfo<Reassignment>> endReassignments;

    public AbstractUserTask(String id, String name) {
        this.id = id;
        this.name = name;
        this.skippable = Boolean.FALSE;
        this.potentialUsers = new HashSet<String>();
        this.potentialGroups = new HashSet<String>();
        this.adminUsers = new HashSet<String>();
        this.adminGroups = new HashSet<String>();
        this.excludedUsers = new HashSet<String>();
        this.startDeadlines = new HashSet<DeadlineInfo<Notification>>();
        this.endDeadlines = new HashSet<DeadlineInfo<Notification>>();
        this.startReassignments = new HashSet<DeadlineInfo<Reassignment>>();
        this.endReassignments = new HashSet<DeadlineInfo<Reassignment>>();
    }

    public UserTaskInstance createInstance() {
        DefaultUserTaskInstance instance = new DefaultUserTaskInstance(this);
        instance.setUserTaskId(this.id());
        instance.setTaskName(this.getTaskName());
        instance.setTaskDescription(this.getTaskDescription());
        instance.setTaskPriority(this.getTaskPriority());
        instance.setPotentialUsers(this.getPotentialUsers());
        instance.setPotentialGroups(this.getPotentialGroups());
        instance.setAdminUsers(this.getAdminUsers());
        instance.setAdminGroups(this.getAdminGroups());
        instance.setExcludedUsers(this.getExcludedUsers());
        instance.setInstances(this.instances());
        instance.setNotCompletedDeadlines(this.getNotCompletedDeadlines());
        instance.setNotCompletedReassignments(this.getNotCompletedReassignments());
        instance.setNotStartedDeadlines(this.getNotStartedDeadlines());
        instance.setNotStartedReassignments(this.getNotStartedReassignments());
        return instance;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public void setSkippable(String skippable) {
        this.skippable = Boolean.parseBoolean(skippable);
    }

    public Boolean getSkippable() {
        return this.skippable;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public void setTaskDescription(String taskDescription) {
        this.taskDescription = taskDescription;
    }

    public String getTaskPriority() {
        return this.taskPriority;
    }

    public void setTaskPriority(String taskPriority) {
        this.taskPriority = taskPriority;
    }

    public void setReferenceName(String referenceName) {
        this.referenceName = referenceName;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public Set<String> getPotentialUsers() {
        return this.potentialUsers;
    }

    public void setPotentialUsers(String potentialUsers) {
        this.setPotentialUsers(this.toSet(potentialUsers));
    }

    public void setPotentialUsers(Set<String> potentialUsers) {
        this.potentialUsers = potentialUsers;
    }

    public Set<String> getPotentialGroups() {
        return this.potentialGroups;
    }

    public void setPotentialGroups(String potentialGroups) {
        this.setPotentialGroups(this.toSet(potentialGroups));
    }

    public void setPotentialGroups(Set<String> potentialGroups) {
        this.potentialGroups = potentialGroups;
    }

    public Set<String> getAdminUsers() {
        return this.adminUsers;
    }

    public void setAdminUsers(String adminUsers) {
        this.setAdminUsers(this.toSet(adminUsers));
    }

    public void setAdminUsers(Set<String> adminUsers) {
        this.adminUsers = adminUsers;
    }

    public Set<String> getAdminGroups() {
        return this.adminGroups;
    }

    public void setAdminGroups(String adminGroups) {
        this.setAdminGroups(this.toSet(adminGroups));
    }

    public void setAdminGroups(Set<String> adminGroups) {
        this.adminGroups = adminGroups;
    }

    public Set<String> getExcludedUsers() {
        return this.excludedUsers;
    }

    public void setExcludedUsers(String excludedUsers) {
        this.setExcludedUsers(this.toSet(excludedUsers));
    }

    public void setExcludedUsers(Set<String> excludedUsers) {
        this.excludedUsers = excludedUsers;
    }

    public Collection<DeadlineInfo<Notification>> getNotStartedDeadlines() {
        return this.startDeadlines;
    }

    public void setNotStartedDeadLines(String deadlines) {
        this.startDeadlines = DeadlineHelper.parseDeadlines(deadlines);
    }

    public Collection<DeadlineInfo<Notification>> getNotCompletedDeadlines() {
        return this.endDeadlines;
    }

    public void setNotCompletedDeadlines(String notStarted) {
        this.endDeadlines = DeadlineHelper.parseDeadlines(notStarted);
    }

    public Collection<DeadlineInfo<Reassignment>> getNotStartedReassignments() {
        return this.startReassignments;
    }

    public void setNotStartedReassignments(String reassignments) {
        this.startReassignments = DeadlineHelper.parseReassignments(reassignments);
    }

    public Collection<DeadlineInfo<Reassignment>> getNotCompletedReassignments() {
        return this.endReassignments;
    }

    public void setNotCompletedReassignments(String reassignments) {
        this.endReassignments = DeadlineHelper.parseReassignments(reassignments);
    }

    protected Set<String> toSet(String value) {
        if (value == null) {
            return new HashSet<String>();
        }
        HashSet<String> store = new HashSet<String>();
        for (String item : value.split(this.separator)) {
            store.add(item);
        }
        return store;
    }
}

