/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.usertask.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.kogito.Application;
import org.kie.kogito.uow.events.UnitOfWorkUserTaskEventListener;
import org.kie.kogito.usertask.UserTask;
import org.kie.kogito.usertask.UserTaskConfig;
import org.kie.kogito.usertask.UserTaskEventListener;
import org.kie.kogito.usertask.UserTaskInstance;
import org.kie.kogito.usertask.UserTaskInstances;
import org.kie.kogito.usertask.UserTasks;
import org.kie.kogito.usertask.impl.DefaultUserTaskInstance;
import org.kie.kogito.usertask.impl.KogitoUserTaskEventSupportImpl;

public class DefaultUserTasks
implements UserTasks {
    private Map<String, UserTask> userTasks;
    private Application application;
    private UserTaskInstances userTaskInstances;

    public DefaultUserTasks() {
        this.userTasks = new HashMap<String, UserTask>();
    }

    public DefaultUserTasks(Application application, UserTask ... userTasks) {
        this(application, List.of(userTasks));
    }

    public DefaultUserTasks(Application application, Iterable<UserTask> userTasks) {
        this.application = application;
        this.userTasks = new HashMap<String, UserTask>();
        for (UserTask userTask : userTasks) {
            this.userTasks.put(userTask.id(), userTask);
        }
        this.userTaskInstances = ((UserTaskConfig)application.config().get(UserTaskConfig.class)).userTaskInstances();
        this.userTaskInstances.setDisconnectUserTaskInstance(this::disconnect);
        this.userTaskInstances.setReconnectUserTaskInstance(this::connect);
    }

    public UserTask userTaskById(String userTaskId) {
        return this.userTasks.get(userTaskId);
    }

    public Collection<String> userTaskIds() {
        return this.userTasks.keySet();
    }

    public UserTaskInstances instances() {
        return this.userTaskInstances;
    }

    public UserTaskInstance disconnect(UserTaskInstance userTaskInstance) {
        DefaultUserTaskInstance instance = (DefaultUserTaskInstance)userTaskInstance;
        instance.setUserTask(null);
        instance.setUserTaskEventSupport(null);
        instance.setUserTaskLifeCycle(null);
        instance.setInstances(null);
        instance.setJobsService(null);
        return instance;
    }

    public UserTaskInstance connect(UserTaskInstance userTaskInstance) {
        DefaultUserTaskInstance instance = (DefaultUserTaskInstance)userTaskInstance;
        UserTaskConfig userTaskConfig = (UserTaskConfig)this.application.config().get(UserTaskConfig.class);
        KogitoUserTaskEventSupportImpl impl = new KogitoUserTaskEventSupportImpl(userTaskConfig.identityProvider());
        userTaskConfig.userTaskEventListeners().listeners().forEach(impl::addEventListener);
        impl.addEventListener((UserTaskEventListener)new UnitOfWorkUserTaskEventListener(this.application.unitOfWorkManager()));
        instance.setUserTask(((UserTasks)this.application.get(UserTasks.class)).userTaskById(instance.getUserTaskId()));
        instance.setUserTaskEventSupport(impl);
        instance.setUserTaskLifeCycle(userTaskConfig.userTaskLifeCycle());
        instance.setInstances(this.userTaskInstances);
        instance.setJobsService(userTaskConfig.jobsService());
        return instance;
    }
}

