/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.usertask.impl;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.kie.kogito.Application;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kie.kogito.usertask.UserTaskConfig;
import org.kie.kogito.usertask.UserTaskInstance;
import org.kie.kogito.usertask.UserTaskService;
import org.kie.kogito.usertask.UserTasks;
import org.kie.kogito.usertask.lifecycle.UserTaskLifeCycle;
import org.kie.kogito.usertask.lifecycle.UserTaskTransition;
import org.kie.kogito.usertask.model.Attachment;
import org.kie.kogito.usertask.model.Comment;
import org.kie.kogito.usertask.view.UserTaskTransitionView;
import org.kie.kogito.usertask.view.UserTaskView;

public class UserTaskServiceImpl
implements UserTaskService {
    private Application application;

    public UserTaskServiceImpl(Application application) {
        this.application = application;
    }

    public Optional<UserTaskView> getUserTaskInstance(String taskId, IdentityProvider identity) {
        return ((UserTasks)this.application.get(UserTasks.class)).instances().findById(taskId).map(this::toUserTaskView);
    }

    public List<UserTaskView> list(IdentityProvider identity) {
        return ((UserTasks)this.application.get(UserTasks.class)).instances().findByIdentity(identity).stream().map(this::toUserTaskView).toList();
    }

    private UserTaskView toUserTaskView(UserTaskInstance instance) {
        UserTaskView view = new UserTaskView();
        view.setId(instance.getId());
        view.setUserTaskId(instance.getUserTaskId());
        view.setStatus(instance.getStatus());
        view.setTaskName(instance.getTaskName());
        view.setTaskDescription(instance.getTaskDescription());
        view.setTaskPriority(instance.getTaskPriority());
        view.setPotentialUsers(instance.getPotentialUsers());
        view.setPotentialGroups(instance.getPotentialGroups());
        view.setExcludedUsers(instance.getExcludedUsers());
        view.setAdminUsers(instance.getAdminUsers());
        view.setAdminGroups(instance.getAdminGroups());
        view.setActualOwner(instance.getActualOwner());
        view.setInputs(instance.getInputs());
        view.setOutputs(instance.getOutputs());
        view.setMetadata(instance.getMetadata());
        view.setExternalReferenceId(instance.getExternalReferenceId());
        return view;
    }

    public Optional<UserTaskView> transition(String taskId, String transitionId, Map<String, Object> data, IdentityProvider identity) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            Optional userTaskInstance = ((UserTasks)this.application.get(UserTasks.class)).instances().findById(taskId);
            if (userTaskInstance.isEmpty()) {
                return Optional.empty();
            }
            UserTaskInstance ut = (UserTaskInstance)userTaskInstance.get();
            ut.transition(transitionId, data, identity);
            return Optional.of(this.toUserTaskView(ut));
        });
    }

    public List<UserTaskTransitionView> allowedTransitions(String taskId, IdentityProvider identity) {
        Optional userTaskInstance = ((UserTasks)this.application.get(UserTasks.class)).instances().findById(taskId);
        if (userTaskInstance.isEmpty()) {
            return Collections.emptyList();
        }
        UserTaskInstance ut = (UserTaskInstance)userTaskInstance.get();
        UserTaskLifeCycle userTaskLifeCycle = ((UserTaskConfig)this.application.config().get(UserTaskConfig.class)).userTaskLifeCycle();
        List transitions = userTaskLifeCycle.allowedTransitions(ut, identity);
        return this.toUserTaskTransitionView(transitions);
    }

    private List<UserTaskTransitionView> toUserTaskTransitionView(List<UserTaskTransition> transitions) {
        ArrayList<UserTaskTransitionView> views = new ArrayList<UserTaskTransitionView>();
        for (UserTaskTransition transition : transitions) {
            UserTaskTransitionView view = new UserTaskTransitionView();
            view.setTransitionId(transition.id());
            view.setSource(transition.source());
            view.setTarget(transition.target());
            views.add(view);
        }
        return views;
    }

    public Optional<UserTaskView> setOutputs(String taskId, Map<String, Object> data, IdentityProvider identity) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            Optional userTaskInstance = ((UserTasks)this.application.get(UserTasks.class)).instances().findById(taskId);
            if (userTaskInstance.isEmpty()) {
                return Optional.empty();
            }
            UserTaskInstance ut = (UserTaskInstance)userTaskInstance.get();
            data.forEach((arg_0, arg_1) -> ((UserTaskInstance)ut).setOutput(arg_0, arg_1));
            return Optional.of(this.toUserTaskView(ut));
        });
    }

    public Optional<UserTaskView> setInputs(String taskId, Map<String, Object> data, IdentityProvider identity) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            Optional userTaskInstance = ((UserTasks)this.application.get(UserTasks.class)).instances().findById(taskId);
            if (userTaskInstance.isEmpty()) {
                return Optional.empty();
            }
            UserTaskInstance ut = (UserTaskInstance)userTaskInstance.get();
            data.forEach((arg_0, arg_1) -> ((UserTaskInstance)ut).setInput(arg_0, arg_1));
            return Optional.of(this.toUserTaskView(ut));
        });
    }

    public List<Comment> getComments(String taskId, IdentityProvider identity) {
        Optional userTaskInstance = ((UserTasks)this.application.get(UserTasks.class)).instances().findById(taskId);
        if (userTaskInstance.isEmpty()) {
            return Collections.emptyList();
        }
        UserTaskInstance ut = (UserTaskInstance)userTaskInstance.get();
        return new ArrayList<Comment>(ut.getComments());
    }

    public Optional<Comment> getComment(String taskId, String commentId, IdentityProvider identity) {
        Optional userTaskInstance = ((UserTasks)this.application.get(UserTasks.class)).instances().findById(taskId);
        if (userTaskInstance.isEmpty()) {
            return Optional.empty();
        }
        UserTaskInstance ut = (UserTaskInstance)userTaskInstance.get();
        return Optional.ofNullable(ut.findCommentById(commentId));
    }

    public Optional<Comment> addComment(String taskId, Comment comment, IdentityProvider identity) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            Optional userTaskInstance = ((UserTasks)this.application.get(UserTasks.class)).instances().findById(taskId);
            if (userTaskInstance.isEmpty()) {
                return Optional.empty();
            }
            UserTaskInstance ut = (UserTaskInstance)userTaskInstance.get();
            Comment wrap = new Comment(null, identity.getName());
            wrap.setContent((Serializable)((Object)((String)((Object)comment.getContent()))));
            return Optional.ofNullable(ut.addComment(wrap));
        });
    }

    public Optional<Comment> updateComment(String taskId, Comment comment, IdentityProvider identity) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            Optional userTaskInstance = ((UserTasks)this.application.get(UserTasks.class)).instances().findById(taskId);
            if (userTaskInstance.isEmpty()) {
                return Optional.empty();
            }
            UserTaskInstance ut = (UserTaskInstance)userTaskInstance.get();
            Comment wrap = new Comment((String)((Object)comment.getId()), identity.getName());
            wrap.setContent((Serializable)((Object)((String)((Object)comment.getContent()))));
            return Optional.ofNullable(ut.updateComment(wrap));
        });
    }

    public Optional<Comment> removeComment(String taskId, String commentId, IdentityProvider identity) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            Optional userTaskInstance = ((UserTasks)this.application.get(UserTasks.class)).instances().findById(taskId);
            if (userTaskInstance.isEmpty()) {
                return Optional.empty();
            }
            UserTaskInstance ut = (UserTaskInstance)userTaskInstance.get();
            return Optional.ofNullable(ut.removeComment(new Comment(commentId, identity.getName())));
        });
    }

    public List<Attachment> getAttachments(String taskId, IdentityProvider identity) {
        Optional userTaskInstance = ((UserTasks)this.application.get(UserTasks.class)).instances().findById(taskId);
        if (userTaskInstance.isEmpty()) {
            return Collections.emptyList();
        }
        UserTaskInstance ut = (UserTaskInstance)userTaskInstance.get();
        return new ArrayList<Attachment>(ut.getAttachments());
    }

    public Optional<Attachment> getAttachment(String taskId, String attachmentId, IdentityProvider identity) {
        Optional userTaskInstance = ((UserTasks)this.application.get(UserTasks.class)).instances().findById(taskId);
        if (userTaskInstance.isEmpty()) {
            return Optional.empty();
        }
        UserTaskInstance ut = (UserTaskInstance)userTaskInstance.get();
        return Optional.ofNullable(ut.findAttachmentById(attachmentId));
    }

    public Optional<Attachment> addAttachment(String taskId, Attachment attachment, IdentityProvider identity) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            Optional userTaskInstance = ((UserTasks)this.application.get(UserTasks.class)).instances().findById(taskId);
            if (userTaskInstance.isEmpty()) {
                return Optional.empty();
            }
            UserTaskInstance ut = (UserTaskInstance)userTaskInstance.get();
            Attachment wrap = new Attachment(null, identity.getName());
            wrap.setContent((Serializable)((URI)attachment.getContent()));
            wrap.setName(attachment.getName());
            return Optional.ofNullable(ut.addAttachment(wrap));
        });
    }

    public Optional<Attachment> updateAttachment(String taskId, Attachment attachment, IdentityProvider identity) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            Optional userTaskInstance = ((UserTasks)this.application.get(UserTasks.class)).instances().findById(taskId);
            if (userTaskInstance.isEmpty()) {
                return Optional.empty();
            }
            UserTaskInstance ut = (UserTaskInstance)userTaskInstance.get();
            Attachment wrap = new Attachment((String)((Object)attachment.getId()), identity.getName());
            wrap.setContent((Serializable)((URI)attachment.getContent()));
            wrap.setName(attachment.getName());
            return Optional.ofNullable(ut.updateAttachment(attachment));
        });
    }

    public Optional<Attachment> removeAttachment(String taskId, String attachmentId, IdentityProvider identity) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            Optional userTaskInstance = ((UserTasks)this.application.get(UserTasks.class)).instances().findById(taskId);
            if (userTaskInstance.isEmpty()) {
                return Optional.empty();
            }
            UserTaskInstance ut = (UserTaskInstance)userTaskInstance.get();
            return Optional.ofNullable(ut.removeAttachment(new Attachment(attachmentId, identity.getName())));
        });
    }
}

