/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jitexecutor.bpmn;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Objects;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.drools.io.FileSystemResource;
import org.drools.util.IoUtils;
import org.drools.util.StringUtils;
import org.jbpm.process.core.impl.ProcessImpl;
import org.jbpm.process.core.validation.ProcessValidationError;
import org.jbpm.process.core.validation.impl.ProcessValidationErrorImpl;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Process;
import org.kie.api.io.Resource;
import org.kie.kogito.jitexecutor.bpmn.JITBPMNService;
import org.kie.kogito.jitexecutor.bpmn.JITBPMNServiceImpl;
import org.kie.kogito.jitexecutor.bpmn.responses.JITBPMNValidationResult;

class JITBPMNServiceImplTest {
    private static final JITBPMNService jitBpmnService = new JITBPMNServiceImpl();

    JITBPMNServiceImplTest() {
    }

    @Test
    void validateModel_SingleValidBPMN2() throws IOException {
        String toValidate = new String(IoUtils.readBytesFromInputStream((InputStream)Objects.requireNonNull(JITBPMNService.class.getResourceAsStream("/SingleProcess.bpmn2"))));
        JITBPMNValidationResult retrieved = jitBpmnService.validateModel(toValidate);
        Assertions.assertThat((Object)retrieved).isNotNull();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)retrieved.getErrors()).isNotNull()).isEmpty();
    }

    @Test
    void validateModel_MultipleValidBPMN2() throws IOException {
        String toValidate = new String(IoUtils.readBytesFromInputStream((InputStream)Objects.requireNonNull(JITBPMNService.class.getResourceAsStream("/MultipleProcess.bpmn2"))));
        JITBPMNValidationResult retrieved = jitBpmnService.validateModel(toValidate);
        Assertions.assertThat((Object)retrieved).isNotNull();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)retrieved.getErrors()).isNotNull()).isEmpty();
    }

    @Test
    void validateModel_SingleInvalidBPMN2() throws IOException {
        String toValidate = new String(IoUtils.readBytesFromInputStream((InputStream)Objects.requireNonNull(JITBPMNService.class.getResourceAsStream("/SingleInvalidModel.bpmn2"))));
        JITBPMNValidationResult retrieved = jitBpmnService.validateModel(toValidate);
        Assertions.assertThat((Object)retrieved).isNotNull();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)retrieved.getErrors()).isNotNull()).hasSize(2);
        Assertions.assertThat((Collection)retrieved.getErrors()).contains((Object[])new String[]{"Uri: (unknown) - Process id: invalid - name : invalid-process-id - error : Process has no start node."});
        Assertions.assertThat((Collection)retrieved.getErrors()).contains((Object[])new String[]{"Uri: (unknown) - Process id: invalid - name : invalid-process-id - error : Process has no end node."});
    }

    @Test
    void validateModel_MultipleInvalidBPMN2() throws IOException {
        String toValidate = new String(IoUtils.readBytesFromInputStream((InputStream)Objects.requireNonNull(JITBPMNService.class.getResourceAsStream("/MultipleInvalidModel.bpmn2"))));
        JITBPMNValidationResult retrieved = jitBpmnService.validateModel(toValidate);
        Assertions.assertThat((Object)retrieved).isNotNull();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)retrieved.getErrors()).isNotNull()).hasSize(4);
        Assertions.assertThat((Collection)retrieved.getErrors()).contains((Object[])new String[]{"Uri: (unknown) - Process id: invalid1 - name : invalid1-process-id - error : Process has no start node."});
        Assertions.assertThat((Collection)retrieved.getErrors()).contains((Object[])new String[]{"Uri: (unknown) - Process id: invalid1 - name : invalid1-process-id - error : Process has no end node."});
        Assertions.assertThat((Collection)retrieved.getErrors()).contains((Object[])new String[]{"Uri: (unknown) - Process id: invalid2 - name : invalid2-process-id - error : Process has no start node."});
        Assertions.assertThat((Collection)retrieved.getErrors()).contains((Object[])new String[]{"Uri: (unknown) - Process id: invalid2 - name : invalid2-process-id - error : Process has no end node."});
    }

    @Test
    void validateModel_SingleUnparsableBPMN2() throws IOException {
        String toValidate = new String(IoUtils.readBytesFromInputStream((InputStream)Objects.requireNonNull(JITBPMNService.class.getResourceAsStream("/SingleUnparsableModel.bpmn2"))));
        JITBPMNValidationResult retrieved = jitBpmnService.validateModel(toValidate);
        Assertions.assertThat((Object)retrieved).isNotNull();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)retrieved.getErrors()).isNotNull()).hasSize(1);
        Assertions.assertThat((Collection)retrieved.getErrors()).contains((Object[])new String[]{"Could not find message _T6T0kEcTEDuygKsUt0on2Q____"});
    }

    @Test
    void parseModelXml_SingleValidBPMN2() throws IOException {
        String toValidate = new String(IoUtils.readBytesFromInputStream((InputStream)Objects.requireNonNull(JITBPMNService.class.getResourceAsStream("/SingleProcess.bpmn2"))));
        Collection retrieved = JITBPMNServiceImpl.parseModelXml((String)toValidate);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)retrieved).isNotNull()).hasSize(1);
    }

    @Test
    void parseModelXml_MultipleValidBPMN2() throws IOException {
        String toValidate = new String(IoUtils.readBytesFromInputStream((InputStream)Objects.requireNonNull(JITBPMNService.class.getResourceAsStream("/MultipleProcess.bpmn2"))));
        Collection retrieved = JITBPMNServiceImpl.parseModelXml((String)toValidate);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)retrieved).isNotNull()).hasSize(2);
    }

    @Test
    void parseModelXml_UnparsableBPMN2() throws IOException {
        String toParse = new String(IoUtils.readBytesFromInputStream((InputStream)Objects.requireNonNull(JITBPMNService.class.getResourceAsStream("/UnparsableModel.bpmn2"))));
        RuntimeException thrown = (RuntimeException)org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> JITBPMNServiceImpl.parseModelXml((String)toParse), (String)"Expected parseModelXml to throw, but it didn't");
        String expectedMessage = "Could not parse";
        Assertions.assertThat((String)thrown.getMessage()).contains(new CharSequence[]{expectedMessage});
    }

    @Test
    void parseModelResource_SingleValidBPMN2() {
        Collection retrieved = JITBPMNServiceImpl.parseModelResource((Resource)new FileSystemResource(new File(JITBPMNService.class.getResource("/SingleProcess.bpmn2").getFile())));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)retrieved).isNotNull()).hasSize(1);
    }

    @Test
    void parseModelResource_MultipleValidBPMN2() {
        Collection retrieved = JITBPMNServiceImpl.parseModelResource((Resource)new FileSystemResource(new File(JITBPMNService.class.getResource("/MultipleProcess.bpmn2").getFile())));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)retrieved).isNotNull()).hasSize(2);
    }

    @Test
    void parseModelResource_UnparsableBPMN2() {
        FileSystemResource resource = new FileSystemResource(new File("/UnparsableModel.bpmn2"));
        RuntimeException thrown = (RuntimeException)org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> JITBPMNServiceImplTest.lambda$parseModelResource_UnparsableBPMN2$1((Resource)resource), (String)"Expected parseModelXml to throw, but it didn't");
        String expectedMessage = "Could not parse";
        Assertions.assertThat((String)thrown.getMessage()).contains(new CharSequence[]{expectedMessage});
    }

    @Test
    void getErrorString() {
        ProcessImpl process = new ProcessImpl();
        String id = StringUtils.generateUUID();
        String name = StringUtils.generateUUID();
        process.setId(id);
        process.setName(name);
        String message = StringUtils.generateUUID();
        ProcessValidationErrorImpl processValidationError = new ProcessValidationErrorImpl((Process)process, message);
        String expected = "Uri: (unknown) - Process id: " + id + " - name : " + name + " - error : " + message;
        String retrieved = JITBPMNServiceImpl.getErrorString((ProcessValidationError)processValidationError, null);
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
        String uri = "uri";
        expected = "Uri: " + uri + " - Process id: " + id + " - name : " + name + " - error : " + message;
        retrieved = JITBPMNServiceImpl.getErrorString((ProcessValidationError)processValidationError, (String)uri);
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
    }

    private static /* synthetic */ void lambda$parseModelResource_UnparsableBPMN2$1(Resource resource) throws Throwable {
        JITBPMNServiceImpl.parseModelResource((Resource)resource);
    }
}

