/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jitexecutor.bpmn.api;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.drools.util.IoUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jitexecutor.bpmn.JITBPMNService;
import org.kie.kogito.jitexecutor.common.requests.MultipleResourcesPayload;
import org.kie.kogito.jitexecutor.common.requests.ResourceWithURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QuarkusTest
public class BPMNValidatorResourceTest {
    private static final Logger LOG = LoggerFactory.getLogger(BPMNValidatorResourceTest.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final CollectionType LIST_OF_MSGS;

    @Test
    void test_SingleValidBPMN2() throws IOException {
        String toValidate = new String(IoUtils.readBytesFromInputStream((InputStream)Objects.requireNonNull(JITBPMNService.class.getResourceAsStream("/SingleProcess.bpmn2"))));
        String uri = "uri";
        String response = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)this.getMultipleResourcePayload(toValidate, uri)).when().post("/jitbpmn/validate", new Object[0])).then()).statusCode(200)).body(CoreMatchers.containsString((String)"[]"), new Matcher[0])).extract().asString();
        LOG.info("Validate response: {}", (Object)response);
        List messages = (List)MAPPER.readValue(response, (JavaType)LIST_OF_MSGS);
        Assertions.assertThat((List)messages).isEmpty();
    }

    @Test
    void validateModel_MultipleValidBPMN2() throws IOException {
        String toValidate = new String(IoUtils.readBytesFromInputStream((InputStream)Objects.requireNonNull(JITBPMNService.class.getResourceAsStream("/MultipleProcess.bpmn2"))));
        String uri = "uri";
        String response = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)this.getMultipleResourcePayload(toValidate, uri)).when().post("/jitbpmn/validate", new Object[0])).then()).statusCode(200)).body(CoreMatchers.containsString((String)"[]"), new Matcher[0])).extract().asString();
        LOG.info("Validate response: {}", (Object)response);
        List messages = (List)MAPPER.readValue(response, (JavaType)LIST_OF_MSGS);
        Assertions.assertThat((List)messages).isEmpty();
    }

    @Test
    void validateModel_SingleInvalidBPMN2() throws IOException {
        String toValidate = new String(IoUtils.readBytesFromInputStream((InputStream)Objects.requireNonNull(JITBPMNService.class.getResourceAsStream("/SingleInvalidModel.bpmn2"))));
        String uri = "uri";
        String response = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)this.getMultipleResourcePayload(toValidate, uri)).when().post("/jitbpmn/validate", new Object[0])).then()).statusCode(200)).body(CoreMatchers.containsString((String)"[\"Uri: uri - Process id: invalid - name : invalid-process-id - error : Process has no start node.\",\"Uri: uri - Process id: invalid - name : invalid-process-id - error : Process has no end node.\"]"), new Matcher[0])).extract().asString();
        LOG.info("Validate response: {}", (Object)response);
        List messages = (List)MAPPER.readValue(response, (JavaType)LIST_OF_MSGS);
        Assertions.assertThat((List)messages).hasSize(2);
    }

    @Test
    void validateModel_MultipleInvalidBPMN2() throws IOException {
        String toValidate = new String(IoUtils.readBytesFromInputStream((InputStream)Objects.requireNonNull(JITBPMNService.class.getResourceAsStream("/MultipleInvalidModel.bpmn2"))));
        String uri = "uri";
        String response = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)this.getMultipleResourcePayload(toValidate, uri)).when().post("/jitbpmn/validate", new Object[0])).then()).statusCode(200)).body(CoreMatchers.containsString((String)"[\"Uri: uri - Process id: invalid1 - name : invalid1-process-id - error : Process has no start node.\",\"Uri: uri - Process id: invalid1 - name : invalid1-process-id - error : Process has no end node.\",\"Uri: uri - Process id: invalid2 - name : invalid2-process-id - error : Process has no start node.\",\"Uri: uri - Process id: invalid2 - name : invalid2-process-id - error : Process has no end node.\"]"), new Matcher[0])).extract().asString();
        LOG.info("Validate response: {}", (Object)response);
        List messages = (List)MAPPER.readValue(response, (JavaType)LIST_OF_MSGS);
        Assertions.assertThat((List)messages).hasSize(4);
    }

    @Test
    void validateModel_MultipleBPMN2() throws IOException {
        String validModel = new String(IoUtils.readBytesFromInputStream((InputStream)Objects.requireNonNull(JITBPMNService.class.getResourceAsStream("/SingleProcess.bpmn2"))));
        String invalidModel = new String(IoUtils.readBytesFromInputStream((InputStream)Objects.requireNonNull(JITBPMNService.class.getResourceAsStream("/SingleInvalidModel.bpmn2"))));
        ResourceWithURI validResource = new ResourceWithURI("UriValid", validModel);
        ResourceWithURI invalidResource = new ResourceWithURI("UriInvalid", invalidModel);
        String response = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)new MultipleResourcesPayload("mainUri", Arrays.asList(validResource, invalidResource))).when().post("/jitbpmn/validate", new Object[0])).then()).statusCode(200)).body(CoreMatchers.containsString((String)"[\"Uri: UriInvalid - Process id: invalid - name : invalid-process-id - error : Process has no start node.\",\"Uri: UriInvalid - Process id: invalid - name : invalid-process-id - error : Process has no end node.\"]"), new Matcher[0])).extract().asString();
        LOG.info("Validate response: {}", (Object)response);
        List messages = (List)MAPPER.readValue(response, (JavaType)LIST_OF_MSGS);
        Assertions.assertThat((List)messages).hasSize(2);
    }

    @Test
    void validateModel_SingleUnparsablePMN2() throws IOException {
        String toValidate = new String(IoUtils.readBytesFromInputStream((InputStream)Objects.requireNonNull(JITBPMNService.class.getResourceAsStream("/SingleUnparsableModel.bpmn2"))));
        String uri = "uri";
        String response = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)this.getMultipleResourcePayload(toValidate, uri)).when().post("/jitbpmn/validate", new Object[0])).then()).statusCode(200)).body(CoreMatchers.containsString((String)"[\"Could not find message _T6T0kEcTEDuygKsUt0on2Q____\"]"), new Matcher[0])).extract().asString();
        LOG.info("Validate response: {}", (Object)response);
        List messages = (List)MAPPER.readValue(response, (JavaType)LIST_OF_MSGS);
        Assertions.assertThat((List)messages).hasSize(1);
    }

    private MultipleResourcesPayload getMultipleResourcePayload(String content, String uri) {
        return new MultipleResourcesPayload(uri, Collections.singletonList(new ResourceWithURI(uri, content)));
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        LIST_OF_MSGS = MAPPER.getTypeFactory().constructCollectionType(List.class, String.class);
    }
}

