/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jitexecutor.bpmn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.drools.io.InputStreamResource;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNExtensionsSemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.compiler.xml.SemanticModule;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.compiler.xml.core.SemanticModules;
import org.jbpm.process.core.validation.ProcessValidationError;
import org.jbpm.ruleflow.core.validation.RuleFlowProcessValidator;
import org.kie.api.definition.process.Process;
import org.kie.api.io.Resource;
import org.kie.kogito.jitexecutor.bpmn.JITBPMNService;
import org.kie.kogito.jitexecutor.bpmn.responses.JITBPMNValidationResult;
import org.kie.kogito.jitexecutor.common.requests.MultipleResourcesPayload;
import org.kie.kogito.jitexecutor.common.requests.ResourceWithURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@ApplicationScoped
public class JITBPMNServiceImpl
implements JITBPMNService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JITBPMNServiceImpl.class);
    private static final RuleFlowProcessValidator PROCESS_VALIDATOR = RuleFlowProcessValidator.getInstance();
    private static final SemanticModules BPMN_SEMANTIC_MODULES = new SemanticModules();
    private static String ERROR_TEMPLATE = "Uri: %s - Process id: %s - name : %s - error : %s";

    @Override
    public JITBPMNValidationResult validatePayload(MultipleResourcesPayload payload) {
        ArrayList<String> errors = new ArrayList<String>();
        for (ResourceWithURI resourceWithURI : payload.getResources()) {
            errors.addAll(JITBPMNServiceImpl.collectErrors(resourceWithURI.getContent(), resourceWithURI.getURI()));
        }
        return new JITBPMNValidationResult(errors);
    }

    @Override
    public JITBPMNValidationResult validateModel(String modelXML) {
        LOGGER.trace("Received\n{}", (Object)modelXML);
        Collection<String> errors = JITBPMNServiceImpl.collectErrors(modelXML, null);
        return new JITBPMNValidationResult(errors);
    }

    static Collection<String> collectErrors(String modelXML, String resourceUri) {
        ArrayList<String> toReturn;
        LOGGER.trace("Received\n{}", (Object)modelXML);
        try {
            Collection<Process> processes = JITBPMNServiceImpl.parseModelXml(modelXML);
            if (processes.isEmpty()) {
                Object error = "No process found";
                if (resourceUri != null) {
                    error = (String)error + " on resource " + resourceUri;
                }
                toReturn = Collections.singleton(error);
            } else {
                ProcessValidationError[] processValidationErrors;
                toReturn = new ArrayList();
                for (ProcessValidationError processValidationError : processValidationErrors = JITBPMNServiceImpl.validateProcesses(processes)) {
                    toReturn.add(JITBPMNServiceImpl.getErrorString(processValidationError, resourceUri));
                }
            }
        }
        catch (Throwable e) {
            String error = e.getMessage() != null && !e.getMessage().isEmpty() ? e.getMessage() : e.toString();
            toReturn = Collections.singleton(error);
            LOGGER.error("Fail to validate", e);
        }
        return toReturn;
    }

    static ProcessValidationError[] validateProcesses(Collection<Process> processes) {
        ProcessValidationError[] toReturn = new ProcessValidationError[]{};
        for (Process toValidate : processes) {
            ProcessValidationError[] toAdd = PROCESS_VALIDATOR.validateProcess(toValidate);
            ProcessValidationError[] temp = new ProcessValidationError[toReturn.length + toAdd.length];
            System.arraycopy(toReturn, 0, temp, 0, toReturn.length);
            System.arraycopy(toAdd, 0, temp, temp.length - toAdd.length, toAdd.length);
            toReturn = temp;
        }
        return toReturn;
    }

    static Collection<Process> parseModelXml(String modelXML) {
        InputStreamResource r = new InputStreamResource((InputStream)new ByteArrayInputStream(modelXML.getBytes()));
        return JITBPMNServiceImpl.parseModelResource((Resource)r);
    }

    static Collection<Process> parseModelResource(Resource r) {
        List list;
        block8: {
            Reader reader = r.getReader();
            try {
                XmlProcessReader xmlReader = new XmlProcessReader(BPMN_SEMANTIC_MODULES, Thread.currentThread().getContextClassLoader());
                list = xmlReader.read(reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SAXException e) {
                    throw new RuntimeException("Could not parse " + r, e);
                }
            }
            reader.close();
        }
        return list;
    }

    static String getErrorString(ProcessValidationError processValidationError, String resourceUri) {
        Process failed = processValidationError.getProcess();
        String uri = resourceUri != null ? resourceUri : "(unknown)";
        return String.format(ERROR_TEMPLATE, uri, failed.getId(), failed.getName(), processValidationError.getMessage());
    }

    static {
        BPMN_SEMANTIC_MODULES.addSemanticModule((SemanticModule)new BPMNSemanticModule());
        BPMN_SEMANTIC_MODULES.addSemanticModule((SemanticModule)new BPMNExtensionsSemanticModule());
        BPMN_SEMANTIC_MODULES.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
    }
}

