/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jitexecutor.dmn.api;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.kie.dmn.core.internal.utils.MarshallingStubUtils;
import org.kie.kogito.dmn.rest.KogitoDMNResult;
import org.kie.kogito.jitexecutor.dmn.JITDMNService;
import org.kie.kogito.jitexecutor.dmn.requests.JITDMNPayload;
import org.kie.kogito.jitexecutor.dmn.responses.DMNResultWithExplanation;

@Path(value="/jitdmn")
public class JITDMNResource {
    @Inject
    JITDMNService jitdmnService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response jitdmn(JITDMNPayload payload) {
        KogitoDMNResult evaluateAll = this.jitdmnService.evaluateModel(payload.getModel(), payload.getContext());
        HashMap<String, Object> restResulk = new HashMap<String, Object>();
        for (Map.Entry kv : evaluateAll.getContext().getAll().entrySet()) {
            restResulk.put((String)kv.getKey(), MarshallingStubUtils.stubDMNResult(kv.getValue(), String::valueOf));
        }
        return Response.ok(restResulk).build();
    }

    @POST
    @Path(value="/dmnresult")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response jitdmnResult(JITDMNPayload payload) {
        KogitoDMNResult dmnResult = this.jitdmnService.evaluateModel(payload.getModel(), payload.getContext());
        return Response.ok((Object)dmnResult).build();
    }

    @POST
    @Path(value="/evaluateAndExplain")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response jitEvaluateAndExplain(JITDMNPayload payload) {
        DMNResultWithExplanation response = this.jitdmnService.evaluateModelAndExplain(payload.getModel(), payload.getContext());
        return Response.ok((Object)response).build();
    }
}

