/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jitexecutor.dmn.api;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.kie.api.io.Resource;
import org.kie.dmn.core.compiler.profiles.ExtendedDMNProfile;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.DMNValidatorFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.kogito.dmn.rest.KogitoDMNMessage;
import org.kie.kogito.jitexecutor.dmn.requests.MultipleResourcesPayload;
import org.kie.kogito.jitexecutor.dmn.requests.ResourceWithURI;
import org.kie.kogito.jitexecutor.dmn.utils.ResolveByKey;

@Path(value="jitdmn/validate")
public class ValidationResource {
    static final DMNValidator validator = DMNValidatorFactory.newValidator(Arrays.asList(new ExtendedDMNProfile()));

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json"})
    public Response schema(String payload) {
        List validate = validator.validate((Reader)new StringReader(payload), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        List result = validate.stream().map(KogitoDMNMessage::of).collect(Collectors.toList());
        return Response.ok(result).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response schema(MultipleResourcesPayload payload) {
        HashMap<String, Resource> resources = new HashMap<String, Resource>();
        for (ResourceWithURI r : payload.getResources()) {
            Resource readerResource = ResourceFactory.newReaderResource((Reader)new StringReader(r.getContent()), (String)"UTF-8");
            readerResource.setSourcePath(r.getURI());
            resources.put(r.getURI(), readerResource);
        }
        ResolveByKey rbk = new ResolveByKey(resources);
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE}).usingImports((x, y, locationURI) -> rbk.readerByKey(locationURI)).theseModels(rbk.allReaders().toArray(new Reader[0]));
        List result = validate.stream().map(KogitoDMNMessage::of).collect(Collectors.toList());
        return Response.ok(result).build();
    }
}

