/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jitexecutor.dmn;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import org.drools.core.util.IoUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.dmn.rest.KogitoDMNResult;
import org.kie.kogito.jitexecutor.dmn.JITDMNService;
import org.kie.kogito.jitexecutor.dmn.JITDMNServiceImpl;
import org.kie.kogito.jitexecutor.dmn.api.JITDMNResourceTest;
import org.kie.kogito.jitexecutor.dmn.responses.DMNResultWithExplanation;
import org.kie.kogito.trusty.service.common.responses.SaliencyResponse;

public class JITDMNServiceImplTest {
    private static String model;
    private static JITDMNService jitdmnService;

    @BeforeAll
    public static void setup() throws IOException {
        model = new String(IoUtils.readBytesFromInputStream((InputStream)JITDMNResourceTest.class.getResourceAsStream("/test.dmn")));
        jitdmnService = new JITDMNServiceImpl(300, 1);
    }

    @Test
    public void testModelEvaluation() {
        HashMap<String, Number> context = new HashMap<String, Number>();
        context.put("FICO Score", 800);
        context.put("DTI Ratio", 0.1);
        context.put("PITI Ratio", 0.1);
        KogitoDMNResult dmnResult = jitdmnService.evaluateModel(model, context);
        Assertions.assertEquals((Object)"xls2dmn", (Object)dmnResult.getModelName());
        Assertions.assertEquals((Object)"xls2dmn_741b355c-685c-4827-b13a-833da8321da4", (Object)dmnResult.getNamespace());
        Assertions.assertTrue((boolean)dmnResult.getMessages().isEmpty());
        Assertions.assertEquals((Object)"Approved", (Object)dmnResult.getDecisionResultByName("Loan Approval").getResult());
    }

    @Test
    public void testExplainability() throws IOException {
        String allTypesModel = new String(IoUtils.readBytesFromInputStream((InputStream)JITDMNResourceTest.class.getResourceAsStream("/allTypes.dmn")));
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("stringInput", "test");
        context.put("listOfStringInput", Collections.singletonList("test"));
        context.put("numberInput", 1);
        context.put("listOfNumbersInput", Collections.singletonList(1));
        context.put("booleanInput", true);
        context.put("listOfBooleansInput", Collections.singletonList(true));
        context.put("timeInput", "h09:00");
        context.put("dateInput", "2020-04-02");
        context.put("dateAndTimeInput", "2020-04-02T09:00:00");
        context.put("daysAndTimeDurationInput", "P1DT1H");
        context.put("yearsAndMonthDurationInput", "P1Y1M");
        HashMap<String, Object> complexInput = new HashMap<String, Object>();
        complexInput.put("aNestedListOfNumbers", Collections.singletonList(1));
        complexInput.put("aNestedString", "test");
        complexInput.put("aNestedComplexInput", Collections.singletonMap("doubleNestedNumber", 1));
        context.put("complexInput", complexInput);
        context.put("listOfComplexInput", Collections.singletonList(complexInput));
        DMNResultWithExplanation response = jitdmnService.evaluateModelAndExplain(allTypesModel, context);
        Assertions.assertNotNull((Object)response.dmnResult);
        Assertions.assertEquals((int)1, (int)response.dmnResult.getDecisionResults().size());
        Assertions.assertNotNull((Object)response.salienciesResponse);
        Assertions.assertEquals((int)1, (int)response.salienciesResponse.getSaliencies().size());
        Assertions.assertEquals((int)17, (int)((SaliencyResponse)response.salienciesResponse.getSaliencies().get(0)).getFeatureImportance().size());
    }
}

