/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jitexecutor.dmn.api;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.core.util.IoUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNResult;
import org.kie.kogito.jitexecutor.dmn.requests.JITDMNPayload;
import org.kie.kogito.jitexecutor.dmn.requests.MultipleResourcesPayload;
import org.kie.kogito.jitexecutor.dmn.requests.ResourceWithURI;
import org.kie.kogito.jitexecutor.dmn.responses.JITDMNDecisionResult;
import org.kie.kogito.jitexecutor.dmn.responses.JITDMNMessage;
import org.kie.kogito.jitexecutor.dmn.responses.JITDMNResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QuarkusTest
public class MultipleModelsTest {
    private static final Logger LOG = LoggerFactory.getLogger(MultipleModelsTest.class);
    private static final String URI1 = "/multiple/importing.dmn";
    private static final String URI2 = "/multiple/stdlib.dmn";
    private static ResourceWithURI model1;
    private static ResourceWithURI model2;
    private static final String XAIURI1 = "/test.dmn";
    private static ResourceWithURI xaimodel1;
    private static final String CH11URI1 = "/multiple/Chapter 11 Example.dmn";
    private static final String CH11URI2 = "/multiple/Financial.dmn";
    private static ResourceWithURI ch11model1;
    private static ResourceWithURI ch11model2;
    private static final ObjectMapper MAPPER;
    private static final CollectionType LIST_OF_MSGS;

    @BeforeAll
    public static void setup() throws IOException {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
        model1 = new ResourceWithURI(URI1, new String(IoUtils.readBytesFromInputStream((InputStream)MultipleModelsTest.class.getResourceAsStream(URI1))));
        model2 = new ResourceWithURI(URI2, new String(IoUtils.readBytesFromInputStream((InputStream)MultipleModelsTest.class.getResourceAsStream(URI2))));
        xaimodel1 = new ResourceWithURI(XAIURI1, new String(IoUtils.readBytesFromInputStream((InputStream)MultipleModelsTest.class.getResourceAsStream(XAIURI1))));
        ch11model1 = new ResourceWithURI(CH11URI1, new String(IoUtils.readBytesFromInputStream((InputStream)MultipleModelsTest.class.getResourceAsStream(CH11URI1))));
        ch11model2 = new ResourceWithURI(CH11URI2, new String(IoUtils.readBytesFromInputStream((InputStream)MultipleModelsTest.class.getResourceAsStream(CH11URI2))));
    }

    @Test
    public void testForm() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)new MultipleResourcesPayload(URI1, List.of(model1, model2))).when().post("/jitdmn/schema/form", new Object[0])).then()).statusCode(200)).body(CoreMatchers.containsString((String)"InputSet"), new Matcher[]{CoreMatchers.containsString((String)"x-dmn-type"), CoreMatchers.containsString((String)"tPerson")});
    }

    @Test
    public void testSchema() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)new MultipleResourcesPayload(URI1, List.of(model1, model2))).when().post("/jitdmn/schema", new Object[0])).then()).statusCode(200)).body(CoreMatchers.containsString((String)"InputSet"), new Matcher[]{CoreMatchers.containsString((String)"x-dmn-type"), CoreMatchers.containsString((String)"tPerson"), CoreMatchers.containsString((String)"mainURI"), CoreMatchers.containsString((String)"URI")});
    }

    @Test
    public void testjitEndpoint() {
        JITDMNPayload jitdmnpayload = new JITDMNPayload(URI1, List.of(model1, model2), this.buildContext());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)jitdmnpayload).when().post("/jitdmn", new Object[0])).then()).statusCode(200)).body("'my decision'", CoreMatchers.is((Object)"Ciao, John Doe (age:47)."), new Object[0]);
    }

    private Map<String, Object> buildContext() {
        return Map.of("a person", Map.of("full name", "John Doe", "age", 47));
    }

    @Test
    public void testjitdmnResultEndpoint() {
        JITDMNPayload jitdmnpayload = new JITDMNPayload(URI1, List.of(model1, model2), this.buildContext());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)jitdmnpayload).when().post("/jitdmn/dmnresult", new Object[0])).then()).statusCode(200)).body("dmnContext.'my decision'", CoreMatchers.is((Object)"Ciao, John Doe (age:47)."), new Object[0]);
    }

    @Test
    public void testValidation() throws IOException {
        String response = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)new MultipleResourcesPayload(URI1, List.of(model1, model2))).when().post("/jitdmn/validate", new Object[0])).then()).statusCode(200)).body(CoreMatchers.containsString((String)"Variable named 'my decision' is missing its type reference"), new Matcher[0])).extract().asString();
        LOG.info("Validate response: {}", (Object)response);
        List messages = (List)MAPPER.readValue(response, (JavaType)LIST_OF_MSGS);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertThat((Object)((JITDMNMessage)messages.get(0))).hasFieldOrPropertyWithValue("path", (Object)URI1);
    }

    @Test
    public void testjitExplainabilityEndpoint() {
        JITDMNPayload jitdmnpayload = new JITDMNPayload(XAIURI1, List.of(xaimodel1, model1, model2), Map.of("FICO Score", 800, "DTI Ratio", 0.1, "PITI Ratio", 0.1));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)jitdmnpayload).when().post("/jitdmn/evaluateAndExplain", new Object[0])).then()).statusCode(200)).body(CoreMatchers.containsString((String)"dmnResult"), new Matcher[]{CoreMatchers.containsString((String)"saliencies"), CoreMatchers.containsString((String)"xls2dmn"), CoreMatchers.containsString((String)"featureName")});
    }

    @Test
    public void testjitEndpointCH11() {
        JITDMNPayload jitdmnpayload = new JITDMNPayload(CH11URI1, List.of(ch11model1, ch11model2), this.buildCH11Context());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)jitdmnpayload).when().post("/jitdmn", new Object[0])).then()).statusCode(200)).body("Strategy", CoreMatchers.is((Object)"THROUGH"), new Object[0]);
    }

    @Test
    public void testjitdmnResultEndpointCH11() {
        JITDMNPayload jitdmnpayload = new JITDMNPayload(CH11URI1, List.of(ch11model1, ch11model2), this.buildCH11Context());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)jitdmnpayload).when().post("/jitdmn/dmnresult", new Object[0])).then()).statusCode(200)).body("dmnContext.Strategy", CoreMatchers.is((Object)"THROUGH"), new Object[0]);
    }

    private Map<String, Object> buildCH11Context() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("Applicant data", Map.of("Age", 51, "MartitalStatus", "M", "EmploymentStatus", "EMPLOYED", "ExistingCustomer", false, "Monthly", Map.of("Income", 100000, "Repayments", 2500, "Expenses", 10000)));
        context.put("Bureau data", Map.of("Bankrupt", false, "CreditScore", 600));
        context.put("Requested product", Map.of("ProductType", "STANDARD LOAN", "Rate", 0.08, "Term", 36, "Amount", 10000));
        context.put("Supporting documents", null);
        return context;
    }

    @Test
    public void testjitdmnResultEndpointCH11_withErrors() throws Exception {
        HashMap<String, Map<String, Integer>> context = new HashMap<String, Map<String, Integer>>();
        context.put("Bureau data", Map.of("Bankrupt", false, "CreditScore", 600));
        context.put("Requested product", Map.of("ProductType", "STANDARD LOAN", "Rate", 0.08, "Term", 36, "Amount", 10000));
        JITDMNPayload jitdmnpayload = new JITDMNPayload(CH11URI1, List.of(ch11model1, ch11model2), context);
        String response = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)jitdmnpayload).when().post("/jitdmn/dmnresult", new Object[0])).then()).statusCode(200)).body("dmnContext.'Required monthly installment'", CoreMatchers.notNullValue(), new Object[0])).extract().asString();
        JITDMNResult result = (JITDMNResult)MAPPER.readValue(response, JITDMNResult.class);
        ((ListAssert)Assertions.assertThat((List)result.getMessages()).isNotEmpty()).allMatch(m -> m.getPath().equals(CH11URI1));
    }

    static {
        SimpleModule jitModule = new SimpleModule().addAbstractTypeMapping(DMNResult.class, JITDMNResult.class).addAbstractTypeMapping(DMNDecisionResult.class, JITDMNDecisionResult.class).addAbstractTypeMapping(DMNMessage.class, JITDMNMessage.class);
        MAPPER = new ObjectMapper().registerModule((Module)new Jdk8Module()).registerModule((Module)jitModule);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        LIST_OF_MSGS = MAPPER.getTypeFactory().constructCollectionType(List.class, JITDMNMessage.class);
    }
}

