/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jitexecutor.dmn;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNResult;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.PredictionOutput;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.jitexecutor.dmn.DMNEvaluator;

public class LocalDMNPredictionProvider
implements PredictionProvider {
    private static final String DUMMY_DMN_CONTEXT_KEY = "dummyDMNContext";
    private final DMNEvaluator dmnEvaluator;

    public LocalDMNPredictionProvider(DMNEvaluator dmnEvaluator) {
        this.dmnEvaluator = dmnEvaluator;
    }

    public CompletableFuture<List<PredictionOutput>> predictAsync(List<PredictionInput> inputs) {
        ArrayList<PredictionOutput> predictionOutputs = new ArrayList<PredictionOutput>();
        for (PredictionInput input : inputs) {
            Map contextVariables = (Map)this.toMap(input.getFeatures()).get(DUMMY_DMN_CONTEXT_KEY);
            predictionOutputs.add(LocalDMNPredictionProvider.toPredictionOutput(this.dmnEvaluator.evaluate(contextVariables)));
        }
        return CompletableFuture.completedFuture(predictionOutputs);
    }

    public static PredictionInput toPredictionInput(Map<String, Object> context) {
        return new PredictionInput(Collections.singletonList(FeatureFactory.newCompositeFeature((String)DUMMY_DMN_CONTEXT_KEY, context)));
    }

    public static PredictionOutput toPredictionOutput(DMNResult dmnResult) {
        ArrayList<Output> outputs = new ArrayList<Output>();
        for (DMNDecisionResult decisionResult : dmnResult.getDecisionResults()) {
            Output output = LocalDMNPredictionProvider.buildOutput(decisionResult);
            outputs.add(output);
        }
        return new PredictionOutput(outputs);
    }

    private static Output buildOutput(DMNDecisionResult dmnDecisionResult) {
        Feature result = FeatureFactory.parseFeatureValue((String)dmnDecisionResult.getDecisionName(), (Object)dmnDecisionResult.getResult());
        return new Output(dmnDecisionResult.getDecisionName(), result.getType(), result.getValue(), 1.0);
    }

    private Map<String, Object> toMap(List<Feature> features) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Feature f : features) {
            if (Type.COMPOSITE.equals((Object)f.getType())) {
                List compositeFeatures = (List)f.getValue().getUnderlyingObject();
                boolean isList = compositeFeatures.stream().allMatch(feature -> feature.getName().startsWith(f.getName() + "_"));
                if (isList) {
                    ArrayList<Object> objects = new ArrayList<Object>(compositeFeatures.size());
                    for (Feature fs : compositeFeatures) {
                        objects.add(fs.getValue().getUnderlyingObject());
                    }
                    map.put(f.getName(), objects);
                    continue;
                }
                HashMap<String, Object> maps = new HashMap<String, Object>();
                for (Feature cf : compositeFeatures) {
                    Map<String, Object> compositeFeatureMap = this.toMap(Collections.singletonList(cf));
                    maps.putAll(compositeFeatureMap);
                }
                map.put(f.getName(), maps);
                continue;
            }
            if (Type.UNDEFINED.equals((Object)f.getType())) {
                Feature underlyingFeature = (Feature)f.getValue().getUnderlyingObject();
                map.put(f.getName(), this.toMap(Collections.singletonList(underlyingFeature)));
                continue;
            }
            Object underlyingObject = f.getValue().getUnderlyingObject();
            map.put(f.getName(), underlyingObject);
        }
        return map;
    }
}

