/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jitexecutor.dmn.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import java.util.Map;
import org.kie.kogito.jitexecutor.dmn.requests.MultipleResourcesPayload;
import org.kie.kogito.jitexecutor.dmn.requests.ResourceWithURI;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JITDMNPayload
extends MultipleResourcesPayload {
    private String model;
    private Map<String, Object> context;

    public JITDMNPayload() {
    }

    public JITDMNPayload(String model, Map<String, Object> context) {
        this.model = model;
        this.context = context;
    }

    public JITDMNPayload(String mainURI, List<ResourceWithURI> resources, Map<String, Object> context) {
        super(mainURI, resources);
        this.context = context;
    }

    @Override
    public List<ResourceWithURI> getResources() {
        this.consistencyChecks();
        return super.getResources();
    }

    public String getModel() {
        this.consistencyChecks();
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    private void consistencyChecks() {
        if (this.model != null && this.getMainURI() != null && this.getResources() != null && this.getResources().size() > 0) {
            throw new IllegalStateException("JITDMNPayload should not contain both (main) model and resources collection");
        }
    }
}

