/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jitexecutor.dmn.api;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.drools.util.IoUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jitexecutor.dmn.requests.JITDMNPayload;

@QuarkusTest
public class JITDMNResourceTest {
    private static String model;
    private static String modelWithExtensionElements;

    @BeforeAll
    public static void setup() throws IOException {
        model = new String(IoUtils.readBytesFromInputStream((InputStream)JITDMNResourceTest.class.getResourceAsStream("/test.dmn")));
        modelWithExtensionElements = new String(IoUtils.readBytesFromInputStream((InputStream)JITDMNResourceTest.class.getResourceAsStream("/testWithExtensionElements.dmn")));
    }

    @Test
    public void testjitEndpoint() {
        JITDMNPayload jitdmnpayload = new JITDMNPayload(model, this.buildContext());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)jitdmnpayload).when().post("/jitdmn", new Object[0])).then()).statusCode(200)).body(CoreMatchers.containsString((String)"Loan Approval"), new Matcher[]{CoreMatchers.containsString((String)"Approved")});
    }

    @Test
    public void testjitdmnResultEndpoint() {
        JITDMNPayload jitdmnpayload = new JITDMNPayload(model, this.buildContext());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)jitdmnpayload).when().post("/jitdmn/dmnresult", new Object[0])).then()).statusCode(200)).body(CoreMatchers.containsString((String)"Loan Approval"), new Matcher[]{CoreMatchers.containsString((String)"Approved"), CoreMatchers.containsString((String)"xls2dmn")});
    }

    @Test
    public void testjitExplainabilityEndpoint() {
        JITDMNPayload jitdmnpayload = new JITDMNPayload(model, this.buildContext());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)jitdmnpayload).when().post("/jitdmn/evaluateAndExplain", new Object[0])).then()).statusCode(200)).body(CoreMatchers.containsString((String)"dmnResult"), new Matcher[]{CoreMatchers.containsString((String)"saliencies"), CoreMatchers.containsString((String)"xls2dmn"), CoreMatchers.containsString((String)"featureName")});
    }

    @Test
    public void testjitdmnWithExtensionElements() {
        HashMap<String, Integer> context = new HashMap<String, Integer>();
        context.put("m", 1);
        context.put("n", 2);
        JITDMNPayload jitdmnpayload = new JITDMNPayload(modelWithExtensionElements, context);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)jitdmnpayload).when().post("/jitdmn/dmnresult", new Object[0])).then()).statusCode(200)).body(CoreMatchers.containsString((String)"m"), new Matcher[]{CoreMatchers.containsString((String)"n"), CoreMatchers.containsString((String)"sum")});
    }

    private Map<String, Object> buildContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("FICO Score", 800);
        context.put("DTI Ratio", 0.1);
        context.put("PITI Ratio", 0.1);
        return context;
    }
}

