/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jitexecutor.dmn.responses;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import org.kie.api.builder.Message;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.internal.builder.InternalMessage;

public class JITDMNMessage
implements Serializable,
DMNMessage {
    private DMNMessageSeverityKS severity;
    private String message;
    private DMNMessageType messageType;
    private String sourceId;
    private String path;

    public static JITDMNMessage of(DMNMessage value) {
        JITDMNMessage res = new JITDMNMessage();
        res.severity = DMNMessageSeverityKS.of(value.getSeverity());
        res.message = value.getMessage();
        res.messageType = value.getMessageType();
        res.sourceId = value.getSourceId();
        res.path = value.getPath();
        return res;
    }

    public DMNMessage.Severity getSeverity() {
        return this.severity.asSeverity();
    }

    public String getMessage() {
        return this.message;
    }

    public DMNMessageType getMessageType() {
        return this.messageType;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    @JsonIgnore
    public Throwable getException() {
        throw new UnsupportedOperationException();
    }

    @JsonIgnore
    public FEELEvent getFeelEvent() {
        throw new UnsupportedOperationException();
    }

    @JsonIgnore
    public Object getSourceReference() {
        throw new UnsupportedOperationException();
    }

    @JsonIgnore
    public String getKieBaseName() {
        throw new UnsupportedOperationException();
    }

    @JsonIgnore
    public InternalMessage setKieBaseName(String kieBaseName) {
        throw new UnsupportedOperationException();
    }

    @JsonIgnore
    public long getId() {
        throw new UnsupportedOperationException();
    }

    public String getPath() {
        return this.path;
    }

    @JsonIgnore
    public int getLine() {
        throw new UnsupportedOperationException();
    }

    @JsonIgnore
    public int getColumn() {
        throw new UnsupportedOperationException();
    }

    public Message.Level getLevel() {
        switch (this.severity) {
            case ERROR: {
                return Message.Level.ERROR;
            }
            case INFO: {
                return Message.Level.INFO;
            }
            case WARN: {
                return Message.Level.WARNING;
            }
        }
        return Message.Level.ERROR;
    }

    @JsonIgnore
    public String getText() {
        throw new UnsupportedOperationException();
    }

    public static enum DMNMessageSeverityKS {
        INFO,
        WARN,
        ERROR;


        public static DMNMessageSeverityKS of(DMNMessage.Severity value) {
            switch (value) {
                case ERROR: {
                    return ERROR;
                }
                case INFO: {
                    return INFO;
                }
                case TRACE: {
                    return INFO;
                }
                case WARN: {
                    return WARN;
                }
            }
            return ERROR;
        }

        public DMNMessage.Severity asSeverity() {
            switch (this) {
                case ERROR: {
                    return DMNMessage.Severity.ERROR;
                }
                case INFO: {
                    return DMNMessage.Severity.INFO;
                }
                case WARN: {
                    return DMNMessage.Severity.WARN;
                }
            }
            return DMNMessage.Severity.ERROR;
        }
    }
}

