/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jitexecutor.dmn;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.kogito.dmn.rest.KogitoDMNResult;
import org.kie.kogito.explainability.Config;
import org.kie.kogito.explainability.local.lime.LimeConfig;
import org.kie.kogito.explainability.local.lime.LimeExplainer;
import org.kie.kogito.explainability.model.FeatureImportance;
import org.kie.kogito.explainability.model.PerturbationContext;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.Saliency;
import org.kie.kogito.jitexecutor.dmn.DMNEvaluator;
import org.kie.kogito.jitexecutor.dmn.JITDMNService;
import org.kie.kogito.jitexecutor.dmn.LocalDMNPredictionProvider;
import org.kie.kogito.jitexecutor.dmn.responses.DMNResultWithExplanation;
import org.kie.kogito.trusty.service.common.responses.FeatureImportanceResponse;
import org.kie.kogito.trusty.service.common.responses.SalienciesResponse;
import org.kie.kogito.trusty.service.common.responses.SaliencyResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JITDMNServiceImpl
implements JITDMNService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JITDMNServiceImpl.class);
    private static final String EXPLAINABILITY_FAILED = "FAILED";
    private static final String EXPLAINABILITY_FAILED_MESSAGE = "Failed to calculate values";
    private static final String EXPLAINABILITY_SUCCEEDED = "SUCCEEDED";
    @ConfigProperty(name="kogito.explainability.lime.sample-size", defaultValue="300")
    int explainabilityLimeSampleSize;
    @ConfigProperty(name="kogito.explainability.lime.no-of-perturbation", defaultValue="1")
    int explainabilityLimeNoOfPerturbation;

    public JITDMNServiceImpl() {
    }

    public JITDMNServiceImpl(int explainabilityLimeSampleSize, int explainabilityLimeNoOfPerturbation) {
        this.explainabilityLimeSampleSize = explainabilityLimeSampleSize;
        this.explainabilityLimeNoOfPerturbation = explainabilityLimeNoOfPerturbation;
    }

    @Override
    public KogitoDMNResult evaluateModel(String modelXML, Map<String, Object> context) {
        DMNEvaluator dmnEvaluator = DMNEvaluator.fromXML(modelXML);
        DMNResult dmnResult = dmnEvaluator.evaluate(context);
        return new KogitoDMNResult(dmnEvaluator.getNamespace(), dmnEvaluator.getName(), dmnResult);
    }

    @Override
    public DMNResultWithExplanation evaluateModelAndExplain(String modelXML, Map<String, Object> context) {
        Map saliencyMap;
        DMNEvaluator dmnEvaluator = DMNEvaluator.fromXML(modelXML);
        LocalDMNPredictionProvider localDMNPredictionProvider = new LocalDMNPredictionProvider(dmnEvaluator);
        DMNResult dmnResult = dmnEvaluator.evaluate(context);
        Prediction prediction = new Prediction(LocalDMNPredictionProvider.toPredictionInput(context), LocalDMNPredictionProvider.toPredictionOutput(dmnResult));
        LimeConfig limeConfig = new LimeConfig().withSamples(this.explainabilityLimeSampleSize).withPerturbationContext(new PerturbationContext(new Random(), this.explainabilityLimeNoOfPerturbation));
        LimeExplainer limeExplainer = new LimeExplainer(limeConfig);
        try {
            saliencyMap = (Map)limeExplainer.explainAsync(prediction, (PredictionProvider)localDMNPredictionProvider).get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            if (e instanceof InterruptedException) {
                LOGGER.error("Critical InterruptedException occurred", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            return new DMNResultWithExplanation(new KogitoDMNResult(dmnEvaluator.getNamespace(), dmnEvaluator.getName(), dmnResult), new SalienciesResponse(EXPLAINABILITY_FAILED, EXPLAINABILITY_FAILED_MESSAGE, null));
        }
        List<SaliencyResponse> saliencyResponses = this.buildSalienciesResponse(dmnEvaluator.getDmnModel(), saliencyMap);
        return new DMNResultWithExplanation(new KogitoDMNResult(dmnEvaluator.getNamespace(), dmnEvaluator.getName(), dmnResult), new SalienciesResponse(EXPLAINABILITY_SUCCEEDED, null, saliencyResponses));
    }

    private List<SaliencyResponse> buildSalienciesResponse(DMNModel dmnModel, Map<String, Saliency> saliencyMap) {
        ArrayList<SaliencyResponse> saliencyResponses = new ArrayList<SaliencyResponse>();
        for (Map.Entry<String, Saliency> entry : saliencyMap.entrySet()) {
            DecisionNode decisionByName = dmnModel.getDecisionByName(entry.getKey());
            saliencyResponses.add(new SaliencyResponse(decisionByName.getId(), decisionByName.getName(), entry.getValue().getPerFeatureImportance().stream().map(JITDMNServiceImpl::featureImportanceModelToResponse).filter(Objects::nonNull).collect(Collectors.toList())));
        }
        return saliencyResponses;
    }

    private static FeatureImportanceResponse featureImportanceModelToResponse(FeatureImportance model) {
        if (model == null) {
            return null;
        }
        return new FeatureImportanceResponse(model.getFeature().getName(), Double.valueOf(model.getScore()));
    }
}

