/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jitexecutor.dmn.api;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.schema.SchemaWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.kie.api.io.Resource;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.core.internal.utils.DMNRuntimeBuilder;
import org.kie.dmn.openapi.DMNOASGeneratorFactory;
import org.kie.dmn.openapi.model.DMNOASResult;
import org.kie.internal.io.ResourceFactory;

@Path(value="jitdmn/schema")
public class SchemaResource {
    static final OpenAPI x = (OpenAPI)OASFactory.createObject(OpenAPI.class);

    private static DMNModel modelFromXML(String modelXML) {
        Resource modelResource = ResourceFactory.newReaderResource((Reader)new StringReader(modelXML), (String)"UTF-8");
        DMNRuntime dmnRuntime = (DMNRuntime)DMNRuntimeBuilder.fromDefaults().buildConfiguration().fromResources(Collections.singletonList(modelResource)).getOrElseThrow(RuntimeException::new);
        return (DMNModel)dmnRuntime.getModels().get(0);
    }

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json"})
    public Response schema(String payload) {
        DMNModel dmnModel = SchemaResource.modelFromXML(payload);
        DMNOASResult oasResult = DMNOASGeneratorFactory.generator(Collections.singletonList(dmnModel)).build();
        ObjectNode jsNode = oasResult.getJsonSchemaNode();
        DMNType is = oasResult.lookupIOSetsByModel(dmnModel).getInputSet();
        String isRef = oasResult.getNamingPolicy().getRef(is);
        Schema schema = ((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.OBJECT);
        schema.addProperty("context", (Schema)((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.OBJECT).ref(isRef));
        schema.addProperty("model", ((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.STRING));
        ObjectNode schemasNode = jsNode.putObject("properties");
        for (Map.Entry entry : schema.getProperties().entrySet()) {
            SchemaWriter.writeSchema((ObjectNode)schemasNode, (Schema)((Schema)entry.getValue()), (String)((String)entry.getKey()));
        }
        jsNode.put("type", "object");
        jsNode.putArray("required").add("context").add("model");
        return Response.ok((Object)jsNode).build();
    }

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json"})
    @Path(value="form")
    public Response form(String payload) {
        DMNModel dmnModel = SchemaResource.modelFromXML(payload);
        DMNOASResult oasResult = DMNOASGeneratorFactory.generator(Collections.singletonList(dmnModel)).build();
        ObjectNode jsNode = oasResult.getJsonSchemaNode();
        DMNType is = oasResult.lookupIOSetsByModel(dmnModel).getInputSet();
        String isRef = oasResult.getNamingPolicy().getRef(is);
        jsNode.put("$ref", isRef);
        return Response.ok((Object)jsNode).build();
    }
}

