/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jitexecutor.dmn.api;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.drools.util.IoUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.kogito.jitexecutor.dmn.api.JITDMNResourceTest;
import org.kie.kogito.jitexecutor.dmn.responses.JITDMNMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QuarkusTest
public class DMNValidatorResourceTest {
    private static final Logger LOG = LoggerFactory.getLogger(DMNValidatorResourceTest.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final CollectionType LIST_OF_MSGS;

    @Test
    public void test() throws IOException {
        String MODEL = new String(IoUtils.readBytesFromInputStream((InputStream)JITDMNResourceTest.class.getResourceAsStream("/loan.dmn")));
        String response = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(MODEL).when().post("/jitdmn/validate", new Object[0])).then()).statusCode(200)).body(CoreMatchers.containsString((String)"Decision Table Analysis of table 'Preapproval' finished with no messages to be reported."), new Matcher[0])).extract().asString();
        LOG.info("Validate response: {}", (Object)response);
        List messages = (List)MAPPER.readValue(response, (JavaType)LIST_OF_MSGS);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertTrue((boolean)messages.stream().anyMatch(m -> m.getSourceId().equals("_E7994A2B-1189-4BE5-9382-891D48E87D47") && m.getMessage().equals("Decision Table Analysis of table 'Preapproval' finished with no messages to be reported.")));
    }

    @Test
    public void testOverlap() throws IOException {
        String MODEL = new String(IoUtils.readBytesFromInputStream((InputStream)JITDMNResourceTest.class.getResourceAsStream("/loan_withOverlap.dmn")));
        String response = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(MODEL).when().post("/jitdmn/validate", new Object[0])).then()).statusCode(200)).body(CoreMatchers.containsString((String)"Overlap detected"), new Matcher[0])).extract().asString();
        LOG.info("Validate response: {}", (Object)response);
        List messages = (List)MAPPER.readValue(response, (JavaType)LIST_OF_MSGS);
        Assertions.assertTrue((messages.size() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)messages.stream().anyMatch(m -> m.getSourceId().equals("_E7994A2B-1189-4BE5-9382-891D48E87D47") && m.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_OVERLAP_HITPOLICY_UNIQUE)));
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        LIST_OF_MSGS = MAPPER.getTypeFactory().constructCollectionType(List.class, JITDMNMessage.class);
    }
}

