/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.job.http.recipient.test;

import io.quarkus.test.QuarkusUnitTest;
import io.quarkus.test.common.QuarkusTestResource;
import io.smallrye.mutiny.helpers.test.UniAssertSubscriber;
import io.smallrye.mutiny.subscription.UniSubscriber;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.kie.kogito.job.http.recipient.HttpJobExecutor;
import org.kie.kogito.job.http.recipient.test.HttpRecipientResourceMock;
import org.kie.kogito.job.recipient.common.http.HTTPRequest;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipient;
import org.kie.kogito.jobs.service.model.JobDetails;
import org.kie.kogito.jobs.service.model.Recipient;
import org.kie.kogito.jobs.service.model.RecipientInstance;

@QuarkusTestResource(value=HttpRecipientResourceMock.class)
class JobHttpRecipientTest {
    @RegisterExtension
    static final QuarkusUnitTest unitTest = new QuarkusUnitTest().setArchiveProducer(() -> (JavaArchive)ShrinkWrap.create(JavaArchive.class));
    @Inject
    HttpJobExecutor httpJobExecutor;
    @ConfigProperty(name="mock.service.url")
    String mockServiceUrl;

    JobHttpRecipientTest() {
    }

    @Test
    void httpExecutorTest() {
        this.testRequest(HTTPRequest.HTTPMethod.DELETE);
        this.testRequest(HTTPRequest.HTTPMethod.GET);
        this.testRequest(HTTPRequest.HTTPMethod.POST);
        this.testRequest(HTTPRequest.HTTPMethod.PUT);
        this.testRequest(HTTPRequest.HTTPMethod.PATCH);
    }

    private void testRequest(HTTPRequest.HTTPMethod method) {
        HttpRecipient httpRecipient = HttpRecipient.builder().forStringPayload().method(method.name()).url(this.mockServiceUrl).build();
        JobDetails job = JobDetails.builder().id("12345").recipient((Recipient)new RecipientInstance((org.kie.kogito.jobs.service.api.Recipient)httpRecipient)).build();
        UniAssertSubscriber tester = (UniAssertSubscriber)this.httpJobExecutor.execute(job).invoke(response -> Assertions.assertThat((String)response.getJobId()).isEqualTo(job.getId())).invoke(response -> Assertions.assertThat((String)response.getCode()).isEqualTo("200")).invoke(response -> Assertions.assertThat((String)response.getMessage()).isEqualTo(method.name())).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
        tester.awaitItem();
    }
}

