/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.job.http.recipient.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.job.http.recipient.HttpJobExecutor;
import org.kie.kogito.job.http.recipient.HttpRecipientValidator;
import org.kie.kogito.job.http.recipient.deployment.JobHttpRecipientProcessor;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipient;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientBinaryPayloadData;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientJsonPayloadData;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientPayloadData;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientStringPayloadData;
import org.kie.kogito.jobs.service.api.schedule.cron.CronSchedule;
import org.kie.kogito.jobs.service.api.schedule.timer.TimerSchedule;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

class JobHttpRecipientProcessorTest {
    private final JobHttpRecipientProcessor processor = new JobHttpRecipientProcessor();

    JobHttpRecipientProcessorTest() {
    }

    @Test
    void feature() {
        Assertions.assertThat((String)this.processor.feature().getName()).isEqualTo("job-http-recipient");
    }

    @Test
    void additionalBeans() {
        AdditionalBeanBuildItem additionalBeans = this.processor.additionalBeans();
        Assertions.assertThat((List)additionalBeans.getBeanClasses()).containsExactlyInAnyOrder((Object[])new String[]{HttpJobExecutor.class.getName(), HttpRecipientValidator.class.getName()});
    }

    @Test
    void contributeClassesToIndex() {
        BuildProducer producer = (BuildProducer)Mockito.mock(BuildProducer.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(AdditionalIndexedClassesBuildItem.class);
        this.processor.contributeClassesToIndex(producer);
        ((BuildProducer)Mockito.verify((Object)producer)).produce((BuildItem)((AdditionalIndexedClassesBuildItem)captor.capture()));
        AdditionalIndexedClassesBuildItem buildItem = (AdditionalIndexedClassesBuildItem)captor.getValue();
        Assertions.assertThat((Object)buildItem).isNotNull();
        Assertions.assertThat((Collection)buildItem.getClassesToIndex()).containsExactlyInAnyOrder((Object[])new String[]{HttpRecipient.class.getName(), HttpRecipientPayloadData.class.getName(), HttpRecipientStringPayloadData.class.getName(), HttpRecipientBinaryPayloadData.class.getName(), HttpRecipientJsonPayloadData.class.getName(), CronSchedule.class.getName(), TimerSchedule.class.getName()});
    }
}

