/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.job.http.recipient;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.core.buffer.Buffer;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.kie.kogito.job.http.recipient.HttpJobExecutor;
import org.kie.kogito.job.recipient.common.http.HTTPRequestExecutorTest;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipient;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientPayloadData;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientStringPayloadData;
import org.kie.kogito.jobs.service.model.JobDetails;
import org.kie.kogito.jobs.service.model.Recipient;
import org.kie.kogito.jobs.service.model.RecipientInstance;
import org.kie.kogito.jobs.service.utils.DateUtil;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.SimpleTimerTrigger;

class HttpJobExecutorTest
extends HTTPRequestExecutorTest<HttpRecipient<?>, HttpJobExecutor> {
    HttpJobExecutorTest() {
    }

    protected HttpJobExecutor createExecutor(long timeout, Vertx vertx, ObjectMapper objectMapper) {
        return new HttpJobExecutor(timeout, vertx, objectMapper);
    }

    protected void assertExecuteConditions() {
        ((MapAssert)Assertions.assertThat((Map)((Map)this.queryParamsCaptor.getValue())).hasSize(1)).containsEntry((Object)"limit", (Object)"0");
        this.assertCommonBuffer();
    }

    protected void assertExecuteWithErrorConditions() {
        this.assertExecuteConditions();
    }

    protected void assertExecutePeriodicConditions() {
        ((MapAssert)Assertions.assertThat((Map)((Map)this.queryParamsCaptor.getValue())).hasSize(1)).containsEntry((Object)"limit", (Object)"10");
        this.assertCommonBuffer();
    }

    private void assertCommonBuffer() {
        ((ObjectAssert)Assertions.assertThat((Object)((Buffer)this.bufferCaptor.getValue())).isNotNull()).hasToString("JOB_DATA");
    }

    protected JobDetails createSimpleJob() {
        HttpRecipient recipient = HttpRecipient.builder().forStringPayload().payload((HttpRecipientPayloadData)HttpRecipientStringPayloadData.from((String)"JOB_DATA")).url("http://localhost:8080/my-service").build();
        return JobDetails.builder().recipient((Recipient)new RecipientInstance((org.kie.kogito.jobs.service.api.Recipient)recipient)).id("JOB_ID").build();
    }

    protected JobDetails createPeriodicJob() {
        HttpRecipient recipient = HttpRecipient.builder().forStringPayload().payload((HttpRecipientPayloadData)HttpRecipientStringPayloadData.from((String)"JOB_DATA")).url("http://localhost:8080/my-service").build();
        return JobDetails.builder().id("JOB_ID").recipient((Recipient)new RecipientInstance((org.kie.kogito.jobs.service.api.Recipient)recipient)).trigger((Trigger)new SimpleTimerTrigger(DateUtil.toDate((OffsetDateTime)OffsetDateTime.now()), 1L, ChronoUnit.MILLIS, 10, null)).build();
    }
}

